/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.query.QueryCancelledException;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFatalException;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.util.PrintSerializableBase;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.NoSuchElementException;
import org.openjena.atlas.logging.Log;

public abstract class QueryIteratorBase
extends PrintSerializableBase
implements QueryIterator {
    public static boolean traceIterators = false;
    private boolean finished = false;
    private boolean requestingCancel = false;
    private volatile boolean abortIterator = false;
    private Throwable stackTrace = null;

    public QueryIteratorBase() {
        if (traceIterators) {
            this.stackTrace = new Throwable();
        }
    }

    protected abstract boolean hasNextBinding();

    protected abstract Binding moveToNextBinding();

    protected abstract void closeIterator();

    protected abstract void requestCancel();

    protected boolean isFinished() {
        return this.finished;
    }

    public final boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.abortIterator) {
            throw new QueryCancelledException();
        }
        boolean r = this.hasNextBinding();
        if (!r) {
            try {
                this.close();
            }
            catch (QueryFatalException ex) {
                Log.fatal(this, "Fatal exception: " + ex.getMessage());
                this.abort();
                throw ex;
            }
        }
        return r;
    }

    public final Binding next() {
        return this.nextBinding();
    }

    public final Binding nextBinding() {
        try {
            if (this.abortIterator) {
                throw new QueryCancelledException();
            }
            if (this.finished) {
                if (this.abortIterator) {
                    throw new QueryCancelledException();
                }
                throw new NoSuchElementException(Utils.className(this));
            }
            if (!this.hasNextBinding()) {
                throw new NoSuchElementException(Utils.className(this));
            }
            Binding obj = this.moveToNextBinding();
            if (obj == null) {
                throw new NoSuchElementException(Utils.className(this));
            }
            if (this.requestingCancel && !this.finished) {
                this.close();
            }
            return obj;
        }
        catch (QueryFatalException ex) {
            Log.fatal(this, "QueryFatalException", (Throwable)((Object)ex));
            this.abort();
            throw ex;
        }
    }

    public final void remove() {
        Log.warn(this, "Call to QueryIterator.remove() : " + Utils.className(this) + ".remove");
        throw new UnsupportedOperationException(Utils.className(this) + ".remove");
    }

    public void close() {
        if (this.finished) {
            return;
        }
        try {
            this.closeIterator();
        }
        catch (QueryException ex) {
            Log.warn(this, "QueryException in close()", (Throwable)((Object)ex));
        }
        this.finished = true;
    }

    @Deprecated
    public void abort() {
        if (this.finished) {
            return;
        }
        try {
            this.closeIterator();
        }
        catch (QueryException queryException) {
            // empty catch block
        }
        this.finished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        if (!this.requestingCancel) {
            QueryIteratorBase queryIteratorBase = this;
            synchronized (queryIteratorBase) {
                this.requestCancel();
                this.requestingCancel = true;
                this.abortIterator = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelAllowContinue() {
        if (!this.requestingCancel) {
            QueryIteratorBase queryIteratorBase = this;
            synchronized (queryIteratorBase) {
                this.requestCancel();
                this.requestingCancel = true;
            }
        }
    }

    protected static void performClose(QueryIterator iter) {
        if (iter == null) {
            return;
        }
        iter.close();
    }

    protected static void performRequestCancel(QueryIterator iter) {
        if (iter == null) {
            return;
        }
        iter.cancel();
    }

    public String debug() {
        String s = "";
        if (this.stackTrace != null) {
            for (int i = 0; i < this.stackTrace.getStackTrace().length; ++i) {
                StackTraceElement e2 = this.stackTrace.getStackTrace()[i];
                if (e2.getMethodName().equals("<init>")) continue;
                s = s + e2.toString();
                break;
            }
        }
        return s;
    }
}

