/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.maven;

import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.validation.ValidationErrorMode;
import com.googlecode.flyway.maven.AbstractFlywayMojo;
import java.io.File;

abstract class AbstractMigrationLoadingMojo
extends AbstractFlywayMojo {
    private String[] locations;
    private String encoding;
    private String sqlMigrationPrefix;
    private String sqlMigrationSuffix;
    @Deprecated
    private String validationErrorMode;
    private boolean cleanOnValidationError;
    private String target;
    private boolean outOfOrder;

    AbstractMigrationLoadingMojo() {
    }

    protected final void doExecute(Flyway flyway) throws Exception {
        String locationsProperty = this.getProperty("flyway.locations");
        if (locationsProperty != null) {
            this.locations = StringUtils.tokenizeToStringArray((String)locationsProperty, (String)",");
        }
        if (this.locations != null) {
            for (int i = 0; i < this.locations.length; ++i) {
                if (!this.locations[i].startsWith("filesystem:")) continue;
                String newLocation = this.locations[i].substring("filesystem:".length());
                File file = new File(newLocation);
                if (!file.isAbsolute()) {
                    file = new File(this.mavenProject.getBasedir(), newLocation);
                }
                this.locations[i] = "filesystem:" + file.getAbsolutePath();
            }
            flyway.setLocations(this.locations);
        }
        if (this.encoding != null) {
            flyway.setEncoding(this.encoding);
        }
        if (this.sqlMigrationPrefix != null) {
            flyway.setSqlMigrationPrefix(this.sqlMigrationPrefix);
        }
        if (this.sqlMigrationSuffix != null) {
            flyway.setSqlMigrationSuffix(this.sqlMigrationSuffix);
        }
        if (this.validationErrorMode != null) {
            flyway.setValidationErrorMode(ValidationErrorMode.valueOf((String)this.validationErrorMode.toUpperCase()));
        }
        flyway.setCleanOnValidationError(this.cleanOnValidationError);
        flyway.setOutOfOrder(this.outOfOrder);
        if (this.target != null) {
            flyway.setTarget(new MigrationVersion(this.target));
        }
        this.doExecuteWithMigrationConfig(flyway);
    }

    protected abstract void doExecuteWithMigrationConfig(Flyway var1) throws Exception;
}

