/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.internal;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DateTimeAdapter
extends TypeAdapter<DateTime> {
    public DateTime read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        String timeZoneId = "";
        long secondsSinceEpoch = 0L;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("text")) {
                reader.nextString();
                continue;
            }
            if (name.equals("time_zone")) {
                timeZoneId = reader.nextString();
                continue;
            }
            if (!name.equals("value")) continue;
            secondsSinceEpoch = reader.nextLong();
        }
        reader.endObject();
        return new DateTime(secondsSinceEpoch * 1000L, DateTimeZone.forID((String)timeZoneId));
    }

    public void write(JsonWriter writer, DateTime value) throws IOException {
        throw new RuntimeException("Unimplemented method");
    }
}

