/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.SourceAst;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.JsFileParser;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CompilerInput
implements SourceAst,
DependencyInfo {
    private static final long serialVersionUID = 1L;
    private JSModule module;
    private final InputId id;
    private final SourceAst ast;
    private boolean isModuleFile = false;
    private final Set<String> provides = Sets.newHashSet();
    private final Set<String> requires = Sets.newHashSet();
    private boolean generatedDependencyInfoFromSource = false;
    private transient AbstractCompiler compiler;

    public CompilerInput(SourceAst ast) {
        this(ast, ast.getSourceFile().getName(), false);
    }

    public CompilerInput(SourceAst ast, boolean isExtern) {
        this(ast, ast.getInputId(), isExtern);
    }

    public CompilerInput(SourceAst ast, String inputId, boolean isExtern) {
        this(ast, new InputId(inputId), isExtern);
    }

    public CompilerInput(SourceAst ast, InputId inputId, boolean isExtern) {
        this.ast = ast;
        this.id = inputId;
        if (ast != null && ast.getSourceFile() != null) {
            ast.getSourceFile().setIsExtern(isExtern);
        }
    }

    public CompilerInput(SourceFile file) {
        this(file, false);
    }

    public CompilerInput(SourceFile file, boolean isExtern) {
        this(new JsAst(file), isExtern);
    }

    @Override
    public InputId getInputId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.id.getIdName();
    }

    public SourceAst getAst() {
        return this.ast;
    }

    @Override
    public String getPathRelativeToClosureBase() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getAstRoot(AbstractCompiler compiler) {
        Node root = this.ast.getAstRoot(compiler);
        if (root != null) {
            Preconditions.checkState((boolean)root.isScript());
            Preconditions.checkNotNull((Object)root.getInputId());
        }
        return root;
    }

    @Override
    public void clearAst() {
        this.ast.clearAst();
    }

    @Override
    public SourceFile getSourceFile() {
        return this.ast.getSourceFile();
    }

    @Override
    public void setSourceFile(SourceFile file) {
        this.ast.setSourceFile(file);
    }

    public SourceAst getSourceAst() {
        return this.ast;
    }

    public void setCompiler(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    private void checkErrorManager() {
        Preconditions.checkNotNull((Object)this.compiler, (Object)("Expected setCompiler to be called first: " + this));
        Preconditions.checkNotNull((Object)this.compiler.getErrorManager(), (Object)("Expected compiler to call an error manager: " + this));
    }

    @Override
    public Collection<String> getRequires() {
        this.checkErrorManager();
        try {
            this.regenerateDependencyInfoIfNecessary();
            return Collections.unmodifiableSet(this.requires);
        }
        catch (IOException e) {
            this.compiler.getErrorManager().report(CheckLevel.ERROR, JSError.make(AbstractCompiler.READ_ERROR, this.getName()));
            return ImmutableList.of();
        }
    }

    @Override
    public Collection<String> getProvides() {
        this.checkErrorManager();
        try {
            this.regenerateDependencyInfoIfNecessary();
            return Collections.unmodifiableSet(this.provides);
        }
        catch (IOException e) {
            this.compiler.getErrorManager().report(CheckLevel.ERROR, JSError.make(AbstractCompiler.READ_ERROR, this.getName()));
            return ImmutableList.of();
        }
    }

    void addProvide(String provide) {
        this.getProvides();
        this.provides.add(provide);
    }

    void addRequire(String require) {
        this.getRequires();
        this.requires.add(require);
    }

    public void removeRequire(String require) {
        this.getRequires();
        this.requires.remove(require);
    }

    private void regenerateDependencyInfoIfNecessary() throws IOException {
        if (!(this.ast instanceof JsAst)) {
            Preconditions.checkNotNull((Object)this.compiler, (Object)"Expected setCompiler to be called first");
            DepsFinder finder = new DepsFinder();
            Node root = this.getAstRoot(this.compiler);
            if (root == null) {
                return;
            }
            finder.visitTree(this.getAstRoot(this.compiler));
            this.isModuleFile = finder.isModuleFile;
            this.provides.addAll(finder.provides);
            this.requires.addAll(finder.requires);
        } else if (!this.generatedDependencyInfoFromSource) {
            DependencyInfo info = new JsFileParser(this.compiler.getErrorManager()).setIncludeGoogBase(true).parseFile(this.getName(), this.getName(), this.getCode());
            this.isModuleFile = info.isModule();
            this.provides.addAll(info.getProvides());
            this.requires.addAll(info.getRequires());
            this.generatedDependencyInfoFromSource = true;
        }
    }

    public String getLine(int lineNumber) {
        return this.getSourceFile().getLine(lineNumber);
    }

    public Region getRegion(int lineNumber) {
        return this.getSourceFile().getRegion(lineNumber);
    }

    public String getCode() throws IOException {
        return this.getSourceFile().getCode();
    }

    public JSModule getModule() {
        return this.module;
    }

    public void setModule(JSModule module) {
        Preconditions.checkArgument((module == null || this.module == null || this.module == module ? 1 : 0) != 0);
        this.module = module;
    }

    void overrideModule(JSModule module) {
        this.module = module;
    }

    public boolean isExtern() {
        if (this.ast == null || this.ast.getSourceFile() == null) {
            return false;
        }
        return this.ast.getSourceFile().isExtern();
    }

    void setIsExtern(boolean isExtern) {
        if (this.ast == null || this.ast.getSourceFile() == null) {
            return;
        }
        this.ast.getSourceFile().setIsExtern(isExtern);
    }

    public int getLineOffset(int lineno) {
        return this.ast.getSourceFile().getLineOffset(lineno);
    }

    public int getNumLines() {
        return this.ast.getSourceFile().getNumLines();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isModule() {
        return this.isModuleFile;
    }

    private static class DepsFinder {
        private boolean isModuleFile;
        private final List<String> provides = Lists.newArrayList();
        private final List<String> requires = Lists.newArrayList();
        private final CodingConvention codingConvention = new ClosureCodingConvention();

        private DepsFinder() {
        }

        void visitTree(Node n) {
            this.visitSubtree(n, null);
        }

        void visitSubtree(Node n, Node parent) {
            if (n.isCall()) {
                String provide;
                String require;
                boolean isModuleDetected = this.codingConvention.extractIsModuleFile(n, parent);
                if (isModuleDetected) {
                    this.isModuleFile = true;
                }
                if ((require = this.codingConvention.extractClassNameIfRequire(n, parent)) != null) {
                    this.requires.add(require);
                }
                if ((provide = this.codingConvention.extractClassNameIfProvide(n, parent)) != null) {
                    this.provides.add(provide);
                }
                return;
            }
            if (parent != null && !parent.isExprResult() && !parent.isScript()) {
                return;
            }
            for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                this.visitSubtree(child, n);
            }
        }
    }
}

