/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ScriptRuntime;
import com.google.javascript.rhino.jstype.AllType;
import com.google.javascript.rhino.jstype.ArrowType;
import com.google.javascript.rhino.jstype.BooleanType;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.ErrorFunctionType;
import com.google.javascript.rhino.jstype.FunctionBuilder;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionPrototypeType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.IndexedType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.NoObjectType;
import com.google.javascript.rhino.jstype.NoType;
import com.google.javascript.rhino.jstype.NullType;
import com.google.javascript.rhino.jstype.NumberType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ParameterizedType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.RecordType;
import com.google.javascript.rhino.jstype.RecordTypeBuilder;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.StringType;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.UnionTypeBuilder;
import com.google.javascript.rhino.jstype.UnknownType;
import com.google.javascript.rhino.jstype.UnresolvedTypeExpression;
import com.google.javascript.rhino.jstype.VoidType;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSTypeRegistry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient ErrorReporter reporter;
    private final JSType[] nativeTypes;
    private final Map<String, JSType> namesToTypes;
    private final Set<String> namespaces = new HashSet<String>();
    private final Set<String> nonNullableTypeNames = new HashSet<String>();
    private final Set<String> forwardDeclaredTypes = new HashSet<String>();
    private final Map<String, Set<ObjectType>> typesIndexedByProperty = Maps.newHashMap();
    private final Map<String, JSType> greatestSubtypeByProperty = Maps.newHashMap();
    private final Multimap<String, FunctionType> interfaceToImplementors = LinkedHashMultimap.create();
    private final Multimap<StaticScope<JSType>, NamedType> unresolvedNamedTypes = ArrayListMultimap.create();
    private final Multimap<StaticScope<JSType>, NamedType> resolvedNamedTypes = ArrayListMultimap.create();
    private boolean lastGeneration = true;
    private String templateTypeName;
    private TemplateType templateType;
    private final boolean tolerateUndefinedValues;
    private ResolveMode resolveMode = ResolveMode.LAZY_NAMES;

    public JSTypeRegistry(ErrorReporter errorReporter) {
        this(errorReporter, false);
    }

    public JSTypeRegistry(ErrorReporter errorReporter, boolean bl) {
        this.reporter = errorReporter;
        this.nativeTypes = new JSType[JSTypeNative.values().length];
        this.namesToTypes = new HashMap<String, JSType>();
        this.resetForTypeCheck();
        this.tolerateUndefinedValues = bl;
    }

    public void setResolveMode(ResolveMode resolveMode) {
        this.resolveMode = resolveMode;
    }

    ResolveMode getResolveMode() {
        return this.resolveMode;
    }

    public ErrorReporter getErrorReporter() {
        return this.reporter;
    }

    public boolean shouldTolerateUndefinedValues() {
        return this.tolerateUndefinedValues;
    }

    public void resetForTypeCheck() {
        this.typesIndexedByProperty.clear();
        this.initializeBuiltInTypes();
        this.namesToTypes.clear();
        this.namespaces.clear();
        this.initializeRegistry();
    }

    private void initializeBuiltInTypes() {
        BooleanType booleanType = new BooleanType(this);
        this.registerNativeType(JSTypeNative.BOOLEAN_TYPE, booleanType);
        NullType nullType = new NullType(this);
        this.registerNativeType(JSTypeNative.NULL_TYPE, nullType);
        NumberType numberType = new NumberType(this);
        this.registerNativeType(JSTypeNative.NUMBER_TYPE, numberType);
        StringType stringType = new StringType(this);
        this.registerNativeType(JSTypeNative.STRING_TYPE, stringType);
        UnknownType unknownType = new UnknownType(this, false);
        this.registerNativeType(JSTypeNative.UNKNOWN_TYPE, unknownType);
        this.registerNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE, new UnknownType(this, true));
        VoidType voidType = new VoidType(this);
        this.registerNativeType(JSTypeNative.VOID_TYPE, voidType);
        AllType allType = new AllType(this);
        this.registerNativeType(JSTypeNative.ALL_TYPE, allType);
        FunctionPrototypeType functionPrototypeType = new FunctionPrototypeType(this, null, null, true);
        this.registerNativeType(JSTypeNative.TOP_LEVEL_PROTOTYPE, functionPrototypeType);
        FunctionType functionType = new FunctionType(this, "Object", null, this.createArrowType(this.createOptionalParameters(allType), unknownType), null, null, true, true);
        functionType.defineDeclaredProperty("prototype", functionPrototypeType, true);
        this.registerNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE, functionType);
        FunctionPrototypeType functionPrototypeType2 = functionType.getPrototype();
        this.registerNativeType(JSTypeNative.OBJECT_PROTOTYPE, functionPrototypeType2);
        ObjectType objectType = functionType.getInstanceType();
        this.registerNativeType(JSTypeNative.OBJECT_TYPE, objectType);
        FunctionType functionType2 = new FunctionType(this, "Function", null, this.createArrowType(this.createParametersWithVarArgs(allType), unknownType), null, null, true, true);
        functionType2.setPrototypeBasedOn(objectType);
        this.registerNativeType(JSTypeNative.FUNCTION_FUNCTION_TYPE, functionType2);
        FunctionPrototypeType functionPrototypeType3 = functionType2.getPrototype();
        this.registerNativeType(JSTypeNative.FUNCTION_PROTOTYPE, functionPrototypeType3);
        NoType noType = new NoType(this);
        this.registerNativeType(JSTypeNative.NO_TYPE, noType);
        NoObjectType noObjectType = new NoObjectType(this);
        this.registerNativeType(JSTypeNative.NO_OBJECT_TYPE, noObjectType);
        FunctionType functionType3 = new FunctionType(this, "Array", null, this.createArrowType(this.createParametersWithVarArgs(allType), null), null, null, true, true);
        functionType3.getInternalArrowType().returnType = functionType3.getInstanceType();
        FunctionPrototypeType functionPrototypeType4 = functionType3.getPrototype();
        this.registerNativeType(JSTypeNative.ARRAY_FUNCTION_TYPE, functionType3);
        ObjectType objectType2 = functionType3.getInstanceType();
        this.registerNativeType(JSTypeNative.ARRAY_TYPE, objectType2);
        FunctionType functionType4 = new FunctionType(this, "Boolean", null, this.createArrowType(this.createParameters(false, allType), booleanType), null, null, true, true);
        FunctionPrototypeType functionPrototypeType5 = functionType4.getPrototype();
        this.registerNativeType(JSTypeNative.BOOLEAN_OBJECT_FUNCTION_TYPE, functionType4);
        ObjectType objectType3 = functionType4.getInstanceType();
        this.registerNativeType(JSTypeNative.BOOLEAN_OBJECT_TYPE, objectType3);
        FunctionType functionType5 = new FunctionType(this, "Date", null, this.createArrowType(this.createOptionalParameters(unknownType, unknownType, unknownType, unknownType, unknownType, unknownType, unknownType), stringType), null, null, true, true);
        FunctionPrototypeType functionPrototypeType6 = functionType5.getPrototype();
        this.registerNativeType(JSTypeNative.DATE_FUNCTION_TYPE, functionType5);
        ObjectType objectType4 = functionType5.getInstanceType();
        this.registerNativeType(JSTypeNative.DATE_TYPE, objectType4);
        ErrorFunctionType errorFunctionType = new ErrorFunctionType(this, "Error");
        this.registerNativeType(JSTypeNative.ERROR_FUNCTION_TYPE, errorFunctionType);
        ObjectType objectType5 = errorFunctionType.getInstanceType();
        this.registerNativeType(JSTypeNative.ERROR_TYPE, objectType5);
        ErrorFunctionType errorFunctionType2 = new ErrorFunctionType(this, "EvalError");
        errorFunctionType2.setPrototypeBasedOn(objectType5);
        this.registerNativeType(JSTypeNative.EVAL_ERROR_FUNCTION_TYPE, errorFunctionType2);
        ObjectType objectType6 = errorFunctionType2.getInstanceType();
        this.registerNativeType(JSTypeNative.EVAL_ERROR_TYPE, objectType6);
        ErrorFunctionType errorFunctionType3 = new ErrorFunctionType(this, "RangeError");
        errorFunctionType3.setPrototypeBasedOn(objectType5);
        this.registerNativeType(JSTypeNative.RANGE_ERROR_FUNCTION_TYPE, errorFunctionType3);
        ObjectType objectType7 = errorFunctionType3.getInstanceType();
        this.registerNativeType(JSTypeNative.RANGE_ERROR_TYPE, objectType7);
        ErrorFunctionType errorFunctionType4 = new ErrorFunctionType(this, "ReferenceError");
        errorFunctionType4.setPrototypeBasedOn(objectType5);
        this.registerNativeType(JSTypeNative.REFERENCE_ERROR_FUNCTION_TYPE, errorFunctionType4);
        ObjectType objectType8 = errorFunctionType4.getInstanceType();
        this.registerNativeType(JSTypeNative.REFERENCE_ERROR_TYPE, objectType8);
        ErrorFunctionType errorFunctionType5 = new ErrorFunctionType(this, "SyntaxError");
        errorFunctionType5.setPrototypeBasedOn(objectType5);
        this.registerNativeType(JSTypeNative.SYNTAX_ERROR_FUNCTION_TYPE, errorFunctionType5);
        ObjectType objectType9 = errorFunctionType5.getInstanceType();
        this.registerNativeType(JSTypeNative.SYNTAX_ERROR_TYPE, objectType9);
        ErrorFunctionType errorFunctionType6 = new ErrorFunctionType(this, "TypeError");
        errorFunctionType6.setPrototypeBasedOn(objectType5);
        this.registerNativeType(JSTypeNative.TYPE_ERROR_FUNCTION_TYPE, errorFunctionType6);
        ObjectType objectType10 = errorFunctionType6.getInstanceType();
        this.registerNativeType(JSTypeNative.TYPE_ERROR_TYPE, objectType10);
        ErrorFunctionType errorFunctionType7 = new ErrorFunctionType(this, "URIError");
        errorFunctionType7.setPrototypeBasedOn(objectType5);
        this.registerNativeType(JSTypeNative.URI_ERROR_FUNCTION_TYPE, errorFunctionType7);
        ObjectType objectType11 = errorFunctionType7.getInstanceType();
        this.registerNativeType(JSTypeNative.URI_ERROR_TYPE, objectType11);
        FunctionType functionType6 = new FunctionType(this, "Number", null, this.createArrowType(this.createParameters(false, allType), numberType), null, null, true, true);
        FunctionPrototypeType functionPrototypeType7 = functionType6.getPrototype();
        this.registerNativeType(JSTypeNative.NUMBER_OBJECT_FUNCTION_TYPE, functionType6);
        ObjectType objectType12 = functionType6.getInstanceType();
        this.registerNativeType(JSTypeNative.NUMBER_OBJECT_TYPE, objectType12);
        FunctionType functionType7 = new FunctionType(this, "RegExp", null, this.createArrowType(this.createOptionalParameters(allType, allType)), null, null, true, true);
        functionType7.getInternalArrowType().returnType = functionType7.getInstanceType();
        FunctionPrototypeType functionPrototypeType8 = functionType7.getPrototype();
        this.registerNativeType(JSTypeNative.REGEXP_FUNCTION_TYPE, functionType7);
        ObjectType objectType13 = functionType7.getInstanceType();
        this.registerNativeType(JSTypeNative.REGEXP_TYPE, objectType13);
        FunctionType functionType8 = new FunctionType(this, "String", null, this.createArrowType(this.createParameters(false, allType), stringType), null, null, true, true);
        FunctionPrototypeType functionPrototypeType9 = functionType8.getPrototype();
        this.registerNativeType(JSTypeNative.STRING_OBJECT_FUNCTION_TYPE, functionType8);
        ObjectType objectType14 = functionType8.getInstanceType();
        this.registerNativeType(JSTypeNative.STRING_OBJECT_TYPE, objectType14);
        JSType jSType = this.createUnionType(objectType, numberType, stringType);
        this.registerNativeType(JSTypeNative.OBJECT_NUMBER_STRING, jSType);
        JSType jSType2 = this.createUnionType(objectType, numberType, stringType, booleanType);
        this.registerNativeType(JSTypeNative.OBJECT_NUMBER_STRING_BOOLEAN, jSType2);
        JSType jSType3 = this.createUnionType(numberType, stringType, booleanType);
        this.registerNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN, jSType3);
        JSType jSType4 = this.createUnionType(numberType, stringType);
        this.registerNativeType(JSTypeNative.NUMBER_STRING, jSType4);
        JSType jSType5 = this.createUnionType(objectType14, stringType);
        this.registerNativeType(JSTypeNative.STRING_VALUE_OR_OBJECT_TYPE, jSType5);
        JSType jSType6 = this.createUnionType(objectType12, numberType);
        this.registerNativeType(JSTypeNative.NUMBER_VALUE_OR_OBJECT_TYPE, jSType6);
        FunctionType functionType9 = this.createFunctionType((JSType)unknownType, true, unknownType);
        this.registerNativeType(JSTypeNative.U2U_FUNCTION_TYPE, functionType9);
        FunctionType functionType10 = new FunctionType(this, "Function", null, this.createArrowType(this.createParametersWithVarArgs(unknownType), unknownType), noObjectType, null, true, true){
            private static final long serialVersionUID = 1L;

            @Override
            public FunctionType getConstructor() {
                return this.registry.getNativeFunctionType(JSTypeNative.FUNCTION_FUNCTION_TYPE);
            }
        };
        this.registerNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE, functionType10);
        this.registerNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE, functionType10);
        functionType2.setInstanceType(functionType10);
        functionType10.setImplicitPrototype(functionPrototypeType3);
        FunctionType functionType11 = this.createFunctionType((JSType)noType, true, allType);
        this.registerNativeType(JSTypeNative.LEAST_FUNCTION_TYPE, functionType11);
        ObjectType objectType15 = this.createObjectType("global this", null, unknownType);
        this.registerNativeType(JSTypeNative.GLOBAL_THIS, objectType15);
        FunctionType functionType12 = this.createFunctionType((JSType)allType, true, noType);
        this.registerNativeType(JSTypeNative.GREATEST_FUNCTION_TYPE, functionType12);
    }

    private void initializeRegistry() {
        this.register(this.getNativeType(JSTypeNative.ARRAY_TYPE));
        this.register(this.getNativeType(JSTypeNative.BOOLEAN_OBJECT_TYPE));
        this.register(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
        this.register(this.getNativeType(JSTypeNative.DATE_TYPE));
        this.register(this.getNativeType(JSTypeNative.NULL_TYPE));
        this.register(this.getNativeType(JSTypeNative.NULL_TYPE), "Null");
        this.register(this.getNativeType(JSTypeNative.NUMBER_OBJECT_TYPE));
        this.register(this.getNativeType(JSTypeNative.NUMBER_TYPE));
        this.register(this.getNativeType(JSTypeNative.OBJECT_TYPE));
        this.register(this.getNativeType(JSTypeNative.ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.URI_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.EVAL_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.TYPE_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.RANGE_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.REFERENCE_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.SYNTAX_ERROR_TYPE));
        this.register(this.getNativeType(JSTypeNative.REGEXP_TYPE));
        this.register(this.getNativeType(JSTypeNative.STRING_OBJECT_TYPE));
        this.register(this.getNativeType(JSTypeNative.STRING_TYPE));
        this.register(this.getNativeType(JSTypeNative.VOID_TYPE));
        this.register(this.getNativeType(JSTypeNative.VOID_TYPE), "Undefined");
        this.register(this.getNativeType(JSTypeNative.VOID_TYPE), "void");
        this.register(this.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE), "Function");
    }

    private void register(JSType jSType) {
        this.register(jSType, jSType.toString());
    }

    private void register(JSType jSType, String string) {
        this.namesToTypes.put(string, jSType);
        while (string.indexOf(46) > 0) {
            string = string.substring(0, string.lastIndexOf(46));
            this.namespaces.add(string);
        }
    }

    private void registerNativeType(JSTypeNative jSTypeNative, JSType jSType) {
        this.nativeTypes[jSTypeNative.ordinal()] = jSType;
    }

    public void registerPropertyOnType(String string, JSType jSType) {
        ObjectType objectType = null;
        if (jSType instanceof ObjectType) {
            objectType = (ObjectType)jSType;
        } else if (this.getNativeType(JSTypeNative.ALL_TYPE).isSubtype(jSType)) {
            objectType = this.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
        } else if (jSType instanceof UnionType) {
            for (JSType jSType2 : ((UnionType)jSType).getAlternates()) {
                this.registerPropertyOnType(string, jSType2);
            }
        }
        if (objectType == null) {
            return;
        }
        Set<ObjectType> set = this.typesIndexedByProperty.get(string);
        if (set == null) {
            set = new LinkedHashSet<ObjectType>();
            this.typesIndexedByProperty.put(string, set);
        }
        this.greatestSubtypeByProperty.remove(string);
        set.add(objectType);
    }

    public JSType getGreatestSubtypeWithProperty(JSType jSType, String string) {
        if (this.greatestSubtypeByProperty.containsKey(string)) {
            return this.greatestSubtypeByProperty.get(string).getGreatestSubtype(jSType);
        }
        if (this.typesIndexedByProperty.containsKey(string)) {
            UnionTypeBuilder unionTypeBuilder = new UnionTypeBuilder(this);
            for (ObjectType objectType : this.typesIndexedByProperty.get(string)) {
                unionTypeBuilder.addAlternate(objectType);
            }
            JSType jSType2 = unionTypeBuilder.build();
            this.greatestSubtypeByProperty.put(string, jSType2);
            return jSType2.getGreatestSubtype(jSType);
        }
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    public boolean canPropertyBeDefined(JSType jSType, String string) {
        if (this.typesIndexedByProperty.containsKey(string)) {
            for (ObjectType objectType : this.typesIndexedByProperty.get(string)) {
                if (objectType.getGreatestSubtype(jSType).isEmptyType()) continue;
                return true;
            }
        }
        return false;
    }

    public Set<ObjectType> getTypesWithProperty(String string) {
        Set<ObjectType> set = this.typesIndexedByProperty.get(string);
        if (set == null) {
            LinkedHashSet<ObjectType> linkedHashSet = new LinkedHashSet<ObjectType>();
            linkedHashSet.add(this.getNativeObjectType(JSTypeNative.NO_TYPE));
            return linkedHashSet;
        }
        return set;
    }

    public void incrementGeneration() {
        for (NamedType namedType : this.resolvedNamedTypes.values()) {
            namedType.clearResolved();
        }
        this.unresolvedNamedTypes.putAll(this.resolvedNamedTypes);
        this.resolvedNamedTypes.clear();
    }

    boolean isLastGeneration() {
        return this.lastGeneration;
    }

    public void setLastGeneration(boolean bl) {
        this.lastGeneration = bl;
    }

    void registerTypeImplementingInterface(FunctionType functionType, ObjectType objectType) {
        this.interfaceToImplementors.put((Object)objectType.getReferenceName(), (Object)functionType);
    }

    public Collection<FunctionType> getDirectImplementors(ObjectType objectType) {
        return this.interfaceToImplementors.get((Object)objectType.getReferenceName());
    }

    public boolean declareType(String string, JSType jSType) {
        if (this.namesToTypes.containsKey(string)) {
            return false;
        }
        this.register(jSType, string);
        return true;
    }

    public void overwriteDeclaredType(String string, JSType jSType) {
        Preconditions.checkState((boolean)this.namesToTypes.containsKey(string));
        this.register(jSType, string);
    }

    public void forwardDeclareType(String string) {
        this.forwardDeclaredTypes.add(string);
    }

    public boolean isForwardDeclaredType(String string) {
        return this.forwardDeclaredTypes.contains(string);
    }

    public boolean hasNamespace(String string) {
        return this.namespaces.contains(string);
    }

    public JSType getType(String string) {
        if (string.equals(this.templateTypeName)) {
            return this.templateType;
        }
        return this.namesToTypes.get(string);
    }

    public JSType getNativeType(JSTypeNative jSTypeNative) {
        return this.nativeTypes[jSTypeNative.ordinal()];
    }

    public ObjectType getNativeObjectType(JSTypeNative jSTypeNative) {
        return (ObjectType)this.getNativeType(jSTypeNative);
    }

    public FunctionType getNativeFunctionType(JSTypeNative jSTypeNative) {
        return (FunctionType)this.getNativeType(jSTypeNative);
    }

    public JSType getForgivingType(StaticScope<JSType> staticScope, String string, String string2, int n, int n2) {
        JSType jSType = this.getType(staticScope, string, string2, n, n2);
        jSType.forgiveUnknownNames();
        return jSType;
    }

    public JSType getType(StaticScope<JSType> staticScope, String string, String string2, int n, int n2) {
        JSType jSType = this.getType(string);
        if (jSType == null) {
            NamedType namedType = new NamedType(this, string, string2, n, n2);
            this.unresolvedNamedTypes.put(staticScope, (Object)namedType);
            jSType = namedType;
        }
        return jSType;
    }

    public void resolveTypesInScope(StaticScope<JSType> staticScope) {
        for (JSType jSType : this.unresolvedNamedTypes.get(staticScope)) {
            jSType.resolve(this.reporter, staticScope);
        }
        this.resolvedNamedTypes.putAll(staticScope, (Iterable)this.unresolvedNamedTypes.removeAll(staticScope));
        if (staticScope != null && staticScope.getParentScope() == null) {
            JSType jSType;
            PrototypeObjectType prototypeObjectType = (PrototypeObjectType)this.getNativeType(JSTypeNative.GLOBAL_THIS);
            jSType = this.getType("Window");
            if (prototypeObjectType.isUnknownType()) {
                ObjectType objectType = ObjectType.cast(jSType);
                if (objectType != null) {
                    prototypeObjectType.setImplicitPrototype(objectType);
                } else {
                    prototypeObjectType.setImplicitPrototype(this.getNativeObjectType(JSTypeNative.OBJECT_TYPE));
                }
            }
        }
    }

    public JSType createOptionalType(JSType jSType) {
        if (jSType instanceof UnknownType || jSType.isAllType()) {
            return jSType;
        }
        return this.createUnionType(jSType, this.getNativeType(JSTypeNative.VOID_TYPE));
    }

    public JSType createDefaultObjectUnion(JSType jSType) {
        return this.shouldTolerateUndefinedValues() ? this.createOptionalNullableType(jSType) : this.createNullableType(jSType);
    }

    public JSType createNullableType(JSType jSType) {
        return this.createUnionType(jSType, this.getNativeType(JSTypeNative.NULL_TYPE));
    }

    public JSType createOptionalNullableType(JSType jSType) {
        return this.createUnionType(jSType, this.getNativeType(JSTypeNative.VOID_TYPE), this.getNativeType(JSTypeNative.NULL_TYPE));
    }

    public JSType createUnionType(JSType ... jSTypeArray) {
        UnionTypeBuilder unionTypeBuilder = new UnionTypeBuilder(this);
        for (JSType jSType : jSTypeArray) {
            unionTypeBuilder.addAlternate(jSType);
        }
        return unionTypeBuilder.build();
    }

    public JSType createUnionType(JSTypeNative ... jSTypeNativeArray) {
        UnionTypeBuilder unionTypeBuilder = new UnionTypeBuilder(this);
        for (JSTypeNative jSTypeNative : jSTypeNativeArray) {
            unionTypeBuilder.addAlternate(this.getNativeType(jSTypeNative));
        }
        return unionTypeBuilder.build();
    }

    public EnumType createEnumType(String string, JSType jSType) {
        return new EnumType(this, string, jSType);
    }

    ArrowType createArrowType(Node node, JSType jSType) {
        return new ArrowType(this, node, jSType);
    }

    ArrowType createArrowType(Node node) {
        return new ArrowType(this, node, null);
    }

    public FunctionType createFunctionType(JSType jSType, JSType ... jSTypeArray) {
        return this.createFunctionType(jSType, this.createParameters(jSTypeArray));
    }

    public FunctionType createFunctionTypeWithVarArgs(JSType jSType, List<JSType> list) {
        return this.createFunctionType(jSType, this.createParametersWithVarArgs(list));
    }

    public FunctionType createFunctionType(JSType jSType, List<JSType> list) {
        return this.createFunctionType(jSType, this.createParameters(list));
    }

    public FunctionType createFunctionTypeWithVarArgs(JSType jSType, JSType ... jSTypeArray) {
        return this.createFunctionType(jSType, this.createParametersWithVarArgs(jSTypeArray));
    }

    public FunctionType createConstructorType(JSType jSType, JSType ... jSTypeArray) {
        return this.createConstructorType(null, null, this.createParameters(jSTypeArray), jSType);
    }

    public FunctionType createConstructorTypeWithVarArgs(JSType jSType, JSType ... jSTypeArray) {
        return this.createConstructorType(null, null, this.createParametersWithVarArgs(jSTypeArray), jSType);
    }

    public JSType createFunctionType(ObjectType objectType, JSType jSType, List<JSType> list) {
        return new FunctionBuilder(this).withParamsNode(this.createParameters(list)).withReturnType(jSType).withTypeOfThis(objectType).build();
    }

    public JSType createFunctionTypeWithVarArgs(ObjectType objectType, JSType jSType, List<JSType> list) {
        return new FunctionBuilder(this).withParamsNode(this.createParametersWithVarArgs(list)).withReturnType(jSType).withTypeOfThis(objectType).build();
    }

    public Node createParameters(List<JSType> list) {
        return this.createParameters(list.toArray(new JSType[list.size()]));
    }

    public Node createParametersWithVarArgs(List<JSType> list) {
        return this.createParametersWithVarArgs(list.toArray(new JSType[list.size()]));
    }

    public Node createParameters(JSType ... jSTypeArray) {
        return this.createParameters(false, jSTypeArray);
    }

    public Node createParametersWithVarArgs(JSType ... jSTypeArray) {
        return this.createParameters(true, jSTypeArray);
    }

    public Node createOptionalParameters(JSType ... jSTypeArray) {
        FunctionParamBuilder functionParamBuilder = new FunctionParamBuilder(this);
        functionParamBuilder.addOptionalParams(jSTypeArray);
        return functionParamBuilder.build();
    }

    private Node createParameters(boolean bl, JSType ... jSTypeArray) {
        FunctionParamBuilder functionParamBuilder = new FunctionParamBuilder(this);
        int n = jSTypeArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            if (bl && i == n) {
                functionParamBuilder.addVarArgs(jSTypeArray[i]);
                continue;
            }
            functionParamBuilder.addRequiredParams(jSTypeArray[i]);
        }
        return functionParamBuilder.build();
    }

    public FunctionType createFunctionType(JSType jSType, boolean bl, JSType ... jSTypeArray) {
        if (bl) {
            return this.createFunctionTypeWithVarArgs(jSType, jSTypeArray);
        }
        return this.createFunctionType(jSType, jSTypeArray);
    }

    public FunctionType createFunctionTypeWithNewReturnType(FunctionType functionType, JSType jSType) {
        return new FunctionBuilder(this).copyFromOtherFunction(functionType).withReturnType(jSType).build();
    }

    public FunctionType createFunctionTypeWithNewThisType(FunctionType functionType, ObjectType objectType) {
        return new FunctionBuilder(this).copyFromOtherFunction(functionType).withTypeOfThis(objectType).build();
    }

    public FunctionType createFunctionType(JSType jSType, Node node) {
        return new FunctionBuilder(this).withParamsNode(node).withReturnType(jSType).build();
    }

    public FunctionType createConstructorType(JSType jSType, boolean bl, JSType ... jSTypeArray) {
        if (bl) {
            return this.createConstructorTypeWithVarArgs(jSType, jSTypeArray);
        }
        return this.createConstructorType(jSType, jSTypeArray);
    }

    public ObjectType createObjectType(ObjectType objectType) {
        return this.createObjectType(null, null, objectType);
    }

    public RecordType createRecordType(Map<String, JSType> map) {
        return new RecordType(this, map);
    }

    public ObjectType createObjectType(String string, Node node, ObjectType objectType) {
        return new PrototypeObjectType(this, string, objectType);
    }

    public ObjectType createAnonymousObjectType() {
        PrototypeObjectType prototypeObjectType = new PrototypeObjectType(this, null, null);
        prototypeObjectType.setPrettyPrint(true);
        return prototypeObjectType;
    }

    public FunctionType createConstructorType(String string, Node node, Node node2, JSType jSType) {
        return new FunctionType(this, string, node, this.createArrowType(node2, jSType), null, null, true, false);
    }

    public FunctionType createInterfaceType(String string, Node node) {
        return FunctionType.forInterface(this, string, node);
    }

    public ParameterizedType createParameterizedType(ObjectType objectType, JSType jSType) {
        return new ParameterizedType(this, objectType, jSType);
    }

    @VisibleForTesting
    public JSType createNamedType(String string, String string2, int n, int n2) {
        return new NamedType(this, string, string2, n, n2);
    }

    public void identifyNonNullableName(String string) {
        Preconditions.checkNotNull((Object)string);
        this.nonNullableTypeNames.add(string);
    }

    public JSType createFromTypeNodes(Node node, String string, StaticScope<JSType> staticScope) {
        return this.createFromTypeNodes(node, string, staticScope, false);
    }

    public JSType createFromTypeNodes(Node node, String string, StaticScope<JSType> staticScope, boolean bl) {
        boolean bl2;
        if (this.resolveMode == ResolveMode.LAZY_EXPRESSIONS && (bl2 = this.hasTypeName(node))) {
            return new UnresolvedTypeExpression(this, node, string, bl);
        }
        return this.createFromTypeNodesInternal(node, string, staticScope, bl);
    }

    private boolean hasTypeName(Node node) {
        if (node.getType() == 40) {
            return true;
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            if (!this.hasTypeName(node2)) continue;
            return true;
        }
        return false;
    }

    private JSType createFromTypeNodesInternal(Node node, String string, StaticScope<JSType> staticScope, boolean bl) {
        switch (node.getType()) {
            case 81: {
                return this.createRecordTypeFromNodes(node.getFirstChild(), string, staticScope);
            }
            case 306: {
                return this.createFromTypeNodesInternal(node.getFirstChild(), string, staticScope, bl).restrictByNotNullOrUndefined();
            }
            case 304: {
                Node node2 = node.getFirstChild();
                if (node2 == null) {
                    return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
                }
                return this.createDefaultObjectUnion(this.createFromTypeNodesInternal(node2, string, staticScope, bl));
            }
            case 307: {
                return this.createOptionalType(this.createFromTypeNodesInternal(node.getFirstChild(), string, staticScope, false));
            }
            case 305: {
                return this.createOptionalType(this.createFromTypeNodesInternal(node.getFirstChild(), string, staticScope, false));
            }
            case 302: {
                return this.getNativeType(JSTypeNative.ALL_TYPE);
            }
            case 79: {
                return this.getNativeType(JSTypeNative.ARRAY_TYPE);
            }
            case 301: {
                UnionTypeBuilder unionTypeBuilder = new UnionTypeBuilder(this);
                for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                    unionTypeBuilder.addAlternate(this.createFromTypeNodesInternal(node3, string, staticScope, false));
                }
                return unionTypeBuilder.build();
            }
            case 124: {
                return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            case 122: {
                return this.getNativeType(JSTypeNative.VOID_TYPE);
            }
            case 40: {
                JSType jSType = this.getType(staticScope, node.getString(), string, node.getLineno(), node.getCharno());
                if (bl) {
                    jSType.forgiveUnknownNames();
                }
                if (this.resolveMode != ResolveMode.LAZY_NAMES) {
                    jSType = jSType.resolveInternal(this.reporter, staticScope);
                }
                if (jSType instanceof ObjectType && !this.nonNullableTypeNames.contains(node.getString())) {
                    Node node4 = node.getFirstChild();
                    if (node4 != null && ("Array".equals(node.getString()) || "Object".equals(node.getString()))) {
                        JSType jSType2 = this.createFromTypeNodesInternal(node4.getLastChild(), string, staticScope, false);
                        jSType = new ParameterizedType(this, (ObjectType)jSType, jSType2);
                        if (node4.hasMoreThanOneChild()) {
                            JSType jSType3 = this.createFromTypeNodesInternal(node4.getFirstChild(), string, staticScope, false);
                            jSType = new IndexedType(this, (ObjectType)jSType, jSType3);
                        }
                    }
                    return this.createDefaultObjectUnion(jSType);
                }
                return jSType;
            }
            case 105: {
                Serializable serializable;
                Object object;
                ObjectType objectType = null;
                Node node5 = node.getFirstChild();
                if (node5.getType() == 42) {
                    object = node5.getFirstChild();
                    objectType = ObjectType.cast(this.createFromTypeNodesInternal((Node)object, string, staticScope, false).restrictByNotNullOrUndefined());
                    if (objectType == null) {
                        this.reporter.warning(ScriptRuntime.getMessage0("msg.jsdoc.function.thisnotobject"), string, ((Node)object).getLineno(), "", ((Node)object).getCharno());
                    }
                    node5 = node5.getNext();
                }
                object = new FunctionParamBuilder(this);
                if (node5.getType() == 83) {
                    serializable = node5.getFirstChild();
                    for (Node node6 = node5.getFirstChild(); node6 != null; node6 = node6.getNext()) {
                        if (node6.getType() == 305) {
                            if (node6.getChildCount() == 0) {
                                ((FunctionParamBuilder)object).addVarArgs(this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
                                continue;
                            }
                            ((FunctionParamBuilder)object).addVarArgs(this.createFromTypeNodesInternal(node6.getFirstChild(), string, staticScope, false));
                            continue;
                        }
                        JSType jSType = this.createFromTypeNodesInternal(node6, string, staticScope, false);
                        if (node6.getType() == 307) {
                            boolean bl2 = ((FunctionParamBuilder)object).addOptionalParams(jSType);
                            if (bl2) continue;
                            this.reporter.warning(ScriptRuntime.getMessage0("msg.jsdoc.function.varargs"), string, node6.getLineno(), "", node6.getCharno());
                            continue;
                        }
                        ((FunctionParamBuilder)object).addRequiredParams(jSType);
                    }
                    node5 = node5.getNext();
                }
                serializable = this.createFromTypeNodesInternal(node5, string, staticScope, false);
                return new FunctionBuilder(this).withParams((FunctionParamBuilder)object).withReturnType((JSType)serializable).withTypeOfThis(objectType).build();
            }
        }
        throw new IllegalStateException("Unexpected node in type expression: " + node.toString());
    }

    private JSType createRecordTypeFromNodes(Node node, String string, StaticScope<JSType> staticScope) {
        RecordTypeBuilder recordTypeBuilder = new RecordTypeBuilder(this);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            String string2;
            Node node3 = node2;
            boolean bl = false;
            if (node2.getType() == 99) {
                node3 = node2.getFirstChild();
                bl = true;
            }
            if ((string2 = node3.getString()).startsWith("'") || string2.startsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            JSType jSType = null;
            jSType = bl ? this.createFromTypeNodesInternal(node2.getLastChild(), string, staticScope, false) : this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            recordTypeBuilder.addProperty(string2, jSType);
        }
        return recordTypeBuilder.build();
    }

    public void setTemplateTypeName(String string) {
        this.templateTypeName = string;
        this.templateType = new TemplateType(this, string);
    }

    public void clearTemplateTypeName() {
        this.templateTypeName = null;
        this.templateType = null;
    }

    public static enum ResolveMode {
        LAZY_EXPRESSIONS,
        LAZY_NAMES,
        IMMEDIATE;

    }
}

