/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.jsonml;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.NodeUtil;
import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.TagType;
import com.google.javascript.rhino.Node;
import java.util.Iterator;
import java.util.Set;

public class Writer {
    public JsonML processAst(Node node) {
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkArgument((node.getType() == 125 ? 1 : 0) != 0);
        JsonML jsonML = new JsonML(TagType.BlockStmt);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.processNode(node2, jsonML);
        }
        return jsonML.getChild(0);
    }

    private void processNode(Node node, JsonML jsonML) {
        switch (node.getType()) {
            case 4: {
                this.processReturn(node, jsonML);
                break;
            }
            case 9: {
                this.processBinaryExpr(node, jsonML, "|");
                break;
            }
            case 10: {
                this.processBinaryExpr(node, jsonML, "^");
                break;
            }
            case 11: {
                this.processBinaryExpr(node, jsonML, "&");
                break;
            }
            case 12: {
                this.processBinaryExpr(node, jsonML, "==");
                break;
            }
            case 13: {
                this.processBinaryExpr(node, jsonML, "!=");
                break;
            }
            case 14: {
                this.processBinaryExpr(node, jsonML, "<");
                break;
            }
            case 15: {
                this.processBinaryExpr(node, jsonML, "<=");
                break;
            }
            case 16: {
                this.processBinaryExpr(node, jsonML, ">");
                break;
            }
            case 17: {
                this.processBinaryExpr(node, jsonML, ">=");
                break;
            }
            case 18: {
                this.processBinaryExpr(node, jsonML, "<<");
                break;
            }
            case 19: {
                this.processBinaryExpr(node, jsonML, ">>");
                break;
            }
            case 20: {
                this.processBinaryExpr(node, jsonML, ">>>");
                break;
            }
            case 21: {
                this.processBinaryExpr(node, jsonML, "+");
                break;
            }
            case 22: {
                this.processBinaryExpr(node, jsonML, "-");
                break;
            }
            case 23: {
                this.processBinaryExpr(node, jsonML, "*");
                break;
            }
            case 24: {
                this.processBinaryExpr(node, jsonML, "/");
                break;
            }
            case 25: {
                this.processBinaryExpr(node, jsonML, "%");
                break;
            }
            case 26: {
                this.processUnaryExpr(node, jsonML, "!");
                break;
            }
            case 27: {
                this.processUnaryExpr(node, jsonML, "~");
                break;
            }
            case 28: {
                this.processUnaryExpr(node, jsonML, "+");
                break;
            }
            case 29: {
                this.processUnaryExpr(node, jsonML, "-");
                break;
            }
            case 30: {
                this.processNew(node, jsonML, TagType.NewExpr);
                break;
            }
            case 31: {
                this.processOneArgExpr(node, jsonML, TagType.DeleteExpr);
                break;
            }
            case 32: {
                this.processOneArgExpr(node, jsonML, TagType.TypeofExpr);
                break;
            }
            case 33: {
                this.processMemberExpr(node, jsonML, ".");
                break;
            }
            case 35: {
                this.processMemberExpr(node, jsonML, "[]");
                break;
            }
            case 37: {
                this.processCall(node, jsonML);
                break;
            }
            case 38: {
                this.processName(node, jsonML);
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                this.processLiteral(node, jsonML);
                break;
            }
            case 42: {
                this.processThis(node, jsonML);
                break;
            }
            case 45: {
                this.processBinaryExpr(node, jsonML, "===");
                break;
            }
            case 46: {
                this.processBinaryExpr(node, jsonML, "!==");
                break;
            }
            case 47: {
                this.processRegExp(node, jsonML);
                break;
            }
            case 49: {
                this.processThrow(node, jsonML);
                break;
            }
            case 51: {
                this.processBinaryExpr(node, jsonML, "in");
                break;
            }
            case 52: {
                this.processBinaryExpr(node, jsonML, "instanceof");
                break;
            }
            case 63: {
                this.processArrayLiteral(node, jsonML);
                break;
            }
            case 64: {
                this.processObjectLiteral(node, jsonML);
                break;
            }
            case 77: {
                this.processTry(node, jsonML);
                break;
            }
            case 85: {
                this.processBinaryExpr(node, jsonML, ",");
                break;
            }
            case 86: {
                this.processAssignExpr(node, jsonML, "=");
                break;
            }
            case 87: {
                this.processAssignExpr(node, jsonML, "|=");
                break;
            }
            case 88: {
                this.processAssignExpr(node, jsonML, "^=");
                break;
            }
            case 89: {
                this.processAssignExpr(node, jsonML, "&=");
                break;
            }
            case 90: {
                this.processAssignExpr(node, jsonML, "<<=");
                break;
            }
            case 91: {
                this.processAssignExpr(node, jsonML, ">>=");
                break;
            }
            case 92: {
                this.processAssignExpr(node, jsonML, ">>>=");
                break;
            }
            case 93: {
                this.processAssignExpr(node, jsonML, "+=");
                break;
            }
            case 94: {
                this.processAssignExpr(node, jsonML, "-=");
                break;
            }
            case 95: {
                this.processAssignExpr(node, jsonML, "*=");
                break;
            }
            case 96: {
                this.processAssignExpr(node, jsonML, "/=");
                break;
            }
            case 97: {
                this.processAssignExpr(node, jsonML, "%=");
                break;
            }
            case 98: {
                this.processHook(node, jsonML);
                break;
            }
            case 100: {
                this.processLogicalExpr(node, jsonML, "||");
                break;
            }
            case 101: {
                this.processLogicalExpr(node, jsonML, "&&");
                break;
            }
            case 102: {
                this.processIncrDecrExpr(node, jsonML, "++");
                break;
            }
            case 103: {
                this.processIncrDecrExpr(node, jsonML, "--");
                break;
            }
            case 105: {
                this.processFunction(node, jsonML);
                break;
            }
            case 108: {
                this.processIf(node, jsonML);
                break;
            }
            case 110: {
                this.processSwitch(node, jsonML);
                break;
            }
            case 111: {
                this.processCase(node, jsonML, TagType.Case);
                break;
            }
            case 112: {
                this.processCase(node, jsonML, TagType.DefaultCase);
                break;
            }
            case 113: {
                this.processLoop(node, jsonML, TagType.WhileStmt);
                break;
            }
            case 114: {
                this.processLoop(node, jsonML, TagType.DoWhileStmt);
                break;
            }
            case 115: {
                this.processForLoop(node, jsonML);
                break;
            }
            case 116: {
                this.processJmp(node, jsonML, TagType.BreakStmt);
                break;
            }
            case 117: {
                this.processJmp(node, jsonML, TagType.ContinueStmt);
                break;
            }
            case 118: {
                this.processVar(node, jsonML);
                break;
            }
            case 119: {
                this.processWith(node, jsonML);
                break;
            }
            case 120: {
                this.processCatch(node, jsonML);
                break;
            }
            case 122: {
                this.processUnaryExpr(node, jsonML, "void");
                break;
            }
            case 124: {
                this.processEmpty(node, jsonML);
                break;
            }
            case 125: {
                this.processBlock(node, jsonML);
                break;
            }
            case 126: {
                this.processLabel(node, jsonML);
                break;
            }
            case 130: {
                this.processExprResult(node, jsonML);
                break;
            }
            case 132: {
                this.processScript(node, jsonML);
            }
        }
    }

    private void processAssignExpr(Node node, JsonML jsonML, String string) {
        this.processTwoArgExpr(node, jsonML, TagType.AssignExpr, string);
    }

    private void processArrayLiteral(Node node, JsonML jsonML) {
        JsonML jsonML2 = new JsonML(TagType.ArrayExpr);
        jsonML.appendChild(jsonML2);
        Iterator<Node> iterator = node.children().iterator();
        int[] nArray = (int[])node.getProp(30);
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        while (iterator.hasNext()) {
            while (nArray != null && n2 < nArray.length && n == nArray[n2]) {
                jsonML2.appendChild(new JsonML(TagType.Empty));
                ++n;
                ++n2;
            }
            this.processNode(iterator.next(), jsonML2);
            ++n;
        }
    }

    private void processBinaryExpr(Node node, JsonML jsonML, String string) {
        this.processTwoArgExpr(node, jsonML, TagType.BinaryExpr, string);
    }

    private void processBlock(Node node, JsonML jsonML) {
        JsonML jsonML2 = new JsonML(TagType.BlockStmt);
        if (jsonML != null) {
            jsonML.appendChild(jsonML2);
        }
        this.processDirectives(node, jsonML2);
        for (Node node2 : node.children()) {
            this.processNode(node2, jsonML2);
        }
    }

    private void processCall(Node node, JsonML jsonML) {
        JsonML jsonML2;
        Iterator<Node> iterator = node.children().iterator();
        Node node2 = iterator.next();
        switch (node2.getType()) {
            case 33: 
            case 35: {
                jsonML2 = new JsonML(TagType.InvokeExpr);
                jsonML2.setAttribute(TagAttr.OP, node2.getType() == 33 ? "." : "[]");
                jsonML.appendChild(jsonML2);
                Node node3 = node2.getFirstChild();
                this.processNode(node3, jsonML2);
                this.processNode(node3.getNext(), jsonML2);
                break;
            }
            case 38: {
                if (node2.getString().equals("eval")) {
                    jsonML2 = new JsonML(TagType.EvalExpr);
                } else {
                    jsonML2 = new JsonML(TagType.IdExpr);
                    jsonML2.setAttribute(TagAttr.NAME, node2.getString());
                    jsonML2 = new JsonML(TagType.CallExpr, jsonML2);
                }
                jsonML.appendChild(jsonML2);
                break;
            }
            default: {
                jsonML2 = new JsonML(TagType.CallExpr);
                jsonML.appendChild(jsonML2);
                this.processNode(node2, jsonML2);
            }
        }
        while (iterator.hasNext()) {
            this.processNode(iterator.next(), jsonML2);
        }
    }

    private void processCase(Node node, JsonML jsonML, TagType tagType) {
        JsonML jsonML2 = new JsonML(tagType);
        jsonML.appendChild(jsonML2);
        Node node2 = node.getFirstChild();
        if (tagType == TagType.Case) {
            this.processNode(node2, jsonML2);
            node2 = node2.getNext();
        }
        Preconditions.checkNotNull((Object)node2);
        Preconditions.checkState((node2.getType() == 125 ? 1 : 0) != 0);
        for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.processNode(node2, jsonML2);
        }
    }

    private void processCatch(Node node, JsonML jsonML) {
        JsonML jsonML2 = new JsonML(TagType.CatchClause);
        jsonML.appendChild(jsonML2);
        Node node2 = node.getFirstChild();
        JsonML jsonML3 = new JsonML(TagType.IdPatt);
        jsonML3.setAttribute(TagAttr.NAME, node2.getString());
        jsonML2.appendChild(jsonML3);
        node2 = node2.getNext();
        this.processNode(node2, jsonML2);
    }

    private void processEmpty(Node node, JsonML jsonML) {
        jsonML.appendChild(new JsonML(TagType.EmptyStmt));
    }

    private void processExprResult(Node node, JsonML jsonML) {
        this.processNode(node.getFirstChild(), jsonML);
    }

    private void processForLoop(Node node, JsonML jsonML) {
        if (NodeUtil.isForIn(node)) {
            this.processLoop(node, jsonML, TagType.ForInStmt);
        } else {
            this.processLoop(node, jsonML, TagType.ForStmt);
        }
    }

    private void processFunction(Node node, JsonML jsonML) {
        JsonML jsonML2;
        JsonML jsonML3 = NodeUtil.isFunctionDeclaration(node) ? new JsonML(TagType.FunctionDecl) : new JsonML(TagType.FunctionExpr);
        jsonML.appendChild(jsonML3);
        Node node2 = node.getFirstChild();
        String string = node2.getString();
        if (!string.equals("")) {
            jsonML2 = new JsonML(TagType.IdPatt);
            jsonML2.setAttribute(TagAttr.NAME, string);
            jsonML3.appendChild(jsonML2);
        } else {
            jsonML3.appendChild(new JsonML(TagType.Empty));
        }
        node2 = node2.getNext();
        jsonML2 = new JsonML(TagType.ParamDecl);
        jsonML3.appendChild(jsonML2);
        Iterator<Node> iterator = node2.children().iterator();
        while (iterator.hasNext()) {
            JsonML jsonML4 = new JsonML(TagType.IdPatt);
            Node node3 = iterator.next();
            jsonML4.setAttribute(TagAttr.NAME, node3.getString());
            jsonML2.appendChild(jsonML4);
        }
        node2 = node2.getNext();
        this.processDirectives(node2, jsonML3);
        iterator = node2.children().iterator();
        while (iterator.hasNext()) {
            this.processNode(iterator.next(), jsonML3);
        }
    }

    private void processHook(Node node, JsonML jsonML) {
        JsonML jsonML2 = new JsonML(TagType.ConditionalExpr);
        jsonML.appendChild(jsonML2);
        this.processChildren(node, jsonML2);
    }

    private void processIf(Node node, JsonML jsonML) {
        JsonML jsonML2 = new JsonML(TagType.IfStmt);
        jsonML.appendChild(jsonML2);
        Iterator<Node> iterator = node.children().iterator();
        while (iterator.hasNext()) {
            this.processNode(iterator.next(), jsonML2);
        }
        int n = node.getChildCount();
        Preconditions.checkState((n >= 2 ? 1 : 0) != 0);
        if (n < 3) {
            jsonML2.appendChild(new JsonML(TagType.EmptyStmt));
        }
    }

    private void processIncrDecrExpr(Node node, JsonML jsonML, String string) {
        JsonML jsonML2 = new JsonML(TagType.CountExpr);
        jsonML.appendChild(jsonML2);
        if (string.equals("++")) {
            jsonML2.setAttribute(TagAttr.OP, "++");
        } else {
            jsonML2.setAttribute(TagAttr.OP, "--");
        }
        if (node.getIntProp(31) == 1) {
            jsonML2.setAttribute(TagAttr.IS_PREFIX, false);
        } else {
            jsonML2.setAttribute(TagAttr.IS_PREFIX, true);
        }
        this.processNode(node.getFirstChild(), jsonML2);
    }

    private void processJmp(Node node, JsonML jsonML, TagType tagType) {
        JsonML jsonML2 = new JsonML(tagType);
        jsonML.appendChild(jsonML2);
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            jsonML2.setAttribute(TagAttr.LABEL, node2.getString());
        }
    }

    private void processLabel(Node node, JsonML jsonML) {
        JsonML jsonML2 = new JsonML(TagType.LabelledStmt);
        jsonML.appendChild(jsonML2);
        Node node2 = node.getFirstChild();
        jsonML2.setAttribute(TagAttr.LABEL, node2.getString());
        node2 = node2.getNext();
        this.processNode(node2, jsonML2);
    }

    private void processLiteral(Node node, JsonML jsonML) {
        JsonML jsonML2 = new JsonML(TagType.LiteralExpr);
        switch (node.getType()) {
            case 39: {
                jsonML2.setAttribute(TagAttr.TYPE, "number");
                jsonML2.setAttribute(TagAttr.VALUE, node.getDouble());
                break;
            }
            case 40: {
                jsonML2.setAttribute(TagAttr.TYPE, "string");
                jsonML2.setAttribute(TagAttr.VALUE, node.getString());
                break;
            }
            case 41: {
                jsonML2.setAttribute(TagAttr.TYPE, "null");
                jsonML2.setAttribute(TagAttr.VALUE, null);
                break;
            }
            case 44: {
                jsonML2.setAttribute(TagAttr.TYPE, "boolean");
                jsonML2.setAttribute(TagAttr.VALUE, true);
                break;
            }
            case 43: {
                jsonML2.setAttribute(TagAttr.TYPE, "boolean");
                jsonML2.setAttribute(TagAttr.VALUE, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal type of node.");
            }
        }
        jsonML.appendChild(jsonML2);
    }

    private void processLogicalExpr(Node node, JsonML jsonML, String string) {
        if (string.equals("||")) {
            this.processTwoArgExpr(node, jsonML, TagType.LogicalOrExpr);
        } else if (string.endsWith("&&")) {
            this.processTwoArgExpr(node, jsonML, TagType.LogicalAndExpr);
        } else {
            throw new IllegalArgumentException("Unsupported value of op argument.");
        }
    }

    private void processLoop(Node node, JsonML jsonML, TagType tagType) {
        JsonML jsonML2 = new JsonML(tagType);
        jsonML.appendChild(jsonML2);
        this.processChildren(node, jsonML2);
    }

    private void processMemberExpr(Node node, JsonML jsonML, String string) {
        JsonML jsonML2 = new JsonML(TagType.MemberExpr);
        jsonML2.setAttribute(TagAttr.OP, string);
        jsonML.appendChild(jsonML2);
        Node node2 = node.getFirstChild();
        this.processNode(node2, jsonML2);
        this.processNode(node2.getNext(), jsonML2);
    }

    private void processName(Node node, JsonML jsonML) {
        Preconditions.checkState((!node.hasChildren() ? 1 : 0) != 0);
        JsonML jsonML2 = new JsonML(TagType.IdExpr);
        jsonML2.setAttribute(TagAttr.NAME, node.getString());
        jsonML.appendChild(jsonML2);
    }

    private void processNew(Node node, JsonML jsonML, TagType tagType) {
        JsonML jsonML2 = new JsonML(tagType);
        jsonML.appendChild(jsonML2);
        this.processChildren(node, jsonML2);
    }

    private void processObjectLiteral(Node node, JsonML jsonML) {
        JsonML jsonML2 = new JsonML(TagType.ObjectExpr);
        jsonML.appendChild(jsonML2);
        Iterator<Node> iterator = node.children().iterator();
        while (iterator.hasNext()) {
            JsonML jsonML3 = new JsonML(TagType.DataProp);
            Node node2 = iterator.next();
            Object object = null;
            switch (node2.getType()) {
                case 40: {
                    object = node2.getString();
                    break;
                }
                case 39: {
                    object = node2.getDouble();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal type of node.");
                }
            }
            jsonML3.setAttribute(TagAttr.NAME, object);
            this.processNode(iterator.next(), jsonML3);
            jsonML2.appendChild(jsonML3);
        }
    }

    private void processRegExp(Node node, JsonML jsonML) {
        JsonML jsonML2 = new JsonML(TagType.RegExpExpr);
        jsonML.appendChild(jsonML2);
        Node node2 = node.getFirstChild();
        jsonML2.setAttribute(TagAttr.BODY, node2.getString());
        String string = "";
        node2 = node2.getNext();
        if (node2 != null) {
            string = node2.getString();
        }
        jsonML2.setAttribute(TagAttr.FLAGS, string);
    }

    private void processSwitch(Node node, JsonML jsonML) {
        JsonML jsonML2 = new JsonML(TagType.SwitchStmt);
        jsonML.appendChild(jsonML2);
        Node node2 = node.getFirstChild();
        this.processNode(node2, jsonML2);
        for (Node node3 = node2.getNext(); node3 != null; node3 = node3.getNext()) {
            this.processNode(node3, jsonML2);
        }
    }

    private void processThis(Node node, JsonML jsonML) {
        jsonML.appendChild(new JsonML(TagType.ThisExpr));
    }

    private void processThrow(Node node, JsonML jsonML) {
        JsonML jsonML2 = new JsonML(TagType.ThrowStmt);
        jsonML.appendChild(jsonML2);
        this.processNode(node.getFirstChild(), jsonML2);
    }

    private void processTry(Node node, JsonML jsonML) {
        JsonML jsonML2 = new JsonML(TagType.TryStmt);
        jsonML.appendChild(jsonML2);
        Node node2 = node.getFirstChild();
        this.processNode(node2, jsonML2);
        node2 = node2.getNext();
        if (node2.hasChildren()) {
            this.processNode(node2.getFirstChild(), jsonML2);
        } else {
            jsonML2.appendChild(new JsonML(TagType.Empty));
        }
        node2 = node2.getNext();
        if (node2 != null) {
            this.processNode(node2, jsonML2);
        }
    }

    private void processTwoArgExpr(Node node, JsonML jsonML, TagType tagType) {
        this.processTwoArgExpr(node, jsonML, tagType, null);
    }

    private void processTwoArgExpr(Node node, JsonML jsonML, TagType tagType, String string) {
        JsonML jsonML2 = new JsonML(tagType);
        if (string != null) {
            jsonML2.setAttribute(TagAttr.OP, string);
        }
        jsonML.appendChild(jsonML2);
        Preconditions.checkState((node.getChildCount() == 2 ? 1 : 0) != 0);
        Node node2 = node.getFirstChild();
        this.processNode(node2, jsonML2);
        this.processNode(node2.getNext(), jsonML2);
    }

    private void processUnaryExpr(Node node, JsonML jsonML, String string) {
        JsonML jsonML2 = new JsonML(TagType.UnaryExpr);
        jsonML2.setAttribute(TagAttr.OP, string);
        jsonML.appendChild(jsonML2);
        this.processNode(node.getFirstChild(), jsonML2);
    }

    private void processVar(Node node, JsonML jsonML) {
        JsonML jsonML2 = new JsonML(TagType.VarDecl);
        jsonML.appendChild(jsonML2);
        for (Node node2 : node.children()) {
            JsonML jsonML3 = new JsonML(TagType.IdPatt);
            jsonML3.setAttribute(TagAttr.NAME, node2.getString());
            if (node2.hasChildren()) {
                JsonML jsonML4 = new JsonML(TagType.InitPatt);
                jsonML2.appendChild(jsonML4);
                jsonML4.appendChild(jsonML3);
                this.processNode(node2.getFirstChild(), jsonML4);
                continue;
            }
            jsonML2.appendChild(jsonML3);
        }
    }

    private void processReturn(Node node, JsonML jsonML) {
        JsonML jsonML2 = new JsonML(TagType.ReturnStmt);
        jsonML.appendChild(jsonML2);
        if (node.hasChildren()) {
            this.processNode(node.getFirstChild(), jsonML2);
        }
    }

    private void processScript(Node node, JsonML jsonML) {
        JsonML jsonML2 = new JsonML(TagType.Program);
        jsonML.appendChild(jsonML2);
        this.processDirectives(node, jsonML2);
        this.processChildren(node, jsonML2);
    }

    private void processWith(Node node, JsonML jsonML) {
        JsonML jsonML2 = new JsonML(TagType.WithStmt);
        jsonML.appendChild(jsonML2);
        Node node2 = node.getFirstChild();
        this.processNode(node2, jsonML2);
        node2 = node2.getNext();
        this.processNode(node2, jsonML2);
    }

    private void processChildren(Node node, JsonML jsonML) {
        for (Node node2 : node.children()) {
            this.processNode(node2, jsonML);
        }
    }

    private void processDirectives(Node node, JsonML jsonML) {
        Set<String> set = node.getDirectives();
        if (set == null) {
            return;
        }
        for (String string : set) {
            JsonML jsonML2 = new JsonML(TagType.PrologueDecl);
            jsonML2.setAttribute(TagAttr.DIRECTIVE, string);
            jsonML2.setAttribute(TagAttr.VALUE, string);
            jsonML.appendChild(jsonML2);
        }
    }

    private void processOneArgExpr(Node node, JsonML jsonML, TagType tagType) {
        JsonML jsonML2 = new JsonML(tagType);
        jsonML.appendChild(jsonML2);
        this.processNode(node.getFirstChild(), jsonML2);
    }
}

