/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.jsonml;

import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.Arrays;

public class Validator {
    public static final String MISSING_ARGUMENT = "No %s attribute specified for %s.";
    public static final String NOT_ENOUGH_CHILDREN_FMT = "Not enough children for %s. Expected: %d. Found: %d.";
    public static final String TOO_MANY_CHILDREN_FMT = "Too many children for %s. Expected: %d. Found: %d.";
    public static final String WRONG_CHILD_TYPE_FMT = "Wrong type of child number %d for %s. Expected: %s. Found: %s.";
    public static TagType[] exprTypes = new TagType[]{TagType.ArrayExpr, TagType.AssignExpr, TagType.BinaryExpr, TagType.CallExpr, TagType.ConditionalExpr, TagType.CountExpr, TagType.DeleteExpr, TagType.EvalExpr, TagType.IdExpr, TagType.InvokeExpr, TagType.LiteralExpr, TagType.LogicalAndExpr, TagType.LogicalOrExpr, TagType.MemberExpr, TagType.NewExpr, TagType.ObjectExpr, TagType.RegExpExpr, TagType.ThisExpr, TagType.TypeofExpr, TagType.UnaryExpr, TagType.FunctionExpr};
    private final StringBuilder b = new StringBuilder();
    private boolean error = false;

    private Validator() {
    }

    public static String validate(JsonML jsonML) {
        return new Validator().doValidate(jsonML);
    }

    private String doValidate(JsonML jsonML) {
        switch (jsonML.getType()) {
            case AssignExpr: {
                this.validateAssignExpr(jsonML);
                break;
            }
            case BinaryExpr: {
                this.validateBinaryExpr(jsonML);
                break;
            }
            case BreakStmt: 
            case ContinueStmt: {
                this.validateJmpStmt(jsonML);
                break;
            }
            case Case: {
                this.validateCase(jsonML);
                break;
            }
            case CatchClause: {
                this.validateCatchClause(jsonML);
                break;
            }
            case ConditionalExpr: {
                this.validateConditionalExpr(jsonML);
                break;
            }
            case CountExpr: {
                this.validateCountExpr(jsonML);
                break;
            }
            case DataProp: {
                this.validateDataProp(jsonML);
                break;
            }
            case DeleteExpr: {
                this.validateDeleteExpr(jsonML);
                break;
            }
            case DoWhileStmt: {
                this.validateDoWhileStmt(jsonML);
                break;
            }
            case EmptyStmt: {
                this.validateEmptyStmt(jsonML);
                break;
            }
            case ForInStmt: {
                this.validateForInStmt(jsonML);
                break;
            }
            case ForStmt: {
                this.validateForStmt(jsonML);
                break;
            }
            case FunctionDecl: {
                this.validateFunctionDecl(jsonML);
                break;
            }
            case FunctionExpr: {
                this.validateFunctionExpr(jsonML);
                break;
            }
            case IdExpr: {
                this.validateIdExpr(jsonML);
                break;
            }
            case IdPatt: {
                this.validateIdPatt(jsonML);
                break;
            }
            case IfStmt: {
                this.validateIfStmt(jsonML);
                break;
            }
            case InvokeExpr: {
                this.validateInvokeExpr(jsonML);
                break;
            }
            case LabelledStmt: {
                this.validateLabelledStmt(jsonML);
                break;
            }
            case LiteralExpr: {
                this.validateLiteralExpr(jsonML);
                break;
            }
            case LogicalAndExpr: 
            case LogicalOrExpr: {
                this.validateLogicalExpr(jsonML);
                break;
            }
            case MemberExpr: {
                this.validateMemberExpr(jsonML);
                break;
            }
            case NewExpr: {
                this.validateNewExpr(jsonML);
                break;
            }
            case ObjectExpr: {
                this.validateObjectExpr(jsonML);
                break;
            }
            case ParamDecl: {
                this.validateParamDecl(jsonML);
                break;
            }
            case RegExpExpr: {
                this.validateRegExpExpr(jsonML);
                break;
            }
            case ReturnStmt: {
                this.validateReturnStmt(jsonML);
                break;
            }
            case SwitchStmt: {
                this.validateSwitchStmt(jsonML);
                break;
            }
            case ThisExpr: {
                this.validateThisExpr(jsonML);
                break;
            }
            case ThrowStmt: {
                this.validateThrowStmt(jsonML);
                break;
            }
            case TryStmt: {
                this.validateTryStmt(jsonML);
                break;
            }
            case TypeofExpr: {
                this.validateTypeofExpr(jsonML);
                break;
            }
            case UnaryExpr: {
                this.validateUnaryExpr(jsonML);
                break;
            }
            case VarDecl: {
                this.validateVarDecl(jsonML);
                break;
            }
            case WhileStmt: {
                this.validateWhileStmt(jsonML);
                break;
            }
            case WithStmt: {
                this.validateWithStmt(jsonML);
            }
        }
        return this.b.length() != 0 ? this.b.toString() : null;
    }

    private void validateAssignExpr(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 2);
        this.validateArgument(jsonML, TagAttr.OP);
    }

    private void validateBinaryExpr(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 2);
        this.validateArgument(jsonML, TagAttr.OP);
    }

    private void validateCase(JsonML jsonML) {
        this.validateMinChildrenSize(jsonML, 1);
        if (!this.error) {
            this.validateIsChildExpression(jsonML, 0);
        }
    }

    private void validateCatchClause(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 2);
        if (!this.error) {
            this.validateChildType(jsonML, TagType.IdPatt, 0);
            this.validateChildType(jsonML, TagType.BlockStmt, 1);
        }
    }

    private void validateConditionalExpr(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 3);
    }

    private void validateCountExpr(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 1);
        this.validateArgument(jsonML, TagAttr.IS_PREFIX);
        this.validateArgument(jsonML, TagAttr.OP);
    }

    private void validateDataProp(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 1);
        if (!this.error) {
            this.validateArgument(jsonML, TagAttr.NAME);
        }
    }

    private void validateDeleteExpr(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 1);
    }

    private void validateDoWhileStmt(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 2);
    }

    private void validateEmptyStmt(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 0);
    }

    private void validateForInStmt(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 3);
    }

    private void validateForStmt(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 4);
    }

    private void validateFunctionDecl(JsonML jsonML) {
        this.validateFunction(jsonML, true);
    }

    private void validateFunctionExpr(JsonML jsonML) {
        this.validateFunction(jsonML, false);
    }

    private void validateIdExpr(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 0);
        if (!this.error) {
            this.validateArgument(jsonML, TagAttr.NAME);
        }
    }

    private void validateIdPatt(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 0);
        this.validateArgument(jsonML, TagAttr.NAME);
    }

    private void validateIfStmt(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 3);
        if (!this.error) {
            // empty if block
        }
    }

    private void validateInvokeExpr(JsonML jsonML) {
        this.validateMinChildrenSize(jsonML, 2);
        this.validateArgument(jsonML, TagAttr.OP);
    }

    private void validateJmpStmt(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 0);
    }

    private void validateLabelledStmt(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 1);
        this.validateArgument(jsonML, TagAttr.LABEL);
    }

    private void validateLiteralExpr(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 0);
        this.validateArgument(jsonML, TagAttr.TYPE);
        this.validateArgument(jsonML, TagAttr.VALUE);
    }

    private void validateLogicalExpr(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 2);
    }

    private void validateMemberExpr(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 2);
        this.validateArgument(jsonML, TagAttr.OP);
    }

    private void validateNewExpr(JsonML jsonML) {
        this.validateMinChildrenSize(jsonML, 1);
    }

    private void validateObjectExpr(JsonML jsonML) {
        for (int i = 0; i < jsonML.childrenSize(); ++i) {
            this.validateChildType(jsonML, TagType.DataProp, i);
        }
    }

    private void validateParamDecl(JsonML jsonML) {
        for (int i = 0; i < jsonML.childrenSize(); ++i) {
            this.validateChildType(jsonML, TagType.IdPatt, i);
        }
    }

    private void validateRegExpExpr(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 0);
        this.validateArgument(jsonML, TagAttr.BODY);
        this.validateArgument(jsonML, TagAttr.FLAGS);
    }

    private void validateReturnStmt(JsonML jsonML) {
        this.validateMaxChildrenSize(jsonML, 1);
    }

    private void validateSwitchStmt(JsonML jsonML) {
        this.validateMinChildrenSize(jsonML, 1);
        boolean bl = false;
        for (int i = 1; i < jsonML.childrenSize(); ++i) {
            if (!bl) {
                this.validateChildType(jsonML, new TagType[]{TagType.Case, TagType.DefaultCase}, i);
            } else {
                this.validateChildType(jsonML, TagType.Case, i);
            }
            if (this.error) break;
            if (jsonML.getChild(i).getType() != TagType.DefaultCase) continue;
            bl = true;
        }
    }

    private void validateThisExpr(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 0);
    }

    private void validateThrowStmt(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 1);
    }

    private void validateTryStmt(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 2, 3);
        if (this.error) {
            return;
        }
        this.validateChildType(jsonML, TagType.BlockStmt, 0);
        TagType[] tagTypeArray = new TagType[]{TagType.CatchClause, TagType.Empty};
        this.validateChildType(jsonML, tagTypeArray, 1);
        if (jsonML.childrenSize() > 2) {
            this.validateChildType(jsonML, TagType.BlockStmt, 2);
        }
    }

    private void validateFunction(JsonML jsonML, boolean bl) {
        this.validateMinChildrenSize(jsonML, 2);
        if (this.error) {
            return;
        }
        if (bl) {
            this.validateChildType(jsonML, new TagType[]{TagType.IdPatt}, 0);
        } else {
            this.validateChildType(jsonML, new TagType[]{TagType.IdPatt, TagType.Empty}, 0);
        }
        this.validateChildType(jsonML, TagType.ParamDecl, 1);
    }

    private void validateTypeofExpr(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 1);
    }

    private void validateUnaryExpr(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 1);
        if (!this.error) {
            this.validateArgument(jsonML, TagAttr.OP);
        }
    }

    private void validateVarDecl(JsonML jsonML) {
        this.validateMinChildrenSize(jsonML, 1);
        TagType[] tagTypeArray = new TagType[]{TagType.InitPatt, TagType.IdPatt};
        for (int i = 0; i < jsonML.childrenSize(); ++i) {
            this.validateChildType(jsonML, tagTypeArray, i);
        }
    }

    private void validateWhileStmt(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 2);
    }

    private void validateWithStmt(JsonML jsonML) {
        this.validateChildrenSize(jsonML, 2);
    }

    private void validateArgument(JsonML jsonML, TagAttr tagAttr) {
        Object object = jsonML.getAttribute(tagAttr);
        if (object == null) {
            String string = (String)jsonML.getAttribute(TagAttr.TYPE);
            if (string != null && string.equals("null")) {
                return;
            }
            this.error = true;
            this.appendLine(String.format(MISSING_ARGUMENT, new Object[]{tagAttr, jsonML.getType()}));
        }
    }

    private void validateChildrenSize(JsonML jsonML, int n) {
        this.validateChildrenSize(jsonML, n, n);
    }

    private void validateChildrenSize(JsonML jsonML, int n, int n2) {
        this.validateMinChildrenSize(jsonML, n);
        if (!this.error) {
            this.validateMaxChildrenSize(jsonML, n2);
        }
    }

    private void validateMinChildrenSize(JsonML jsonML, int n) {
        int n2 = jsonML.childrenSize();
        if (n2 < n) {
            this.appendLine(String.format(NOT_ENOUGH_CHILDREN_FMT, new Object[]{jsonML.getType(), n, n2}));
            this.error = true;
        }
    }

    private void validateMaxChildrenSize(JsonML jsonML, int n) {
        int n2 = jsonML.childrenSize();
        if (n2 > n) {
            this.appendLine(String.format(TOO_MANY_CHILDREN_FMT, jsonML.getType().toString(), n, n2));
            this.error = true;
        }
    }

    private void validateIsChildExpression(JsonML jsonML, int n) {
        this.validateChildType(jsonML, exprTypes, n);
    }

    private void validateChildType(JsonML jsonML, TagType tagType, int n) {
        TagType[] tagTypeArray = new TagType[]{tagType};
        this.validateChildType(jsonML, tagTypeArray, n);
    }

    private void validateChildType(JsonML jsonML, TagType[] tagTypeArray, int n) {
        TagType tagType = jsonML.getChild(n).getType();
        if (!Arrays.asList(tagTypeArray).contains((Object)tagType)) {
            this.appendLine(String.format(WRONG_CHILD_TYPE_FMT, new Object[]{n, jsonML.getType(), Validator.printList((Object[])tagTypeArray), tagType}));
            this.error = true;
        }
    }

    private void appendLine(String string) {
        this.b.append(String.format("%s", string));
    }

    public static String printList(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (objectArray.length == 1) {
            stringBuilder.append(objectArray[0].toString());
        } else if (objectArray.length > 1) {
            stringBuilder.append('[');
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuilder.append(objectArray[i].toString());
                if (i >= objectArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }
}

