/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.HasBeforeSelectionHandlers;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HasWordWrap;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.KeyboardListenerCollection;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.SourcesTabEvents;
import com.google.gwt.user.client.ui.TabListener;
import com.google.gwt.user.client.ui.Widget;

public class TabBar
extends Composite
implements SourcesTabEvents,
HasBeforeSelectionHandlers<Integer>,
HasSelectionHandlers<Integer>,
ClickListener,
KeyboardListener {
    private static final String STYLENAME_DEFAULT = "gwt-TabBarItem";
    private HorizontalPanel panel = new HorizontalPanel();
    private Widget selectedTab;

    public TabBar() {
        this.initWidget(this.panel);
        this.sinkEvents(1);
        this.setStyleName("gwt-TabBar");
        Roles.getTablistRole().set(this.panel.getElement());
        this.panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
        HTML first = new HTML("&nbsp;", true);
        HTML rest = new HTML("&nbsp;", true);
        first.setStyleName("gwt-TabBarFirst");
        rest.setStyleName("gwt-TabBarRest");
        first.setHeight("100%");
        rest.setHeight("100%");
        this.panel.add(first);
        this.panel.add(rest);
        first.setHeight("100%");
        this.panel.setCellHeight(first, "100%");
        this.panel.setCellWidth(rest, "100%");
        TabBar.setStyleName(first.getElement().getParentElement(), "gwt-TabBarFirst-wrapper");
        TabBar.setStyleName(rest.getElement().getParentElement(), "gwt-TabBarRest-wrapper");
    }

    @Override
    public HandlerRegistration addBeforeSelectionHandler(BeforeSelectionHandler<Integer> handler) {
        return this.addHandler(handler, BeforeSelectionEvent.getType());
    }

    @Override
    public HandlerRegistration addSelectionHandler(SelectionHandler<Integer> handler) {
        return this.addHandler(handler, SelectionEvent.getType());
    }

    public void addTab(SafeHtml html) {
        this.addTab(html.asString(), true);
    }

    public void addTab(String text) {
        this.insertTab(text, this.getTabCount());
    }

    public void addTab(String text, boolean asHTML) {
        this.insertTab(text, asHTML, this.getTabCount());
    }

    public void addTab(Widget widget) {
        this.insertTab(widget, this.getTabCount());
    }

    @Override
    @Deprecated
    public void addTabListener(TabListener listener) {
        ListenerWrapper.WrappedTabListener.add(this, listener);
    }

    public int getSelectedTab() {
        if (this.selectedTab == null) {
            return -1;
        }
        return this.panel.getWidgetIndex(this.selectedTab) - 1;
    }

    public final Tab getTab(int index) {
        if (index >= this.getTabCount()) {
            return null;
        }
        ClickDelegatePanel p = (ClickDelegatePanel)this.panel.getWidget(index + 1);
        return p;
    }

    public int getTabCount() {
        return this.panel.getWidgetCount() - 2;
    }

    public String getTabHTML(int index) {
        if (index >= this.getTabCount()) {
            return null;
        }
        ClickDelegatePanel delPanel = (ClickDelegatePanel)this.panel.getWidget(index + 1);
        SimplePanel focusablePanel = delPanel.getFocusablePanel();
        Widget widget = focusablePanel.getWidget();
        if (widget instanceof HTML) {
            return ((HTML)widget).getHTML();
        }
        if (widget instanceof Label) {
            return ((Label)widget).getText();
        }
        return focusablePanel.getElement().getParentElement().getInnerHTML();
    }

    public void insertTab(SafeHtml html, int beforeIndex) {
        this.insertTab(html.asString(), true, beforeIndex);
    }

    public void insertTab(String text, boolean asHTML, int beforeIndex) {
        this.checkInsertBeforeTabIndex(beforeIndex);
        Label item = asHTML ? new HTML(text) : new Label(text);
        item.setWordWrap(false);
        this.insertTabWidget(item, beforeIndex);
    }

    public void insertTab(String text, int beforeIndex) {
        this.insertTab(text, false, beforeIndex);
    }

    public void insertTab(Widget widget, int beforeIndex) {
        this.insertTabWidget(widget, beforeIndex);
    }

    public boolean isTabEnabled(int index) {
        assert (index >= 0 && index < this.getTabCount()) : "Tab index out of bounds";
        ClickDelegatePanel delPanel = (ClickDelegatePanel)this.panel.getWidget(index + 1);
        return delPanel.isEnabled();
    }

    @Override
    @Deprecated
    public void onClick(Widget sender) {
    }

    @Override
    @Deprecated
    public void onKeyDown(Widget sender, char keyCode, int modifiers) {
    }

    @Override
    @Deprecated
    public void onKeyPress(Widget sender, char keyCode, int modifiers) {
    }

    @Override
    @Deprecated
    public void onKeyUp(Widget sender, char keyCode, int modifiers) {
    }

    public void removeTab(int index) {
        this.checkTabIndex(index);
        Widget toRemove = this.panel.getWidget(index + 1);
        if (toRemove == this.selectedTab) {
            this.selectedTab = null;
        }
        this.panel.remove(toRemove);
    }

    @Override
    @Deprecated
    public void removeTabListener(TabListener listener) {
        ListenerWrapper.WrappedTabListener.remove(this, listener);
    }

    public boolean selectTab(int index) {
        return this.selectTab(index, true);
    }

    public boolean selectTab(int index, boolean fireEvents) {
        BeforeSelectionEvent<Integer> event;
        this.checkTabIndex(index);
        if (fireEvents && (event = BeforeSelectionEvent.fire(this, index)) != null && event.isCanceled()) {
            return false;
        }
        this.setSelectionStyle(this.selectedTab, false);
        if (index == -1) {
            this.selectedTab = null;
            return true;
        }
        this.selectedTab = this.panel.getWidget(index + 1);
        this.setSelectionStyle(this.selectedTab, true);
        if (fireEvents) {
            SelectionEvent.fire(this, index);
        }
        return true;
    }

    public void setTabEnabled(int index, boolean enabled) {
        assert (index >= 0 && index < this.getTabCount()) : "Tab index out of bounds";
        ClickDelegatePanel delPanel = (ClickDelegatePanel)this.panel.getWidget(index + 1);
        delPanel.setEnabled(enabled);
        TabBar.setStyleName(delPanel.getElement(), "gwt-TabBarItem-disabled", !enabled);
        TabBar.setStyleName(delPanel.getElement().getParentElement(), "gwt-TabBarItem-wrapper-disabled", !enabled);
    }

    public void setTabHTML(int index, String html) {
        assert (index >= 0 && index < this.getTabCount()) : "Tab index out of bounds";
        ClickDelegatePanel delPanel = (ClickDelegatePanel)this.panel.getWidget(index + 1);
        SimplePanel focusablePanel = delPanel.getFocusablePanel();
        focusablePanel.setWidget(new HTML(html, false));
    }

    public void setTabHTML(int index, SafeHtml html) {
        this.setTabHTML(index, html.asString());
    }

    public void setTabText(int index, String text) {
        assert (index >= 0 && index < this.getTabCount()) : "Tab index out of bounds";
        ClickDelegatePanel delPanel = (ClickDelegatePanel)this.panel.getWidget(index + 1);
        SimplePanel focusablePanel = delPanel.getFocusablePanel();
        focusablePanel.setWidget(new Label(text, false));
    }

    protected SimplePanel createTabTextWrapper() {
        return null;
    }

    protected void insertTabWidget(Widget widget, int beforeIndex) {
        this.checkInsertBeforeTabIndex(beforeIndex);
        ClickDelegatePanel delWidget = new ClickDelegatePanel(widget);
        delWidget.setStyleName(STYLENAME_DEFAULT);
        SimplePanel focusablePanel = delWidget.getFocusablePanel();
        Roles.getTabRole().set(focusablePanel.getElement());
        this.panel.insert(delWidget, beforeIndex + 1);
        TabBar.setStyleName(DOM.getParent(delWidget.getElement()), "gwt-TabBarItem-wrapper", true);
    }

    @Override
    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        int numTabs = this.getTabCount();
        int i = 0;
        while (i < numTabs) {
            ClickDelegatePanel delPanel = (ClickDelegatePanel)this.panel.getWidget(i + 1);
            SimplePanel focusablePanel = delPanel.getFocusablePanel();
            int n = i;
            TabBar.ensureDebugId(focusablePanel.getContainerElement(), baseID, new StringBuilder(14).append("tab").append(n).toString());
            n = i++;
            TabBar.ensureDebugId(DOM.getParent(delPanel.getElement()), baseID, new StringBuilder(22).append("tab-wrapper").append(n).toString());
        }
    }

    private void checkInsertBeforeTabIndex(int beforeIndex) {
        if (beforeIndex < 0 || beforeIndex > this.getTabCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkTabIndex(int index) {
        if (index < -1 || index >= this.getTabCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    private boolean selectTabByTabWidget(Widget tabWidget) {
        int numTabs = this.panel.getWidgetCount() - 1;
        for (int i = 1; i < numTabs; ++i) {
            if (this.panel.getWidget(i) != tabWidget) continue;
            return this.selectTab(i - 1);
        }
        return false;
    }

    private void setSelectionStyle(Widget item, boolean selected) {
        if (item != null) {
            if (selected) {
                item.addStyleName("gwt-TabBarItem-selected");
                TabBar.setStyleName(DOM.getParent(item.getElement()), "gwt-TabBarItem-wrapper-selected", true);
            } else {
                item.removeStyleName("gwt-TabBarItem-selected");
                TabBar.setStyleName(DOM.getParent(item.getElement()), "gwt-TabBarItem-wrapper-selected", false);
            }
        }
    }

    private class ClickDelegatePanel
    extends Composite
    implements Tab {
        private SimplePanel focusablePanel = new SimplePanel(FocusPanel.impl.createFocusable());
        private boolean enabled = true;

        ClickDelegatePanel(Widget child) {
            this.focusablePanel.setWidget(child);
            SimplePanel wrapperWidget = TabBar.this.createTabTextWrapper();
            if (wrapperWidget == null) {
                this.initWidget(this.focusablePanel);
            } else {
                wrapperWidget.setWidget(this.focusablePanel);
                this.initWidget(wrapperWidget);
            }
            this.sinkEvents(129);
        }

        @Override
        public HandlerRegistration addClickHandler(ClickHandler handler) {
            return this.addHandler(handler, ClickEvent.getType());
        }

        @Override
        public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
            return this.addHandler(handler, KeyDownEvent.getType());
        }

        @Override
        public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
            return this.addDomHandler(handler, KeyPressEvent.getType());
        }

        @Override
        public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
            return this.addDomHandler(handler, KeyUpEvent.getType());
        }

        public SimplePanel getFocusablePanel() {
            return this.focusablePanel;
        }

        @Override
        public boolean getWordWrap() {
            if (this.hasWordWrap()) {
                return ((HasWordWrap)((Object)this.focusablePanel.getWidget())).getWordWrap();
            }
            throw new UnsupportedOperationException("Widget does not implement HasWordWrap");
        }

        @Override
        public boolean hasWordWrap() {
            return this.focusablePanel.getWidget() instanceof HasWordWrap;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void onBrowserEvent(Event event) {
            if (!this.enabled) {
                return;
            }
            switch (DOM.eventGetType(event)) {
                case 1: {
                    TabBar.this.selectTabByTabWidget(this);
                    TabBar.this.onClick(this);
                    break;
                }
                case 128: {
                    if ((char)event.getKeyCode() == '\r') {
                        TabBar.this.selectTabByTabWidget(this);
                    }
                    TabBar.this.onKeyDown(this, (char)event.getKeyCode(), KeyboardListenerCollection.getKeyboardModifiers(event));
                }
            }
            super.onBrowserEvent(event);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public void setWordWrap(boolean wrap) {
            if (!this.hasWordWrap()) {
                throw new UnsupportedOperationException("Widget does not implement HasWordWrap");
            }
            ((HasWordWrap)((Object)this.focusablePanel.getWidget())).setWordWrap(wrap);
        }
    }

    public static interface Tab
    extends HasAllKeyHandlers,
    HasClickHandlers,
    HasWordWrap {
        public boolean hasWordWrap();
    }
}

