/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.source.util.TaskEvent;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Flow;
import com.sun.tools.javac.comp.LambdaToMethod;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.Gen;
import com.sun.tools.javac.jvm.JNIWriter;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.RichDiagnosticFormatter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavaCompiler {
    protected static final Context.Key<JavaCompiler> compilerKey = new Context.Key();
    private static final String versionRBName = "com.sun.tools.javac.resources.version";
    private static ResourceBundle versionRB;
    private static final CompilePolicy DEFAULT_COMPILE_POLICY;
    public Log log;
    JCDiagnostic.Factory diagFactory;
    protected TreeMaker make;
    protected ClassFinder finder;
    protected ClassReader reader;
    protected ClassWriter writer;
    protected JNIWriter jniWriter;
    protected Enter enter;
    protected Symtab syms;
    protected Source source;
    protected Gen gen;
    protected Names names;
    protected Attr attr;
    protected Check chk;
    protected Flow flow;
    protected TransTypes transTypes;
    protected Lower lower;
    protected Annotate annotate;
    protected final Name completionFailureName;
    protected Types types;
    protected JavaFileManager fileManager;
    protected ParserFactory parserFactory;
    protected MultiTaskListener taskListener;
    protected final Symbol.Completer sourceCompleter;
    protected Options options;
    protected Context context;
    protected boolean annotationProcessingOccurred;
    protected boolean implicitSourceFilesRead;
    protected CompileStates compileStates;
    public boolean verbose;
    public boolean sourceOutput;
    public boolean stubOutput;
    public boolean attrParseOnly;
    boolean relax;
    public boolean printFlat;
    public String encoding;
    public boolean lineDebugInfo;
    public boolean genEndPos;
    protected boolean devVerbose;
    protected boolean processPcks;
    protected boolean werror;
    protected boolean explicitAnnotationProcessingRequested;
    protected CompilePolicy compilePolicy;
    protected ImplicitSourcePolicy implicitSourcePolicy;
    public boolean verboseCompilePolicy;
    public CompileStates.CompileState shouldStopPolicyIfError;
    public CompileStates.CompileState shouldStopPolicyIfNoError;
    public Todo todo;
    public List<Closeable> closeables;
    protected Set<JavaFileObject> inputFiles;
    public boolean keepComments;
    private boolean hasBeenUsed;
    private long start_msec;
    public long elapsed_msec;
    protected boolean needRootClasses;
    private List<JCTree.JCClassDecl> rootClasses;
    boolean processAnnotations;
    Log.DeferredDiagnosticHandler deferredDiagnosticHandler;
    private JavacProcessingEnvironment procEnvImpl;
    HashMap<Env<AttrContext>, Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>>> desugaredEnvs;

    public static JavaCompiler instance(Context context) {
        JavaCompiler instance = context.get(compilerKey);
        if (instance == null) {
            instance = new JavaCompiler(context);
        }
        return instance;
    }

    public static String version() {
        return JavaCompiler.version("release");
    }

    public static String fullVersion() {
        return JavaCompiler.version("full");
    }

    private static String version(String key) {
        if (versionRB == null) {
            try {
                versionRB = ResourceBundle.getBundle(versionRBName);
            }
            catch (MissingResourceException e) {
                return Log.getLocalizedString("version.not.available", new Object[0]);
            }
        }
        try {
            return versionRB.getString(key);
        }
        catch (MissingResourceException e) {
            return Log.getLocalizedString("version.not.available", new Object[0]);
        }
    }

    public JavaCompiler(Context context) {
        block4: {
            this.sourceCompleter = new Symbol.Completer(){

                @Override
                public void complete(Symbol sym) throws Symbol.CompletionFailure {
                    JavaCompiler.this.readSourceFile((Symbol.ClassSymbol)sym);
                }
            };
            this.explicitAnnotationProcessingRequested = false;
            this.closeables = List.nil();
            this.inputFiles = new HashSet<JavaFileObject>();
            this.keepComments = false;
            this.hasBeenUsed = false;
            this.start_msec = 0L;
            this.elapsed_msec = 0L;
            this.needRootClasses = false;
            this.processAnnotations = false;
            this.procEnvImpl = null;
            this.desugaredEnvs = new HashMap();
            this.context = context;
            context.put(compilerKey, this);
            if (context.get(JavaFileManager.class) == null) {
                JavacFileManager.preRegister(context);
            }
            this.names = Names.instance(context);
            this.log = Log.instance(context);
            this.diagFactory = JCDiagnostic.Factory.instance(context);
            this.finder = ClassFinder.instance(context);
            this.reader = ClassReader.instance(context);
            this.make = TreeMaker.instance(context);
            this.writer = ClassWriter.instance(context);
            this.jniWriter = JNIWriter.instance(context);
            this.enter = Enter.instance(context);
            this.todo = Todo.instance(context);
            this.fileManager = context.get(JavaFileManager.class);
            this.parserFactory = ParserFactory.instance(context);
            this.compileStates = CompileStates.instance(context);
            try {
                this.syms = Symtab.instance(context);
            }
            catch (Symbol.CompletionFailure ex) {
                this.log.error("cant.access", ex.sym, ex.getDetailValue());
                if (!(ex instanceof ClassFinder.BadClassFile)) break block4;
                throw new Abort();
            }
        }
        this.source = Source.instance(context);
        Target target = Target.instance(context);
        this.attr = Attr.instance(context);
        this.chk = Check.instance(context);
        this.gen = Gen.instance(context);
        this.flow = Flow.instance(context);
        this.transTypes = TransTypes.instance(context);
        this.lower = Lower.instance(context);
        this.annotate = Annotate.instance(context);
        this.types = Types.instance(context);
        this.taskListener = MultiTaskListener.instance(context);
        this.finder.sourceCompleter = this.sourceCompleter;
        this.options = Options.instance(context);
        this.verbose = this.options.isSet(Option.VERBOSE);
        this.sourceOutput = this.options.isSet(Option.PRINTSOURCE);
        this.stubOutput = this.options.isSet("-stubs");
        this.relax = this.options.isSet("-relax");
        this.printFlat = this.options.isSet("-printflat");
        this.attrParseOnly = this.options.isSet("-attrparseonly");
        this.encoding = this.options.get(Option.ENCODING);
        this.lineDebugInfo = this.options.isUnset(Option.G_CUSTOM) || this.options.isSet(Option.G_CUSTOM, "lines");
        this.genEndPos = this.options.isSet(Option.XJCOV) || context.get(DiagnosticListener.class) != null;
        this.devVerbose = this.options.isSet("dev");
        this.processPcks = this.options.isSet("process.packages");
        this.werror = this.options.isSet(Option.WERROR);
        this.verboseCompilePolicy = this.options.isSet("verboseCompilePolicy");
        this.compilePolicy = this.attrParseOnly ? CompilePolicy.ATTR_ONLY : CompilePolicy.decode(this.options.get("compilePolicy"));
        this.implicitSourcePolicy = ImplicitSourcePolicy.decode(this.options.get("-implicit"));
        Name name = this.completionFailureName = this.options.isSet("failcomplete") ? this.names.fromString(this.options.get("failcomplete")) : null;
        this.shouldStopPolicyIfError = this.options.isSet("shouldStopPolicy") ? CompileStates.CompileState.valueOf(this.options.get("shouldStopPolicy")) : (this.options.isSet("shouldStopPolicyIfError") ? CompileStates.CompileState.valueOf(this.options.get("shouldStopPolicyIfError")) : CompileStates.CompileState.INIT);
        CompileStates.CompileState compileState = this.shouldStopPolicyIfNoError = this.options.isSet("shouldStopPolicyIfNoError") ? CompileStates.CompileState.valueOf(this.options.get("shouldStopPolicyIfNoError")) : CompileStates.CompileState.GENERATE;
        if (this.options.isUnset("oldDiags")) {
            this.log.setDiagnosticFormatter(RichDiagnosticFormatter.instance(context));
        }
    }

    protected boolean shouldStop(CompileStates.CompileState cs) {
        CompileStates.CompileState shouldStopPolicy = this.errorCount() > 0 || this.unrecoverableError() ? this.shouldStopPolicyIfError : this.shouldStopPolicyIfNoError;
        return cs.isAfter(shouldStopPolicy);
    }

    public int errorCount() {
        if (this.werror && this.log.nerrors == 0 && this.log.nwarnings > 0) {
            this.log.error("warnings.and.werror", new Object[0]);
        }
        return this.log.nerrors;
    }

    protected final <T> Queue<T> stopIfError(CompileStates.CompileState cs, Queue<T> queue) {
        return this.shouldStop(cs) ? new ListBuffer() : queue;
    }

    protected final <T> List<T> stopIfError(CompileStates.CompileState cs, List<T> list) {
        return this.shouldStop(cs) ? List.nil() : list;
    }

    public int warningCount() {
        return this.log.nwarnings;
    }

    public CharSequence readSource(JavaFileObject filename) {
        try {
            this.inputFiles.add(filename);
            return filename.getCharContent(false);
        }
        catch (IOException e) {
            this.log.error("error.reading.file", filename, JavacFileManager.getMessage(e));
            return null;
        }
    }

    protected JCTree.JCCompilationUnit parse(JavaFileObject filename, CharSequence content) {
        TaskEvent e;
        long msec = JavaCompiler.now();
        JCTree.JCCompilationUnit tree = this.make.TopLevel(List.nil());
        if (content != null) {
            if (this.verbose) {
                this.log.printVerbose("parsing.started", filename);
            }
            if (!this.taskListener.isEmpty()) {
                e = new TaskEvent(TaskEvent.Kind.PARSE, filename);
                this.taskListener.started(e);
                this.keepComments = true;
                this.genEndPos = true;
            }
            JavacParser parser = this.parserFactory.newParser(content, this.keepComments(), this.genEndPos, this.lineDebugInfo);
            tree = parser.parseCompilationUnit();
            if (this.verbose) {
                this.log.printVerbose("parsing.done", Long.toString(JavaCompiler.elapsed(msec)));
            }
        }
        tree.sourcefile = filename;
        if (content != null && !this.taskListener.isEmpty()) {
            e = new TaskEvent(TaskEvent.Kind.PARSE, tree);
            this.taskListener.finished(e);
        }
        return tree;
    }

    protected boolean keepComments() {
        return this.keepComments || this.sourceOutput || this.stubOutput;
    }

    @Deprecated
    public JCTree.JCCompilationUnit parse(String filename) {
        JavacFileManager fm = (JavacFileManager)this.fileManager;
        return this.parse(fm.getJavaFileObjectsFromStrings(List.of(filename)).iterator().next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCTree.JCCompilationUnit parse(JavaFileObject filename) {
        JavaFileObject prev = this.log.useSource(filename);
        try {
            JCTree.JCCompilationUnit t = this.parse(filename, this.readSource(filename));
            if (t.endPositions != null) {
                this.log.setEndPosTable(filename, t.endPositions);
            }
            JCTree.JCCompilationUnit jCCompilationUnit = t;
            return jCCompilationUnit;
        }
        finally {
            this.log.useSource(prev);
        }
    }

    public Symbol resolveBinaryNameOrIdent(String name) {
        try {
            Name flatname = this.names.fromString(name.replace("/", "."));
            return this.finder.loadClass(flatname);
        }
        catch (Symbol.CompletionFailure ignore) {
            return this.resolveIdent(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol resolveIdent(String name) {
        if (name.equals("")) {
            return this.syms.errSymbol;
        }
        JavaFileObject prev = this.log.useSource(null);
        try {
            JCTree.JCExpression tree = null;
            for (String s : name.split("\\.", -1)) {
                if (!SourceVersion.isIdentifier(s)) {
                    Symbol.ClassSymbol classSymbol = this.syms.errSymbol;
                    return classSymbol;
                }
                tree = tree == null ? this.make.Ident(this.names.fromString(s)) : this.make.Select(tree, this.names.fromString(s));
            }
            JCTree.JCCompilationUnit toplevel = this.make.TopLevel(List.nil());
            toplevel.packge = this.syms.unnamedPackage;
            Symbol symbol = this.attr.attribIdent(tree, toplevel);
            return symbol;
        }
        finally {
            this.log.useSource(prev);
        }
    }

    JavaFileObject printSource(Env<AttrContext> env, JCTree.JCClassDecl cdef) throws IOException {
        JavaFileObject outFile = this.fileManager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, cdef.sym.flatname.toString(), JavaFileObject.Kind.SOURCE, null);
        if (this.inputFiles.contains(outFile)) {
            this.log.error(cdef.pos(), "source.cant.overwrite.input.file", outFile);
            return null;
        }
        try (BufferedWriter out = new BufferedWriter(outFile.openWriter());){
            new Pretty(out, true).printUnit(env.toplevel, cdef);
            if (this.verbose) {
                this.log.printVerbose("wrote.file", outFile);
            }
        }
        return outFile;
    }

    JavaFileObject genCode(Env<AttrContext> env, JCTree.JCClassDecl cdef) throws IOException {
        try {
            if (this.gen.genClass(env, cdef) && this.errorCount() == 0) {
                return this.writer.writeClass(cdef.sym);
            }
        }
        catch (ClassWriter.PoolOverflow ex) {
            this.log.error(cdef.pos(), "limit.pool", new Object[0]);
        }
        catch (ClassWriter.StringOverflow ex) {
            this.log.error(cdef.pos(), "limit.string.overflow", ex.value.substring(0, 20));
        }
        catch (Symbol.CompletionFailure ex) {
            this.chk.completionError(cdef.pos(), ex);
        }
        return null;
    }

    private void readSourceFile(Symbol.ClassSymbol c) throws Symbol.CompletionFailure {
        this.readSourceFile(null, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSourceFile(JCTree.JCCompilationUnit tree, Symbol.ClassSymbol c) throws Symbol.CompletionFailure {
        TaskEvent e;
        if (this.completionFailureName == c.fullname) {
            throw new Symbol.CompletionFailure((Symbol)c, "user-selected completion failure by class name");
        }
        JavaFileObject filename = c.classfile;
        JavaFileObject prev = this.log.useSource(filename);
        if (tree == null) {
            try {
                tree = this.parse(filename, filename.getCharContent(false));
            }
            catch (IOException e2) {
                this.log.error("error.reading.file", filename, JavacFileManager.getMessage(e2));
                tree = this.make.TopLevel(List.nil());
            }
            finally {
                this.log.useSource(prev);
            }
        }
        if (!this.taskListener.isEmpty()) {
            e = new TaskEvent(TaskEvent.Kind.ENTER, tree);
            this.taskListener.started(e);
        }
        this.enter.complete(List.of(tree), c);
        if (!this.taskListener.isEmpty()) {
            e = new TaskEvent(TaskEvent.Kind.ENTER, tree);
            this.taskListener.finished(e);
        }
        if (this.enter.getEnv(c) == null) {
            boolean isPkgInfo = tree.sourcefile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
            if (isPkgInfo) {
                if (this.enter.getEnv(tree.packge) == null) {
                    JCDiagnostic diag = this.diagFactory.fragment("file.does.not.contain.package", c.location());
                    throw new ClassFinder.BadClassFile(c, filename, diag, this.diagFactory);
                }
            } else {
                JCDiagnostic diag = this.diagFactory.fragment("file.doesnt.contain.class", c.getQualifiedName());
                throw new ClassFinder.BadClassFile(c, filename, diag, this.diagFactory);
            }
        }
        this.implicitSourceFilesRead = true;
    }

    public void compile(List<JavaFileObject> sourceFileObject) throws Throwable {
        this.compile(sourceFileObject, List.nil(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(Collection<JavaFileObject> sourceFileObjects, Collection<String> classnames, Iterable<? extends Processor> processors) {
        block28: {
            if (!this.taskListener.isEmpty()) {
                this.taskListener.started(new TaskEvent(TaskEvent.Kind.COMPILATION));
            }
            if (processors != null && processors.iterator().hasNext()) {
                this.explicitAnnotationProcessingRequested = true;
            }
            if (this.hasBeenUsed) {
                throw new AssertionError((Object)"attempt to reuse JavaCompiler");
            }
            this.hasBeenUsed = true;
            this.options.put(Option.XLINT_CUSTOM.text + "-" + Lint.LintCategory.OPTIONS.option, "true");
            this.options.remove(Option.XLINT_CUSTOM.text + Lint.LintCategory.OPTIONS.option);
            this.start_msec = JavaCompiler.now();
            try {
                this.initProcessAnnotations(processors);
                this.processAnnotations(this.enterTrees(this.stopIfError(CompileStates.CompileState.PARSE, this.parseFiles(sourceFileObjects))), classnames);
                if (this.taskListener.isEmpty() && this.implicitSourcePolicy == ImplicitSourcePolicy.NONE) {
                    this.todo.retainFiles(this.inputFiles);
                }
                switch (this.compilePolicy) {
                    case ATTR_ONLY: {
                        this.attribute(this.todo);
                        break;
                    }
                    case CHECK_ONLY: {
                        this.flow(this.attribute(this.todo));
                        break;
                    }
                    case SIMPLE: {
                        this.generate(this.desugar(this.flow(this.attribute(this.todo))));
                        break;
                    }
                    case BY_FILE: {
                        Queue<Queue<Env<AttrContext>>> q = this.todo.groupByFile();
                        while (!q.isEmpty() && !this.shouldStop(CompileStates.CompileState.ATTR)) {
                            this.generate(this.desugar(this.flow(this.attribute(q.remove()))));
                        }
                        break;
                    }
                    case BY_TODO: {
                        while (!this.todo.isEmpty()) {
                            this.generate(this.desugar(this.flow(this.attribute((Env)this.todo.remove()))));
                        }
                        break;
                    }
                    default: {
                        Assert.error("unknown compile policy");
                    }
                }
                if (!this.verbose) break block28;
            }
            catch (Abort ex) {
                block29: {
                    try {
                        if (this.devVerbose) {
                            ex.printStackTrace(System.err);
                        }
                        if (!this.verbose) break block29;
                    }
                    catch (Throwable throwable) {
                        if (this.verbose) {
                            this.elapsed_msec = JavaCompiler.elapsed(this.start_msec);
                            this.log.printVerbose("total", Long.toString(this.elapsed_msec));
                        }
                        this.reportDeferredDiagnostics();
                        if (!this.log.hasDiagnosticListener()) {
                            this.printCount("error", this.errorCount());
                            this.printCount("warn", this.warningCount());
                        }
                        if (!this.taskListener.isEmpty()) {
                            this.taskListener.finished(new TaskEvent(TaskEvent.Kind.COMPILATION));
                        }
                        this.close();
                        if (this.procEnvImpl != null) {
                            this.procEnvImpl.close();
                        }
                        throw throwable;
                    }
                    this.elapsed_msec = JavaCompiler.elapsed(this.start_msec);
                    this.log.printVerbose("total", Long.toString(this.elapsed_msec));
                }
                this.reportDeferredDiagnostics();
                if (!this.log.hasDiagnosticListener()) {
                    this.printCount("error", this.errorCount());
                    this.printCount("warn", this.warningCount());
                }
                if (!this.taskListener.isEmpty()) {
                    this.taskListener.finished(new TaskEvent(TaskEvent.Kind.COMPILATION));
                }
                this.close();
                if (this.procEnvImpl != null) {
                    this.procEnvImpl.close();
                }
            }
            this.elapsed_msec = JavaCompiler.elapsed(this.start_msec);
            this.log.printVerbose("total", Long.toString(this.elapsed_msec));
        }
        this.reportDeferredDiagnostics();
        if (!this.log.hasDiagnosticListener()) {
            this.printCount("error", this.errorCount());
            this.printCount("warn", this.warningCount());
        }
        if (!this.taskListener.isEmpty()) {
            this.taskListener.finished(new TaskEvent(TaskEvent.Kind.COMPILATION));
        }
        this.close();
        if (this.procEnvImpl != null) {
            this.procEnvImpl.close();
        }
    }

    public List<JCTree.JCCompilationUnit> parseFiles(Iterable<JavaFileObject> fileObjects) {
        if (this.shouldStop(CompileStates.CompileState.PARSE)) {
            return List.nil();
        }
        ListBuffer<JCTree.JCCompilationUnit> trees = new ListBuffer<JCTree.JCCompilationUnit>();
        HashSet<JavaFileObject> filesSoFar = new HashSet<JavaFileObject>();
        for (JavaFileObject fileObject : fileObjects) {
            if (filesSoFar.contains(fileObject)) continue;
            filesSoFar.add(fileObject);
            trees.append(this.parse(fileObject));
        }
        return trees.toList();
    }

    public List<JCTree.JCCompilationUnit> enterTreesIfNeeded(List<JCTree.JCCompilationUnit> roots) {
        if (this.shouldStop(CompileStates.CompileState.ATTR)) {
            return List.nil();
        }
        return this.enterTrees(roots);
    }

    public List<JCTree.JCCompilationUnit> enterTrees(List<JCTree.JCCompilationUnit> roots) {
        TaskEvent e;
        if (!this.taskListener.isEmpty()) {
            for (JCTree.JCCompilationUnit jCCompilationUnit : roots) {
                e = new TaskEvent(TaskEvent.Kind.ENTER, jCCompilationUnit);
                this.taskListener.started(e);
            }
        }
        this.enter.main(roots);
        if (!this.taskListener.isEmpty()) {
            for (JCTree.JCCompilationUnit jCCompilationUnit : roots) {
                e = new TaskEvent(TaskEvent.Kind.ENTER, jCCompilationUnit);
                this.taskListener.finished(e);
            }
        }
        if (this.needRootClasses || this.sourceOutput || this.stubOutput) {
            ListBuffer<JCTree.JCClassDecl> cdefs = new ListBuffer<JCTree.JCClassDecl>();
            for (JCTree.JCCompilationUnit unit : roots) {
                List<JCTree> defs = unit.defs;
                while (defs.nonEmpty()) {
                    if (defs.head instanceof JCTree.JCClassDecl) {
                        cdefs.append((JCTree.JCClassDecl)defs.head);
                    }
                    defs = defs.tail;
                }
            }
            this.rootClasses = cdefs.toList();
        }
        for (JCTree.JCCompilationUnit jCCompilationUnit : roots) {
            this.inputFiles.add(jCCompilationUnit.sourcefile);
        }
        return roots;
    }

    public void initProcessAnnotations(Iterable<? extends Processor> processors) {
        if (this.options.isSet(Option.PROC, "none")) {
            this.processAnnotations = false;
        } else if (this.procEnvImpl == null) {
            this.procEnvImpl = JavacProcessingEnvironment.instance(this.context);
            this.procEnvImpl.setProcessors(processors);
            this.processAnnotations = this.procEnvImpl.atLeastOneProcessor();
            if (this.processAnnotations) {
                this.options.put("save-parameter-names", "save-parameter-names");
                this.reader.saveParameterNames = true;
                this.keepComments = true;
                this.genEndPos = true;
                if (!this.taskListener.isEmpty()) {
                    this.taskListener.started(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING));
                }
                this.deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.log);
            } else {
                this.procEnvImpl.close();
            }
        }
    }

    public void processAnnotations(List<JCTree.JCCompilationUnit> roots) {
        this.processAnnotations(roots, List.nil());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAnnotations(List<JCTree.JCCompilationUnit> roots, Collection<String> classnames) {
        block19: {
            if (this.shouldStop(CompileStates.CompileState.PROCESS) && this.unrecoverableError()) {
                this.deferredDiagnosticHandler.reportDeferredDiagnostics();
                this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
                return;
            }
            if (!this.processAnnotations) {
                if (this.options.isSet(Option.PROC, "only")) {
                    this.log.warning("proc.proc-only.requested.no.procs", new Object[0]);
                    this.todo.clear();
                }
                if (!classnames.isEmpty()) {
                    this.log.error("proc.no.explicit.annotation.processing.requested", classnames);
                }
                Assert.checkNull(this.deferredDiagnosticHandler);
                return;
            }
            Assert.checkNonNull(this.deferredDiagnosticHandler);
            try {
                List<Symbol.ClassSymbol> classSymbols = List.nil();
                List<Object> pckSymbols = List.nil();
                if (!classnames.isEmpty()) {
                    if (!this.explicitAnnotationProcessingRequested()) {
                        this.log.error("proc.no.explicit.annotation.processing.requested", classnames);
                        this.deferredDiagnosticHandler.reportDeferredDiagnostics();
                        this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
                        return;
                    }
                    boolean errors = false;
                    for (String nameStr : classnames) {
                        Symbol sym = this.resolveBinaryNameOrIdent(nameStr);
                        if (sym == null || sym.kind == Kinds.Kind.PCK && !this.processPcks || sym.kind == Kinds.Kind.ABSENT_TYP) {
                            this.log.error("proc.cant.find.class", nameStr);
                            errors = true;
                            continue;
                        }
                        try {
                            if (sym.kind == Kinds.Kind.PCK) {
                                sym.complete();
                            }
                            if (sym.exists()) {
                                if (sym.kind == Kinds.Kind.PCK) {
                                    pckSymbols = pckSymbols.prepend((Symbol.PackageSymbol)sym);
                                    continue;
                                }
                                classSymbols = classSymbols.prepend((Symbol.ClassSymbol)sym);
                                continue;
                            }
                            Assert.check(sym.kind == Kinds.Kind.PCK);
                            this.log.warning("proc.package.does.not.exist", nameStr);
                            pckSymbols = pckSymbols.prepend((Symbol.PackageSymbol)sym);
                        }
                        catch (Symbol.CompletionFailure e) {
                            this.log.error("proc.cant.find.class", nameStr);
                            errors = true;
                        }
                    }
                    if (errors) {
                        this.deferredDiagnosticHandler.reportDeferredDiagnostics();
                        this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
                        return;
                    }
                }
                try {
                    this.annotationProcessingOccurred = this.procEnvImpl.doProcessing(roots, classSymbols, pckSymbols, this.deferredDiagnosticHandler);
                }
                finally {
                    this.procEnvImpl.close();
                }
            }
            catch (Symbol.CompletionFailure ex) {
                this.log.error("cant.access", ex.sym, ex.getDetailValue());
                if (this.deferredDiagnosticHandler == null) break block19;
                this.deferredDiagnosticHandler.reportDeferredDiagnostics();
                this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
            }
        }
    }

    private boolean unrecoverableError() {
        if (this.deferredDiagnosticHandler != null) {
            for (JCDiagnostic d : this.deferredDiagnosticHandler.getDiagnostics()) {
                if (d.getKind() != Diagnostic.Kind.ERROR || d.isFlagSet(JCDiagnostic.DiagnosticFlag.RECOVERABLE)) continue;
                return true;
            }
        }
        return false;
    }

    boolean explicitAnnotationProcessingRequested() {
        return this.explicitAnnotationProcessingRequested || JavaCompiler.explicitAnnotationProcessingRequested(this.options);
    }

    static boolean explicitAnnotationProcessingRequested(Options options) {
        return options.isSet(Option.PROCESSOR) || options.isSet(Option.PROCESSORPATH) || options.isSet(Option.PROC, "only") || options.isSet(Option.XPRINT);
    }

    public void setDeferredDiagnosticHandler(Log.DeferredDiagnosticHandler deferredDiagnosticHandler) {
        this.deferredDiagnosticHandler = deferredDiagnosticHandler;
    }

    public Queue<Env<AttrContext>> attribute(Queue<Env<AttrContext>> envs) {
        ListBuffer<Env<AttrContext>> results = new ListBuffer<Env<AttrContext>>();
        while (!envs.isEmpty()) {
            results.append(this.attribute(envs.remove()));
        }
        return this.stopIfError(CompileStates.CompileState.ATTR, results);
    }

    public Env<AttrContext> attribute(Env<AttrContext> env) {
        if (this.compileStates.isDone(env, CompileStates.CompileState.ATTR)) {
            return env;
        }
        if (this.verboseCompilePolicy) {
            this.printNote("[attribute " + env.enclClass.sym + "]");
        }
        if (this.verbose) {
            this.log.printVerbose("checking.attribution", env.enclClass.sym);
        }
        if (!this.taskListener.isEmpty()) {
            TaskEvent e = new TaskEvent(TaskEvent.Kind.ANALYZE, env.toplevel, env.enclClass.sym);
            this.taskListener.started(e);
        }
        JavaFileObject prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
        try {
            this.attr.attrib(env);
            if (this.errorCount() > 0 && !this.shouldStop(CompileStates.CompileState.ATTR)) {
                this.attr.postAttr(env.tree);
            }
            this.compileStates.put(env, CompileStates.CompileState.ATTR);
        }
        finally {
            this.log.useSource(prev);
        }
        return env;
    }

    public Queue<Env<AttrContext>> flow(Queue<Env<AttrContext>> envs) {
        ListBuffer<Env<AttrContext>> results = new ListBuffer<Env<AttrContext>>();
        for (Env env : envs) {
            this.flow(env, results);
        }
        return this.stopIfError(CompileStates.CompileState.FLOW, results);
    }

    public Queue<Env<AttrContext>> flow(Env<AttrContext> env) {
        ListBuffer<Env<AttrContext>> results = new ListBuffer<Env<AttrContext>>();
        this.flow(env, results);
        return this.stopIfError(CompileStates.CompileState.FLOW, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flow(Env<AttrContext> env, Queue<Env<AttrContext>> results) {
        if (this.compileStates.isDone(env, CompileStates.CompileState.FLOW)) {
            results.add(env);
            return;
        }
        try {
            if (this.shouldStop(CompileStates.CompileState.FLOW)) {
                return;
            }
            if (this.relax) {
                results.add(env);
                return;
            }
            if (this.verboseCompilePolicy) {
                this.printNote("[flow " + env.enclClass.sym + "]");
            }
            JavaFileObject prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
            try {
                this.make.at(0);
                TreeMaker localMake = this.make.forToplevel(env.toplevel);
                this.flow.analyzeTree(env, localMake);
                this.compileStates.put(env, CompileStates.CompileState.FLOW);
                if (this.shouldStop(CompileStates.CompileState.FLOW)) {
                    return;
                }
                results.add(env);
            }
            finally {
                this.log.useSource(prev);
            }
        }
        finally {
            if (!this.taskListener.isEmpty()) {
                TaskEvent e = new TaskEvent(TaskEvent.Kind.ANALYZE, env.toplevel, env.enclClass.sym);
                this.taskListener.finished(e);
            }
        }
    }

    public Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> desugar(Queue<Env<AttrContext>> envs) {
        ListBuffer<Pair<Env<AttrContext>, JCTree.JCClassDecl>> results = new ListBuffer<Pair<Env<AttrContext>, JCTree.JCClassDecl>>();
        for (Env env : envs) {
            this.desugar(env, results);
        }
        return this.stopIfError(CompileStates.CompileState.FLOW, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void desugar(final Env<AttrContext> env, Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> results) {
        if (this.shouldStop(CompileStates.CompileState.TRANSTYPES)) {
            return;
        }
        if (this.implicitSourcePolicy == ImplicitSourcePolicy.NONE && !this.inputFiles.contains(env.toplevel.sourcefile)) {
            return;
        }
        if (this.compileStates.isDone(env, CompileStates.CompileState.LOWER)) {
            results.addAll((Collection<Pair<Env<AttrContext>, JCTree.JCClassDecl>>)this.desugaredEnvs.get(env));
            return;
        }
        class ScanNested
        extends TreeScanner {
            Set<Env<AttrContext>> dependencies = new LinkedHashSet<Env<AttrContext>>();
            protected boolean hasLambdas;

            ScanNested() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitClassDef(JCTree.JCClassDecl node) {
                Type st = JavaCompiler.this.types.supertype(node.sym.type);
                boolean envForSuperTypeFound = false;
                while (!envForSuperTypeFound && st.hasTag(TypeTag.CLASS)) {
                    Symbol.ClassSymbol c = st.tsym.outermostClass();
                    Env<AttrContext> stEnv = JavaCompiler.this.enter.getEnv(c);
                    if (stEnv != null && env != stEnv) {
                        if (this.dependencies.add(stEnv)) {
                            boolean prevHasLambdas = this.hasLambdas;
                            try {
                                this.scan(stEnv.tree);
                            }
                            finally {
                                this.hasLambdas = prevHasLambdas;
                            }
                        }
                        envForSuperTypeFound = true;
                    }
                    st = JavaCompiler.this.types.supertype(st);
                }
                super.visitClassDef(node);
            }

            @Override
            public void visitLambda(JCTree.JCLambda tree) {
                this.hasLambdas = true;
                super.visitLambda(tree);
            }

            @Override
            public void visitReference(JCTree.JCMemberReference tree) {
                this.hasLambdas = true;
                super.visitReference(tree);
            }
        }
        ScanNested scanner = new ScanNested();
        scanner.scan(env.tree);
        for (Env<AttrContext> dep : scanner.dependencies) {
            if (this.compileStates.isDone(dep, CompileStates.CompileState.FLOW)) continue;
            this.desugaredEnvs.put(dep, this.desugar(this.flow(this.attribute(dep))));
        }
        if (this.shouldStop(CompileStates.CompileState.TRANSTYPES)) {
            return;
        }
        if (this.verboseCompilePolicy) {
            this.printNote("[desugar " + env.enclClass.sym + "]");
        }
        JavaFileObject prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
        try {
            JCTree untranslated = env.tree;
            this.make.at(0);
            TreeMaker localMake = this.make.forToplevel(env.toplevel);
            if (env.tree.hasTag(JCTree.Tag.PACKAGEDEF)) {
                if (!(this.stubOutput || this.sourceOutput || this.printFlat)) {
                    if (this.shouldStop(CompileStates.CompileState.LOWER)) {
                        return;
                    }
                    List<JCTree> pdef = this.lower.translateTopLevelClass(env, env.tree, localMake);
                    if (pdef.head != null) {
                        Assert.check(pdef.tail.isEmpty());
                        results.add(new Pair<Env<AttrContext>, JCTree.JCClassDecl>(env, (JCTree.JCClassDecl)pdef.head));
                    }
                }
                return;
            }
            if (this.stubOutput) {
                JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)env.tree;
                if (untranslated instanceof JCTree.JCClassDecl && this.rootClasses.contains((JCTree.JCClassDecl)untranslated) && ((cdef.mods.flags & 5L) != 0L || cdef.sym.packge().getQualifiedName() == this.names.java_lang)) {
                    results.add(new Pair<Env<AttrContext>, JCTree.JCClassDecl>(env, this.removeMethodBodies(cdef)));
                }
                return;
            }
            if (this.shouldStop(CompileStates.CompileState.TRANSTYPES)) {
                return;
            }
            env.tree = this.transTypes.translateTopLevelClass(env.tree, localMake);
            this.compileStates.put(env, CompileStates.CompileState.TRANSTYPES);
            if (this.source.allowLambda() && scanner.hasLambdas) {
                if (this.shouldStop(CompileStates.CompileState.UNLAMBDA)) {
                    return;
                }
                env.tree = LambdaToMethod.instance(this.context).translateTopLevelClass(env, env.tree, localMake);
                this.compileStates.put(env, CompileStates.CompileState.UNLAMBDA);
            }
            if (this.shouldStop(CompileStates.CompileState.LOWER)) {
                return;
            }
            if (this.sourceOutput) {
                JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)env.tree;
                if (untranslated instanceof JCTree.JCClassDecl && this.rootClasses.contains((JCTree.JCClassDecl)untranslated)) {
                    results.add(new Pair<Env<AttrContext>, JCTree.JCClassDecl>(env, cdef));
                }
                return;
            }
            List<JCTree> cdefs = this.lower.translateTopLevelClass(env, env.tree, localMake);
            this.compileStates.put(env, CompileStates.CompileState.LOWER);
            if (this.shouldStop(CompileStates.CompileState.LOWER)) {
                return;
            }
            List<JCTree> l = cdefs;
            while (l.nonEmpty()) {
                JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)l.head;
                results.add(new Pair<Env<AttrContext>, JCTree.JCClassDecl>(env, cdef));
                l = l.tail;
            }
        }
        finally {
            this.log.useSource(prev);
        }
    }

    public void generate(Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> queue) {
        this.generate(queue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> queue, Queue<JavaFileObject> results) {
        if (this.shouldStop(CompileStates.CompileState.GENERATE)) {
            return;
        }
        boolean usePrintSource = this.stubOutput || this.sourceOutput || this.printFlat;
        for (Pair pair : queue) {
            Env env = (Env)pair.fst;
            JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)pair.snd;
            if (this.verboseCompilePolicy) {
                this.printNote("[generate " + (usePrintSource ? " source" : "code") + " " + cdef.sym + "]");
            }
            if (!this.taskListener.isEmpty()) {
                TaskEvent e = new TaskEvent(TaskEvent.Kind.GENERATE, env.toplevel, cdef.sym);
                this.taskListener.started(e);
            }
            JavaFileObject prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
            try {
                JavaFileObject file;
                if (usePrintSource) {
                    file = this.printSource(env, cdef);
                } else {
                    if (this.fileManager.hasLocation(StandardLocation.NATIVE_HEADER_OUTPUT) && this.jniWriter.needsHeader(cdef.sym)) {
                        this.jniWriter.write(cdef.sym);
                    }
                    file = this.genCode(env, cdef);
                }
                if (results != null && file != null) {
                    results.add(file);
                }
            }
            catch (IOException ex) {
                this.log.error(cdef.pos(), "class.cant.write", cdef.sym, ex.getMessage());
                return;
            }
            finally {
                this.log.useSource(prev);
            }
            if (this.taskListener.isEmpty()) continue;
            TaskEvent e = new TaskEvent(TaskEvent.Kind.GENERATE, env.toplevel, cdef.sym);
            this.taskListener.finished(e);
        }
    }

    Map<JCTree.JCCompilationUnit, Queue<Env<AttrContext>>> groupByFile(Queue<Env<AttrContext>> envs) {
        LinkedHashMap<JCTree.JCCompilationUnit, Queue<Env<AttrContext>>> map = new LinkedHashMap<JCTree.JCCompilationUnit, Queue<Env<AttrContext>>>();
        for (Env env : envs) {
            ListBuffer sublist = (ListBuffer)map.get(env.toplevel);
            if (sublist == null) {
                sublist = new ListBuffer();
                map.put(env.toplevel, sublist);
            }
            sublist.add(env);
        }
        return map;
    }

    JCTree.JCClassDecl removeMethodBodies(JCTree.JCClassDecl cdef) {
        final boolean isInterface = (cdef.mods.flags & 0x200L) != 0L;
        class MethodBodyRemover
        extends TreeTranslator {
            MethodBodyRemover() {
            }

            @Override
            public void visitMethodDef(JCTree.JCMethodDecl tree) {
                tree.mods.flags &= 0xFFFFFFFFFFFFFFDFL;
                for (JCTree.JCVariableDecl vd : tree.params) {
                    vd.mods.flags &= 0xFFFFFFFFFFFFFFEFL;
                }
                tree.body = null;
                super.visitMethodDef(tree);
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl tree) {
                if (tree.init != null && tree.init.type.constValue() == null) {
                    tree.init = null;
                }
                super.visitVarDef(tree);
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
                ListBuffer<JCTree> newdefs = new ListBuffer<JCTree>();
                List<JCTree> it = tree.defs;
                while (it.tail != null) {
                    JCTree t = (JCTree)it.head;
                    switch (t.getTag()) {
                        case CLASSDEF: {
                            if (!isInterface && (((JCTree.JCClassDecl)t).mods.flags & 5L) == 0L && ((((JCTree.JCClassDecl)t).mods.flags & 2L) != 0L || ((JCTree.JCClassDecl)t).sym.packge().getQualifiedName() != JavaCompiler.this.names.java_lang)) break;
                            newdefs.append(t);
                            break;
                        }
                        case METHODDEF: {
                            if (!isInterface && (((JCTree.JCMethodDecl)t).mods.flags & 5L) == 0L && ((JCTree.JCMethodDecl)t).sym.name != JavaCompiler.this.names.init && ((((JCTree.JCMethodDecl)t).mods.flags & 2L) != 0L || ((JCTree.JCMethodDecl)t).sym.packge().getQualifiedName() != JavaCompiler.this.names.java_lang)) break;
                            newdefs.append(t);
                            break;
                        }
                        case VARDEF: {
                            if (!isInterface && (((JCTree.JCVariableDecl)t).mods.flags & 5L) == 0L && ((((JCTree.JCVariableDecl)t).mods.flags & 2L) != 0L || ((JCTree.JCVariableDecl)t).sym.packge().getQualifiedName() != JavaCompiler.this.names.java_lang)) break;
                            newdefs.append(t);
                            break;
                        }
                    }
                    it = it.tail;
                }
                tree.defs = newdefs.toList();
                super.visitClassDef(tree);
            }
        }
        MethodBodyRemover r = new MethodBodyRemover();
        return r.translate(cdef);
    }

    public void reportDeferredDiagnostics() {
        if (this.errorCount() == 0 && this.annotationProcessingOccurred && this.implicitSourceFilesRead && this.implicitSourcePolicy == ImplicitSourcePolicy.UNSET) {
            if (this.explicitAnnotationProcessingRequested()) {
                this.log.warning("proc.use.implicit", new Object[0]);
            } else {
                this.log.warning("proc.use.proc.or.implicit", new Object[0]);
            }
        }
        this.chk.reportDeferredDiagnostics();
        if (this.log.compressedOutput) {
            this.log.mandatoryNote(null, "compressed.diags", new Object[0]);
        }
    }

    public void close() {
        this.rootClasses = null;
        this.finder = null;
        this.reader = null;
        this.make = null;
        this.writer = null;
        this.enter = null;
        if (this.todo != null) {
            this.todo.clear();
        }
        this.todo = null;
        this.parserFactory = null;
        this.syms = null;
        this.source = null;
        this.attr = null;
        this.chk = null;
        this.gen = null;
        this.flow = null;
        this.transTypes = null;
        this.lower = null;
        this.annotate = null;
        this.types = null;
        this.log.flush();
        try {
            this.fileManager.flush();
        }
        catch (IOException e) {
            throw new Abort(e);
        }
        finally {
            if (this.names != null) {
                this.names.dispose();
            }
            this.names = null;
            for (Closeable c : this.closeables) {
                try {
                    c.close();
                }
                catch (IOException e) {
                    JCDiagnostic msg = this.diagFactory.fragment("fatal.err.cant.close", new Object[0]);
                    throw new FatalError(msg, (Throwable)e);
                }
            }
            this.closeables = List.nil();
        }
    }

    protected void printNote(String lines) {
        this.log.printRawLines(Log.WriterKind.NOTICE, lines);
    }

    public void printCount(String kind, int count) {
        if (count != 0) {
            String key = count == 1 ? "count." + kind : "count." + kind + ".plural";
            this.log.printLines(Log.WriterKind.ERROR, key, String.valueOf(count));
            this.log.flush(Log.WriterKind.ERROR);
        }
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private static long elapsed(long then) {
        return JavaCompiler.now() - then;
    }

    public void newRound() {
        this.inputFiles.clear();
        this.todo.clear();
    }

    static {
        DEFAULT_COMPILE_POLICY = CompilePolicy.BY_TODO;
    }

    protected static enum ImplicitSourcePolicy {
        NONE,
        CLASS,
        UNSET;


        static ImplicitSourcePolicy decode(String option) {
            if (option == null) {
                return UNSET;
            }
            if (option.equals("none")) {
                return NONE;
            }
            if (option.equals("class")) {
                return CLASS;
            }
            return UNSET;
        }
    }

    protected static enum CompilePolicy {
        ATTR_ONLY,
        CHECK_ONLY,
        SIMPLE,
        BY_FILE,
        BY_TODO;


        static CompilePolicy decode(String option) {
            if (option == null) {
                return DEFAULT_COMPILE_POLICY;
            }
            if (option.equals("attr")) {
                return ATTR_ONLY;
            }
            if (option.equals("check")) {
                return CHECK_ONLY;
            }
            if (option.equals("simple")) {
                return SIMPLE;
            }
            if (option.equals("byfile")) {
                return BY_FILE;
            }
            if (option.equals("bytodo")) {
                return BY_TODO;
            }
            return DEFAULT_COMPILE_POLICY;
        }
    }
}

