/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.FBAppConf;
import com.google.code.facebookapi.FBAppConfBean;
import com.google.code.facebookapi.FBWebRequest;
import com.google.code.facebookapi.FbWebHelper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;

public class FBWebFilter
implements Filter {
    private FBAppConf appConf;
    private boolean ignoreCookies;

    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.appConf == null) {
            String appId = filterConfig.getInitParameter("appId");
            String apiKey = filterConfig.getInitParameter("apiKey");
            String secret = filterConfig.getInitParameter("secret");
            this.appConf = new FBAppConfBean(appId, apiKey, secret);
        }
        this.ignoreCookies = BooleanUtils.toBoolean((String)filterConfig.getInitParameter("ignoreCookies"));
        this.init();
    }

    public void init(FBAppConf appConf, boolean noCookies) {
        this.appConf = appConf;
        this.ignoreCookies = noCookies;
        this.init();
    }

    public void init() {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void doFilter(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
        String rkey = "fbreq";
        FBWebRequest request = FbWebHelper.attainFBWebRequest(this.appConf, this.ignoreCookies, httpRequest);
        httpRequest.setAttribute(rkey, (Object)request);
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    public FBAppConf getAppConf() {
        return this.appConf;
    }

    public void setAppConf(FBAppConf appConf) {
        this.appConf = appConf;
    }

    public boolean isIgnoreCookies() {
        return this.ignoreCookies;
    }

    public void setIgnoreCookies(boolean noCookies) {
        this.ignoreCookies = noCookies;
    }
}

