/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import java.nio.file.Path;

public class HelpfulSuggestions {
    private final String messagePrefix;
    private final String clearCacheCommand;
    private final String toImageConfiguration;
    private final String buildConfigurationFilename;
    private final String toImageFlag;

    public static String forToNotConfigured(String messagePrefix, String parameter, String buildConfigFilename, String command) {
        return HelpfulSuggestions.suggest(messagePrefix, "add a " + parameter + " configuration parameter to your " + buildConfigFilename + " or set the parameter via the commandline (e.g. '" + command + "').");
    }

    public static String forDockerNotInstalled(String messagePrefix) {
        return HelpfulSuggestions.suggest(messagePrefix, "make sure Docker is installed and you have correct privileges to run it");
    }

    public static String forMainClassNotFound(String messagePrefix, String pluginName) {
        return HelpfulSuggestions.suggest(messagePrefix, "add a `mainClass` configuration to " + pluginName);
    }

    public static String forIncompatibleBaseImageJavaVersionForGradle(int baseImageMajorJavaVersion, int projectMajorJavaVersion) {
        return HelpfulSuggestions.forIncompatibleBaseImageJavaVersion(baseImageMajorJavaVersion, projectMajorJavaVersion, "using the 'jib.from.image' parameter, or set targetCompatibility = " + baseImageMajorJavaVersion + " or below");
    }

    public static String forIncompatibleBaseImageJavaVersionForMaven(int baseImageMajorJavaVersion, int projectMajorJavaVersion) {
        return HelpfulSuggestions.forIncompatibleBaseImageJavaVersion(baseImageMajorJavaVersion, projectMajorJavaVersion, "using the '<from><image>' parameter, or set maven-compiler-plugin's '<target>' or '<release>' version to " + baseImageMajorJavaVersion + " or below");
    }

    public static String forInvalidImageReference(String reference) {
        return HelpfulSuggestions.suggest("Invalid image reference " + reference, "check that the reference is formatted correctly according to https://docs.docker.com/engine/reference/commandline/tag/#extended-description\nFor example, slash-separated name components cannot have uppercase letters");
    }

    public static String suggest(String messagePrefix, String suggestion) {
        return messagePrefix + ", perhaps you should " + suggestion;
    }

    private static String forIncompatibleBaseImageJavaVersion(int baseImageMajorJavaVersion, int projectMajorJavaVersion, String parameterInstructions) {
        return HelpfulSuggestions.suggest("Your project is using Java " + projectMajorJavaVersion + " but the base image is for Java " + baseImageMajorJavaVersion, "configure a Java " + projectMajorJavaVersion + "-compatible base image " + parameterInstructions + " in your build configuration");
    }

    public HelpfulSuggestions(String messagePrefix, String clearCacheCommand, String toImageConfiguration, String toImageFlag, String buildConfigurationFilename) {
        this.messagePrefix = messagePrefix;
        this.clearCacheCommand = clearCacheCommand;
        this.toImageConfiguration = toImageConfiguration;
        this.buildConfigurationFilename = buildConfigurationFilename;
        this.toImageFlag = toImageFlag;
    }

    public String forHttpHostConnect() {
        return this.suggest("make sure your Internet is up and that the registry you are pushing to exists");
    }

    public String forUnknownHost() {
        return this.suggest("make sure that the registry you configured exists/is spelled properly");
    }

    public String forCacheNeedsClean() {
        return this.suggest("run '" + this.clearCacheCommand + "' to clear your build cache");
    }

    public String forCacheDirectoryNotOwned(Path cacheDirectory) {
        return this.suggest("check that '" + cacheDirectory + "' is not used by another application or set the `jib.useOnlyProjectCache` system property");
    }

    public String forHttpStatusCodeForbidden(String imageReference) {
        return this.suggest("make sure you have permissions for " + imageReference + " and set correct credentials. See https://github.com/GoogleContainerTools/jib/blob/master/docs/faq.md#what-should-i-do-when-the-registry-responds-with-forbidden-or-denied for help");
    }

    public String forNoCredentialsDefined(String imageReference) {
        return this.suggest("make sure your credentials for '" + imageReference + "' are set up correctly. See https://github.com/GoogleContainerTools/jib/blob/master/docs/faq.md#what-should-i-do-when-the-registry-responds-with-unauthorized for help");
    }

    public String forCredentialsNotSent() {
        return this.suggest("use a registry that supports HTTPS so credentials can be sent safely, or set the 'sendCredentialsOverHttp' system property to true");
    }

    public String forInsecureRegistry() {
        return this.suggest("use a registry that supports HTTPS or set the configuration parameter 'allowInsecureRegistries'");
    }

    public String forGeneratedTag(String projectName, String projectVersion) {
        return "Tagging image with generated image reference " + projectName + ":" + projectVersion + ". If you'd like to specify a different tag, you can set the " + this.toImageConfiguration + " parameter in your " + this.buildConfigurationFilename + ", or use the " + this.toImageFlag + "=<MY IMAGE> commandline flag.";
    }

    public String none() {
        return this.messagePrefix;
    }

    public String suggest(String suggestion) {
        return HelpfulSuggestions.suggest(this.messagePrefix, suggestion);
    }
}

