/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlException;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.IndexesXml;
import com.google.apphosting.utils.config.YamlUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;

public class IndexYamlReader {
    public static final String INDEX_DEFINITIONS_TAG = "!!python/object:google.appengine.datastore.datastore_index.IndexDefinitions";
    public static final String INDEX_TAG = "!!python/object:google.appengine.datastore.datastore_index.Index";
    public static final String PROPERTY_TAG = "!!python/object:google.appengine.datastore.datastore_index.Property";

    public static IndexesXml parse(Reader yaml, IndexesXml xml) {
        List<IndexesXml> list;
        try {
            list = IndexYamlReader.parseMultiple(yaml, xml);
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage(), ex);
        }
        if (0 == list.size()) {
            throw new AppEngineConfigException("Empty index configuration.");
        }
        if (list.size() > 1) {
            throw new AppEngineConfigException("yaml unexepectedly contains more than one document: " + list.size());
        }
        return list.get(0);
    }

    public static IndexesXml parse(String yaml) {
        return IndexYamlReader.parse(new StringReader(IndexYamlReader.clean(yaml)), null);
    }

    public static List<IndexesXml> parseMultiple(String yaml) {
        try {
            return IndexYamlReader.parseMultiple(new StringReader(IndexYamlReader.clean(yaml)), null);
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage(), ex);
        }
    }

    private static String clean(String yaml) {
        return yaml.replaceAll(INDEX_DEFINITIONS_TAG, "").replaceAll(INDEX_TAG, "").replaceAll(PROPERTY_TAG, "").trim();
    }

    private static List<IndexesXml> parseMultiple(Reader yaml, IndexesXml xml) throws YamlException {
        IndexYaml indexYaml;
        YamlReader reader = new YamlReader(yaml);
        reader.getConfig().setPropertyElementType(IndexYaml.class, "indexes", IndexYaml.Index.class);
        reader.getConfig().setPropertyElementType(IndexYaml.Index.class, "properties", IndexYaml.Property.class);
        LinkedList<IndexesXml> list = new LinkedList<IndexesXml>();
        while (null != (indexYaml = reader.read(IndexYaml.class))) {
            list.add(indexYaml.toXml(xml));
        }
        return list;
    }

    public static class IndexYaml {
        private List<Index> indexes;

        public List<Index> getIndexes() {
            return this.indexes;
        }

        public void setIndexes(List<Index> indexes) {
            this.indexes = indexes;
        }

        public IndexesXml toXml(IndexesXml xml) {
            if (this.indexes == null) {
                throw new AppEngineConfigException("Empty index configuration.");
            }
            if (xml == null) {
                xml = new IndexesXml();
            }
            for (Index yamlIndex : this.indexes) {
                if (yamlIndex.kind == null) {
                    throw new AppEngineConfigException("Index missing required element 'kind'");
                }
                IndexesXml.Index xmlIndex = xml.addNewIndex(yamlIndex.kind, yamlIndex.ancestor);
                if (yamlIndex.properties == null) continue;
                for (Property property : yamlIndex.properties) {
                    if (property.name == null) {
                        throw new AppEngineConfigException("Property is missing required element 'name'.");
                    }
                    xmlIndex.addNewProperty(property.name, property.isAscending());
                }
            }
            return xml;
        }

        public static class Property {
            public String name;
            private String direction = "asc";

            public void setDirection(String direction) {
                if (!"desc".equals(direction) && !"asc".equals(direction)) {
                    throw new AppEngineConfigException("Invalid direction '" + direction + "': expected 'asc' or 'desc'.");
                }
                this.direction = direction;
            }

            public String getDirection() {
                return this.direction;
            }

            public boolean isAscending() {
                return "asc".equals(this.direction);
            }
        }

        public static class Index {
            public String kind;
            protected boolean ancestor;
            public List<Property> properties;

            public void setAncestor(String ancestor) {
                this.ancestor = YamlUtils.parseBoolean(ancestor);
            }

            public String getAncestor() {
                return "" + this.ancestor;
            }
        }
    }
}

