/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.enhancer;

import com.google.appengine.tools.info.SdkInfo;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EnhancerLoader
extends URLClassLoader {
    @Deprecated
    public EnhancerLoader(Set<URL> enhanceTargets) {
        this(enhanceTargets, "v1");
    }

    public EnhancerLoader(Set<URL> enhanceTargets, String datanucleusVersion) {
        super(EnhancerLoader.getClassPath(enhanceTargets, datanucleusVersion), (ClassLoader)null);
    }

    private static URL[] getClassPath(Set<URL> enhanceTargets, String datanucleusVersion) {
        List<URL> datanucleusToolLibs = SdkInfo.getOptionalToolsLib("datanucleus").getURLsForVersion(datanucleusVersion);
        Set<URL> newTargets = EnhancerLoader.removeOrmLibs(enhanceTargets, datanucleusToolLibs);
        HashSet<URL> libs = new HashSet<URL>(SdkInfo.getSharedLibs());
        libs.addAll(new HashSet<URL>(datanucleusToolLibs));
        libs.addAll(newTargets);
        URL[] urls = new URL[libs.size()];
        return libs.toArray(urls);
    }

    private static Set<URL> removeOrmLibs(Set<URL> enhanceTargets, List<URL> ormLibs) {
        if (enhanceTargets == null) {
            throw new NullPointerException("enhanceTargets cannot be null");
        }
        if (ormLibs == null) {
            throw new NullPointerException("ormLibs cannot be null");
        }
        HashSet<URL> newTargets = new HashSet<URL>();
        block0: for (URL url : enhanceTargets) {
            String userFileName = EnhancerLoader.getFileName(url);
            for (URL ormUrl : ormLibs) {
                if (!userFileName.equals(EnhancerLoader.getFileName(ormUrl))) continue;
                continue block0;
            }
            newTargets.add(url);
        }
        return newTargets;
    }

    private static String getFileName(URL url) {
        String path = url.getPath();
        int trailingSlash = path.lastIndexOf(47);
        return path.substring(trailingSlash + 1);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("org.apache.log4j.")) {
            throw new ClassNotFoundException(name);
        }
        return super.loadClass(name, resolve);
    }
}

