/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time;

import com.google.appengine.repackaged.org.joda.time.ReadableDuration;
import com.google.appengine.repackaged.org.joda.time.ReadableInstant;
import com.google.appengine.repackaged.org.joda.time.Seconds;
import com.google.appengine.repackaged.org.joda.time.base.BaseDuration;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import java.io.Serializable;

public final class Duration
extends BaseDuration
implements ReadableDuration,
Serializable {
    public static final Duration ZERO = new Duration(0L);
    private static final long serialVersionUID = 2471658376918L;

    public static Duration standardDays(long l) {
        if (l == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(l, 86400000));
    }

    public static Duration standardHours(long l) {
        if (l == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(l, 3600000));
    }

    public static Duration standardMinutes(long l) {
        if (l == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(l, 60000));
    }

    public static Duration standardSeconds(long l) {
        if (l == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(l, 1000));
    }

    public Duration(long l) {
        super(l);
    }

    public Duration(long l, long l2) {
        super(l, l2);
    }

    public Duration(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        super(readableInstant, readableInstant2);
    }

    public Duration(Object object) {
        super(object);
    }

    public long getStandardSeconds() {
        return this.getMillis() / 1000L;
    }

    public Duration toDuration() {
        return this;
    }

    public Seconds toStandardSeconds() {
        long l = this.getStandardSeconds();
        return Seconds.seconds(FieldUtils.safeToInt(l));
    }

    public Duration withMillis(long l) {
        if (l == this.getMillis()) {
            return this;
        }
        return new Duration(l);
    }

    public Duration withDurationAdded(long l, int n) {
        if (l == 0L || n == 0) {
            return this;
        }
        long l2 = FieldUtils.safeMultiply(l, n);
        long l3 = FieldUtils.safeAdd(this.getMillis(), l2);
        return new Duration(l3);
    }

    public Duration withDurationAdded(ReadableDuration readableDuration, int n) {
        if (readableDuration == null || n == 0) {
            return this;
        }
        return this.withDurationAdded(readableDuration.getMillis(), n);
    }

    public Duration plus(long l) {
        return this.withDurationAdded(l, 1);
    }

    public Duration plus(ReadableDuration readableDuration) {
        if (readableDuration == null) {
            return this;
        }
        return this.withDurationAdded(readableDuration.getMillis(), 1);
    }

    public Duration minus(long l) {
        return this.withDurationAdded(l, -1);
    }

    public Duration minus(ReadableDuration readableDuration) {
        if (readableDuration == null) {
            return this;
        }
        return this.withDurationAdded(readableDuration.getMillis(), -1);
    }
}

