/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.io.protocol.BaseMessageVisitor;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import java.util.ArrayDeque;
import java.util.Deque;

public class MissingFieldVisitor
extends BaseMessageVisitor {
    private String missingFieldName = null;
    private final Deque<String> stack = new ArrayDeque<String>();
    private static final Joiner FIELD_JOINER = Joiner.on('/');

    public String getMissingFieldName() {
        return this.missingFieldName;
    }

    public boolean shouldVisitField(ProtocolType.FieldType fieldType, int count) {
        if (this.missingFieldName != null) {
            return false;
        }
        switch (fieldType.getPresence()) {
            case REQUIRED: {
                if (count == 0) {
                    this.stack.push(fieldType.getName());
                    this.missingFieldName = FIELD_JOINER.join(ImmutableList.copyOf(this.stack.descendingIterator()));
                    this.stack.pop();
                    return false;
                }
                return true;
            }
            case REPEATED: 
            case OPTIONAL: {
                return count > 0;
            }
        }
        throw new IllegalArgumentException("invalid presence on field: " + (Object)((Object)fieldType.getPresence()));
    }

    public void visitGroup(ProtocolType.FieldType fieldType, int index, ProtocolMessage value) {
        this.addHierarchy(fieldType, index);
        ProtocolType.visit(value, this);
        this.removeHierarchy();
    }

    public void visitForeign(ProtocolType.FieldType fieldType, int index, ProtocolMessage value) {
        this.addHierarchy(fieldType, index);
        ProtocolType.visit(value, this);
        this.removeHierarchy();
    }

    private void addHierarchy(ProtocolType.FieldType fieldType, int index) {
        String name = fieldType.getName();
        if (fieldType.getPresence() == ProtocolType.Presence.REPEATED) {
            name = name + "[" + index + "]";
        }
        this.stack.push(name);
    }

    private void removeHierarchy() {
        this.stack.pop();
    }
}

