/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.net.sourceforge.yamlbeans;

import com.google.appengine.repackaged.net.sourceforge.yamlbeans.Beans;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.DeferredConstruction;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlConfig;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlException;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.parser.AliasEvent;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.parser.CollectionStartEvent;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.parser.Event;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.parser.EventType;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.parser.Parser;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.parser.ScalarEvent;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.scalar.ScalarSerializer;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.tokenizer.Tokenizer;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlReader {
    private final YamlConfig config;
    private Parser parser;
    private final Map<String, Object> anchors = new HashMap<String, Object>();

    public YamlReader(Reader reader) {
        this(reader, new YamlConfig());
    }

    public YamlReader(Reader reader, YamlConfig yamlConfig) {
        this.config = yamlConfig;
        this.parser = new Parser(reader, yamlConfig.readConfig.defaultVersion);
    }

    public YamlReader(String string) {
        this(new StringReader(string));
    }

    public YamlReader(String string, YamlConfig yamlConfig) {
        this(new StringReader(string), yamlConfig);
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    public void close() throws IOException {
        this.parser.close();
        this.anchors.clear();
    }

    public Object read() throws YamlException {
        return this.read(null);
    }

    public <T> T read(Class<T> clazz) throws YamlException {
        return this.read(clazz, null);
    }

    public <T> T read(Class<T> clazz, Class clazz2) throws YamlException {
        try {
            Event event;
            do {
                if ((event = this.parser.getNextEvent()) == null) {
                    return null;
                }
                if (event.type != EventType.STREAM_END) continue;
                return null;
            } while (event.type != EventType.DOCUMENT_START);
            return (T)this.readValue(clazz, clazz2);
        }
        catch (Parser.ParserException parserException) {
            throw new YamlException("Error parsing YAML.", parserException);
        }
        catch (Tokenizer.TokenizerException tokenizerException) {
            throw new YamlException("Error tokenizing YAML.", tokenizerException);
        }
    }

    private Object readValue(Class clazz, Class clazz2) throws YamlException, Parser.ParserException, Tokenizer.TokenizerException {
        String string = null;
        String string2 = null;
        Event event = this.parser.peekNextEvent();
        switch (event.type) {
            case ALIAS: {
                this.parser.getNextEvent();
                string2 = ((AliasEvent)event).anchor;
                Object object = this.anchors.get(string2);
                if (object == null) {
                    throw new YamlReaderException("Unknown anchor: " + string2);
                }
                return object;
            }
            case MAPPING_START: 
            case SEQUENCE_START: {
                string = ((CollectionStartEvent)event).tag;
                string2 = ((CollectionStartEvent)event).anchor;
                break;
            }
            case SCALAR: {
                string = ((ScalarEvent)event).tag;
                string2 = ((ScalarEvent)event).anchor;
            }
        }
        if (string != null && (clazz = this.config.tagToClass.get(string)) == null) {
            try {
                clazz = this.config.readConfig.classLoader != null ? Class.forName(string, true, this.config.readConfig.classLoader) : Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new YamlReaderException("Unable to find class specified by tag: " + string);
            }
        }
        Object object = this.readValueInternal(clazz, clazz2);
        if (string2 != null) {
            this.anchors.put(string2, object);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private Object readValueInternal(Class clazz, Class clazz2) throws YamlException, Parser.ParserException, Tokenizer.TokenizerException {
        Object object2;
        if (clazz == null || clazz == Object.class) {
            object2 = this.parser.peekNextEvent();
            switch (((Event)object2).type) {
                case MAPPING_START: {
                    clazz = HashMap.class;
                    break;
                }
                case SCALAR: {
                    clazz = String.class;
                    break;
                }
                case SEQUENCE_START: {
                    clazz = ArrayList.class;
                    break;
                }
                default: {
                    throw new YamlReaderException("Expected scalar, sequence, or mapping but found: " + (Object)((Object)((Event)object2).type));
                }
            }
        }
        if (clazz == String.class) {
            object2 = this.parser.getNextEvent();
            if (((Event)object2).type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for String type but found: " + (Object)((Object)((Event)object2).type));
            }
            return ((ScalarEvent)object2).value;
        }
        if (Beans.isScalar(clazz)) {
            object2 = this.parser.getNextEvent();
            if (((Event)object2).type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for primitive type '" + clazz.getClass() + "' but found: " + (Object)((Object)((Event)object2).type));
            }
            String string = ((ScalarEvent)object2).value;
            try {
                Object invocationTargetException;
                if (clazz == String.class) {
                    invocationTargetException = string;
                } else if (clazz == Integer.TYPE || clazz == Integer.class) {
                    invocationTargetException = Integer.valueOf(string);
                } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                    invocationTargetException = Boolean.valueOf(string);
                } else if (clazz == Float.TYPE || clazz == Float.class) {
                    invocationTargetException = Float.valueOf(string);
                } else if (clazz == Double.TYPE || clazz == Double.class) {
                    invocationTargetException = Double.valueOf(string);
                } else if (clazz == Long.TYPE || clazz == Long.class) {
                    invocationTargetException = Long.valueOf(string);
                } else if (clazz == Short.TYPE || clazz == Short.class) {
                    invocationTargetException = Short.valueOf(string);
                } else if (clazz == Character.TYPE || clazz == Character.class) {
                    invocationTargetException = Character.valueOf(string.charAt(0));
                } else if (clazz == Byte.TYPE || clazz == Byte.class) {
                    invocationTargetException = Byte.valueOf(string);
                } else {
                    throw new YamlException("Unknown field type.");
                }
                return invocationTargetException;
            }
            catch (Exception string2) {
                throw new YamlReaderException("Unable to convert value to required type \"" + clazz + "\": " + string, string2);
            }
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            object2 = this.parser.getNextEvent();
            if (((Event)object2).type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for enum type but found: " + (Object)((Object)((Event)object2).type));
            }
            string = ((ScalarEvent)object2).value;
            if (string.length() == 0) {
                return null;
            }
            try {
                return Enum.valueOf(clazz, string);
            }
            catch (Exception invocationTargetException) {
                throw new YamlReaderException("Unable to find enum value '" + string + "' for enum class: " + clazz.getName());
            }
        }
        for (Map.Entry object4 : this.config.scalarSerializers.entrySet()) {
            if (!((Class)object4.getKey()).isAssignableFrom(clazz)) continue;
            ScalarSerializer invocationTargetException = (ScalarSerializer)object4.getValue();
            Event event = this.parser.getNextEvent();
            if (event.type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for type '" + clazz + "' to be deserialized by scalar serializer '" + invocationTargetException.getClass().getName() + "' but found: " + (Object)((Object)event.type));
            }
            return invocationTargetException.read(((ScalarEvent)event).value);
        }
        object2 = this.parser.peekNextEvent();
        switch (((Event)object2).type) {
            case MAPPING_START: {
                Object object;
                object2 = this.parser.getNextEvent();
                try {
                    object = Beans.createObject(clazz, this.config);
                }
                catch (InvocationTargetException object5) {
                    throw new YamlReaderException("Error creating object.", object5);
                }
                while (true) {
                    object2 = this.parser.getNextEvent();
                    if (((Event)object2).type == EventType.MAPPING_END) break;
                    if (((Event)object2).type != EventType.SCALAR) {
                        throw new YamlReaderException("Expected scalar for map key but found: " + (Object)((Object)((Event)object2).type));
                    }
                    String string = ((ScalarEvent)object2).value;
                    if (object instanceof Map) {
                        ((Map)object).put(string, this.readValue(clazz2, null));
                        continue;
                    }
                    try {
                        Beans.Property property = Beans.getProperty(clazz, string);
                        if (property == null) {
                            throw new YamlReaderException("Unable to find property '" + string + "' on class: " + clazz.getName());
                        }
                        Class clazz3 = this.config.propertyToElementType.get(property);
                        property.set(object, this.readValue(property.getType(), clazz3));
                    }
                    catch (Exception exception) {
                        if (exception instanceof YamlReaderException) {
                            throw (YamlReaderException)exception;
                        }
                        throw new YamlReaderException("Error setting property '" + string + "' on class: " + clazz.getName(), exception);
                    }
                }
                if (object instanceof DeferredConstruction) {
                    try {
                        return ((DeferredConstruction)object).construct();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new YamlReaderException("Error creating object.", invocationTargetException);
                    }
                }
                return object;
            }
            case SEQUENCE_START: {
                void var4_10;
                object2 = this.parser.getNextEvent();
                if (Collection.class.isAssignableFrom(clazz)) {
                    try {
                        Collection collection = (Collection)Beans.createObject(clazz, this.config);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new YamlReaderException("Error creating object.", invocationTargetException);
                    }
                } else if (clazz.isArray()) {
                    ArrayList arrayList = new ArrayList();
                    clazz2 = clazz.getComponentType();
                } else {
                    throw new YamlReaderException("A sequence is not a valid value for the type: " + clazz.getName());
                }
                while (true) {
                    object2 = this.parser.peekNextEvent();
                    if (((Event)object2).type == EventType.SEQUENCE_END) break;
                    var4_10.add(this.readValue(clazz2, null));
                }
                this.parser.getNextEvent();
                if (!clazz.isArray()) {
                    return var4_10;
                }
                Object object = Array.newInstance(clazz2, var4_10.size());
                int n = 0;
                for (Object e : var4_10) {
                    Array.set(object, n++, e);
                }
                return object;
            }
            case SCALAR: {
                if (((ScalarEvent)object2).value.length() != 0) break;
                object2 = this.parser.getNextEvent();
                return null;
            }
        }
        throw new YamlReaderException("Expected data for a " + clazz.getName() + " field but found: " + (Object)((Object)((Event)object2).type));
    }

    public static void main(String[] stringArray) throws Exception {
        YamlReader yamlReader = new YamlReader(new FileReader("test/test.yml"));
        System.out.println(yamlReader.read());
    }

    public class YamlReaderException
    extends YamlException {
        public YamlReaderException(String string, Throwable throwable) {
            super("Line " + YamlReader.this.parser.getLineNumber() + ", column " + YamlReader.this.parser.getColumn() + ": " + string, throwable);
        }

        public YamlReaderException(String string) {
            this(string, null);
        }
    }
}

