/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.Range;
import com.google.appengine.repackaged.com.google.common.base.RangeClosed;
import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtCompatible;
import java.io.Serializable;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
@GwtCompatible
public final class Ranges {
    private Ranges() {
    }

    @GwtCompatible(serializable=true)
    public static <V extends Comparable<? super V>> Range<V> newRange(V min, V max) {
        if (max.compareTo(min) > -1) {
            return new RangeClosed<V>(min, max);
        }
        return Ranges.emptyRange();
    }

    @GwtCompatible(serializable=true)
    public static <V extends Comparable<? super V>> Range<V> emptyRange() {
        return EmptyRange.INSTANCE;
    }

    public static <V extends Comparable<? super V>> Range<V> intersect(Range<V> aRange, Range<V> ... moreRanges) {
        Range<V> result = aRange;
        for (Range<V> range : moreRanges) {
            result = result.intersection(range);
        }
        return result;
    }

    public static <V extends Comparable<? super V>> Range<V> enclose(Range<V> aRange, Range<V> ... moreRanges) {
        Range<V> result = aRange;
        for (Range<V> range : moreRanges) {
            result = result.enclosure(range);
        }
        return result;
    }

    @GwtCompatible(serializable=true)
    public static <V extends Comparable<? super V>> Range<V> rangeOf(V ... values) {
        Object min = null;
        Object max = null;
        boolean isEmpty = true;
        for (V value : values) {
            if (value == null) continue;
            if (isEmpty) {
                isEmpty = false;
                min = value;
                max = value;
                continue;
            }
            if (value.compareTo(min) < 0) {
                min = value;
            }
            if (value.compareTo(max) <= 0) continue;
            max = value;
        }
        return isEmpty ? Ranges.emptyRange() : Ranges.newRange(min, max);
    }

    @GwtCompatible(serializable=true)
    public static Range<Integer> encloseInts(int ... values) {
        if (values.length == 0) {
            return Ranges.emptyRange();
        }
        int min = values[0];
        int max = values[0];
        for (int value : values) {
            if (min > value) {
                min = value;
            }
            if (max >= value) continue;
            max = value;
        }
        return Ranges.newRange(min, max);
    }

    @GwtCompatible(serializable=true)
    public static Range<Long> encloseLongs(long ... values) {
        if (values.length == 0) {
            return Ranges.emptyRange();
        }
        long min = values[0];
        long max = values[0];
        for (long value : values) {
            if (min > value) {
                min = value;
            }
            if (max >= value) continue;
            max = value;
        }
        return Ranges.newRange(min, max);
    }

    @GwtCompatible(serializable=true)
    public static Range<Double> encloseDoubles(double ... values) {
        if (values.length == 0) {
            return Ranges.emptyRange();
        }
        double min = values[0];
        double max = values[0];
        for (double value : values) {
            if (min > value) {
                min = value;
            }
            if (!(max < value)) continue;
            max = value;
        }
        return Ranges.newRange(min, max);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EmptyRange<V extends Comparable<? super V>>
    implements Range<V>,
    Serializable {
        private static final EmptyRange<Comparable<Object>> INSTANCE = new EmptyRange();
        private static final long serialVersionUID = 0L;

        private EmptyRange() {
        }

        @Override
        public boolean contains(V value) {
            return false;
        }

        @Override
        public Range<V> enclose(V value) {
            return Ranges.newRange(value, value);
        }

        @Override
        public Range<V> enclosure(Range<V> range) {
            return range;
        }

        @Override
        public V max() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Range && ((Range)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public Range<V> intersection(Range<V> range) {
            return this;
        }

        @Override
        public boolean intersects(Range<V> range) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public V min() {
            throw new NoSuchElementException();
        }

        public String toString() {
            return "[Empty Range]";
        }
    }
}

