/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.convert;

import com.google.appengine.repackaged.org.joda.time.convert.Converter;

class ConverterSet {
    private final Converter[] iConverters;
    private Entry[] iSelectEntries;

    ConverterSet(Converter[] converters) {
        this.iConverters = converters;
        this.iSelectEntries = new Entry[16];
    }

    Converter select(Class<?> type) throws IllegalStateException {
        Entry e;
        int index;
        Entry[] entries = this.iSelectEntries;
        int length = entries.length;
        int n = index = type == null ? 0 : type.hashCode() & length - 1;
        while ((e = entries[index]) != null) {
            if (e.iType == type) {
                return e.iConverter;
            }
            if (++index < length) continue;
            index = 0;
        }
        Converter converter = ConverterSet.selectSlow(this, type);
        e = new Entry(type, converter);
        entries = (Entry[])entries.clone();
        entries[index] = e;
        for (int i = 0; i < length; ++i) {
            if (entries[i] != null) continue;
            this.iSelectEntries = entries;
            return converter;
        }
        int newLength = length << 1;
        Entry[] newEntries = new Entry[newLength];
        for (int i = 0; i < length; ++i) {
            e = entries[i];
            type = e.iType;
            int n2 = index = type == null ? 0 : type.hashCode() & newLength - 1;
            while (newEntries[index] != null) {
                if (++index < newLength) continue;
                index = 0;
            }
            newEntries[index] = e;
        }
        this.iSelectEntries = newEntries;
        return converter;
    }

    int size() {
        return this.iConverters.length;
    }

    void copyInto(Converter[] converters) {
        System.arraycopy(this.iConverters, 0, converters, 0, this.iConverters.length);
    }

    ConverterSet add(Converter converter, Converter[] removed) {
        Converter[] converters = this.iConverters;
        int length = converters.length;
        for (int i = 0; i < length; ++i) {
            Converter existing = converters[i];
            if (converter.equals(existing)) {
                if (removed != null) {
                    removed[0] = null;
                }
                return this;
            }
            if (converter.getSupportedType() != existing.getSupportedType()) continue;
            Converter[] copy = new Converter[length];
            for (int j = 0; j < length; ++j) {
                copy[j] = j != i ? converters[j] : converter;
            }
            if (removed != null) {
                removed[0] = existing;
            }
            return new ConverterSet(copy);
        }
        Converter[] copy = new Converter[length + 1];
        System.arraycopy(converters, 0, copy, 0, length);
        copy[length] = converter;
        if (removed != null) {
            removed[0] = null;
        }
        return new ConverterSet(copy);
    }

    ConverterSet remove(Converter converter, Converter[] removed) {
        Converter[] converters = this.iConverters;
        int length = converters.length;
        for (int i = 0; i < length; ++i) {
            if (!converter.equals(converters[i])) continue;
            return this.remove(i, removed);
        }
        if (removed != null) {
            removed[0] = null;
        }
        return this;
    }

    ConverterSet remove(int index, Converter[] removed) {
        Converter[] converters = this.iConverters;
        int length = converters.length;
        if (index >= length) {
            throw new IndexOutOfBoundsException();
        }
        if (removed != null) {
            removed[0] = converters[index];
        }
        Converter[] copy = new Converter[length - 1];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            if (i == index) continue;
            copy[j++] = converters[i];
        }
        return new ConverterSet(copy);
    }

    private static Converter selectSlow(ConverterSet set, Class<?> type) {
        Class<?> supportedType;
        Converter converter;
        int length;
        Converter[] converters = set.iConverters;
        int i = length = converters.length;
        while (--i >= 0) {
            converter = converters[i];
            supportedType = converter.getSupportedType();
            if (supportedType == type) {
                return converter;
            }
            if (supportedType != null && (type == null || supportedType.isAssignableFrom(type))) continue;
            set = set.remove(i, null);
            converters = set.iConverters;
            length = converters.length;
        }
        if (type == null || length == 0) {
            return null;
        }
        if (length == 1) {
            return converters[0];
        }
        i = length;
        while (--i >= 0) {
            converter = converters[i];
            supportedType = converter.getSupportedType();
            int j = length;
            while (--j >= 0) {
                if (j == i || !converters[j].getSupportedType().isAssignableFrom(supportedType)) continue;
                set = set.remove(j, null);
                converters = set.iConverters;
                length = converters.length;
                i = length - 1;
            }
        }
        if (length == 1) {
            return converters[0];
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Unable to find best converter for type \"");
        msg.append(type.getName());
        msg.append("\" from remaining set: ");
        for (int i2 = 0; i2 < length; ++i2) {
            converter = converters[i2];
            Class<?> supportedType2 = converter.getSupportedType();
            msg.append(converter.getClass().getName());
            msg.append('[');
            msg.append(supportedType2 == null ? null : supportedType2.getName());
            msg.append("], ");
        }
        throw new IllegalStateException(msg.toString());
    }

    static class Entry {
        final Class<?> iType;
        final Converter iConverter;

        Entry(Class<?> type, Converter converter) {
            this.iType = type;
            this.iConverter = converter;
        }
    }
}

