/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib.descriptor_pool;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.io.protocol.MutableBridge;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import java.util.HashMap;
import javax.annotation.Nullable;

public final class DescriptorPool {
    private final HashMap<String, Descriptors.FileDescriptor> fileNameToFileDescriptor = Maps.newHashMap();
    private final HashMap<String, Descriptors.Descriptor> typeNameToDescriptor = Maps.newHashMap();
    private final HashMap<String, Descriptors.EnumDescriptor> enumNameToDescriptor = Maps.newHashMap();
    private final HashMap<String, HashMap<Integer, Descriptors.FieldDescriptor>> typeNameToExtensions = Maps.newHashMap();
    private final HashMap<String, Descriptors.FieldDescriptor> fieldNameToExtensions = Maps.newHashMap();

    @Nullable
    public Descriptors.Descriptor getDescriptorForTypeName(String typeName) {
        return this.typeNameToDescriptor.get(typeName);
    }

    @Nullable
    public Descriptors.FileDescriptor getFileDescriptorForFileName(String fileName) {
        return this.fileNameToFileDescriptor.get(fileName);
    }

    @Nullable
    public Descriptors.FileDescriptor getFileDescriptorForSymbol(String symbol) {
        Descriptors.Descriptor typeDesc = this.typeNameToDescriptor.get(symbol);
        if (typeDesc != null) {
            return typeDesc.getFile();
        }
        Descriptors.EnumDescriptor enumDesc = this.enumNameToDescriptor.get(symbol);
        if (enumDesc != null) {
            return enumDesc.getFile();
        }
        Descriptors.FieldDescriptor fieldDesc = this.fieldNameToExtensions.get(symbol);
        if (fieldDesc != null) {
            return fieldDesc.getFile();
        }
        fieldDesc = this.findField(symbol);
        if (fieldDesc != null) {
            return fieldDesc.getFile();
        }
        return null;
    }

    @Nullable
    private Descriptors.FieldDescriptor findField(String fullFieldName) {
        int index = fullFieldName.lastIndexOf(46);
        if (index != -1) {
            String fieldName = fullFieldName.substring(index + 1);
            String messageName = fullFieldName.substring(0, index);
            Descriptors.Descriptor messageDesc = this.typeNameToDescriptor.get(messageName);
            if (messageDesc != null) {
                return messageDesc.findFieldByName(fieldName);
            }
        }
        return null;
    }

    @Nullable
    public Descriptors.FieldDescriptor getExtension(String containingName, int extensionNumber) {
        HashMap<Integer, Descriptors.FieldDescriptor> fieldIdToExtension = this.typeNameToExtensions.get(containingName);
        return fieldIdToExtension == null ? null : fieldIdToExtension.get(extensionNumber);
    }

    @Nullable
    public ImmutableList<Descriptors.FieldDescriptor> getAllExtansionsForTypeName(String typeName) {
        HashMap<Integer, Descriptors.FieldDescriptor> fieldIdToExtension = this.typeNameToExtensions.get(typeName);
        return fieldIdToExtension == null ? null : ImmutableList.copyOf(fieldIdToExtension.values());
    }

    public void populateFromMessageType(Message message) {
        Descriptors.Descriptor desc = message.getDescriptorForType();
        this.addFile(desc.getFile());
    }

    public void populateFromFileDescriptor(Descriptors.FileDescriptor file) {
        this.addFile(file);
    }

    private void addFile(Descriptors.FileDescriptor file) {
        if (this.fileNameToFileDescriptor.put(file.getName(), file) != null) {
            return;
        }
        for (Descriptors.FileDescriptor dependency : file.getDependencies()) {
            this.addFile(dependency);
        }
        for (Descriptors.Descriptor type : file.getMessageTypes()) {
            this.addMessageType(type);
        }
        for (Descriptors.FieldDescriptor extension : file.getExtensions()) {
            this.addExtension(extension);
        }
        for (Descriptors.EnumDescriptor enumDesc : file.getEnumTypes()) {
            this.enumNameToDescriptor.put(enumDesc.getFullName(), enumDesc);
        }
    }

    private void addExtension(Descriptors.FieldDescriptor extension) {
        this.fieldNameToExtensions.put(extension.getFullName(), extension);
        String containingName = extension.getContainingType().getFullName();
        HashMap<Integer, Descriptors.FieldDescriptor> fieldIdToExtension = this.typeNameToExtensions.get(containingName);
        if (fieldIdToExtension == null) {
            fieldIdToExtension = Maps.newHashMap();
            this.typeNameToExtensions.put(containingName, fieldIdToExtension);
        }
        fieldIdToExtension.put(extension.getNumber(), extension);
    }

    private void addMessageType(Descriptors.Descriptor type) {
        if (this.typeNameToDescriptor.put(type.getFullName(), type) != null) {
            return;
        }
        if (type.getContainingType() != null) {
            this.typeNameToDescriptor.put(MutableBridge.DescriptorDowngrader.getProto1Name(type), type);
        }
        for (Descriptors.Descriptor nested : type.getNestedTypes()) {
            this.addMessageType(nested);
        }
        for (Descriptors.FieldDescriptor extension : type.getExtensions()) {
            this.addExtension(extension);
        }
        for (Descriptors.EnumDescriptor enumDesc : type.getEnumTypes()) {
            this.enumNameToDescriptor.put(enumDesc.getFullName(), enumDesc);
        }
    }
}

