/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Strings;

public class IndexChecker {
    public static String checkName(String indexName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(indexName), "Index name null or empty");
        Preconditions.checkArgument(indexName.length() <= 100, "Index name longer than %d characters: %s", 100, indexName);
        Preconditions.checkArgument(IndexChecker.isAsciiVisiblePrintable(indexName), "Index name must be ASCII visible printable: %s", indexName);
        Preconditions.checkArgument(!IndexChecker.isReserved(indexName), "Index name must not start with !: %s", indexName);
        return indexName;
    }

    static boolean isAsciiVisiblePrintable(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) >= '!' && str.charAt(i) <= '~') continue;
            return false;
        }
        return true;
    }

    static boolean isReserved(String str) {
        return str.startsWith("!") || str.length() > 3 && str.startsWith("__") && str.endsWith("__");
    }
}

