/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.mail;

import com.google.appengine.api.mail.MailService;
import com.google.appengine.api.mail.MailServicePb;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;

class MailServiceImpl
implements MailService {
    static final String PACKAGE = "mail";

    MailServiceImpl() {
    }

    @Override
    public void sendToAdmins(MailService.Message message) throws IllegalArgumentException, IOException {
        this.doSend(message, true);
    }

    @Override
    public void send(MailService.Message message) throws IllegalArgumentException, IOException {
        this.doSend(message, false);
    }

    private void doSend(MailService.Message message, boolean toAdmin) throws IllegalArgumentException, IOException {
        MailServicePb.MailMessage msgProto = new MailServicePb.MailMessage();
        if (message.getSender() != null) {
            msgProto.setSender(message.getSender());
        }
        if (message.getTo() != null) {
            for (String to : message.getTo()) {
                msgProto.addTo(to);
            }
        }
        if (message.getCc() != null) {
            for (String cc : message.getCc()) {
                msgProto.addCc(cc);
            }
        }
        if (message.getBcc() != null) {
            for (String bcc : message.getBcc()) {
                msgProto.addBcc(bcc);
            }
        }
        if (message.getReplyTo() != null) {
            msgProto.setReplyTo(message.getReplyTo());
        }
        if (message.getSubject() != null) {
            msgProto.setSubject(message.getSubject());
        }
        if (message.getTextBody() != null) {
            msgProto.setTextBody(message.getTextBody());
        }
        if (message.getHtmlBody() != null) {
            msgProto.setHtmlBody(message.getHtmlBody());
        }
        if (message.getAttachments() != null) {
            for (MailService.Attachment attach : message.getAttachments()) {
                MailServicePb.MailAttachment attachProto = new MailServicePb.MailAttachment();
                attachProto.setFileName(attach.getFileName());
                attachProto.setDataAsBytes(attach.getData());
                if (attach.getContentID() != null) {
                    attachProto.setContentID(attach.getContentID());
                }
                msgProto.addAttachment(attachProto);
            }
        }
        if (message.getHeaders() != null) {
            for (MailService.Header header : message.getHeaders()) {
                MailServicePb.MailHeader headerProto = new MailServicePb.MailHeader();
                headerProto.setName(header.getName());
                headerProto.setValue(header.getValue());
                msgProto.addHeader(headerProto);
            }
        }
        byte[] msgBytes = msgProto.toByteArray();
        try {
            if (toAdmin) {
                ApiProxy.makeSyncCall(PACKAGE, "SendToAdmins", msgBytes);
            } else {
                ApiProxy.makeSyncCall(PACKAGE, "Send", msgBytes);
            }
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (MailServicePb.MailServiceError.ErrorCode.valueOf(ex.getApplicationError())) {
                case BAD_REQUEST: {
                    throw new IllegalArgumentException("Bad Request: " + ex.getErrorDetail());
                }
                case UNAUTHORIZED_SENDER: {
                    throw new IllegalArgumentException("Unauthorized Sender: " + ex.getErrorDetail());
                }
                case INVALID_ATTACHMENT_TYPE: {
                    throw new IllegalArgumentException("Invalid Attachment Type: " + ex.getErrorDetail());
                }
                case INVALID_HEADER_NAME: {
                    throw new IllegalArgumentException("Invalid Header Name: " + ex.getErrorDetail());
                }
            }
            throw new IOException(ex.getErrorDetail());
        }
    }
}

