/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.log;

import com.google.appengine.api.log.AppLogLine;
import com.google.appengine.api.log.LogService;
import com.google.apphosting.api.logservice.LogServicePb;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class RequestLogs
implements Serializable {
    private static final long serialVersionUID = 7380961939323935275L;
    private String appId;
    private String moduleId;
    private String versionId;
    private String requestId;
    private String offset;
    private String ip;
    private String nickname;
    private long startTimeUsec;
    private long endTimeUsec;
    private long latency;
    private long mcycles;
    private String method;
    private String resource;
    private String httpVersion;
    private int status;
    private long responseSize;
    private String referrer;
    private String userAgent;
    private String urlMapEntry;
    private String combined;
    private long apiMcycles;
    private String host;
    private double cost;
    private String taskQueueName;
    private String taskName;
    private boolean wasLoadingRequest;
    private long pendingTime;
    private int replicaIndex;
    private boolean finished;
    private String instanceKey;
    private List<AppLogLine> appLogLines = new ArrayList<AppLogLine>();
    private String appEngineRelease;

    public RequestLogs() {
    }

    protected RequestLogs(LogServicePb.RequestLog requestLog, String offset) {
        this.setAppId(requestLog.getAppId());
        this.setModuleId(requestLog.getModuleId());
        this.setVersionId(requestLog.getVersionId());
        this.setRequestId(requestLog.getRequestId());
        this.setOffset(offset);
        this.setIp(requestLog.getIp());
        this.setNickname(requestLog.getNickname());
        this.setStartTimeUsec(requestLog.getStartTime());
        this.setEndTimeUsec(requestLog.getEndTime());
        this.setLatency(requestLog.getLatency());
        this.setMcycles(requestLog.getMcycles());
        this.setMethod(requestLog.getMethod());
        this.setResource(requestLog.getResource());
        this.setHttpVersion(requestLog.getHttpVersion());
        this.setStatus(requestLog.getStatus());
        this.setResponseSize(requestLog.getResponseSize());
        this.setReferrer(requestLog.getReferrer());
        this.setUserAgent(requestLog.getUserAgent());
        this.setUrlMapEntry(requestLog.getUrlMapEntry());
        this.setCombined(requestLog.getCombined());
        this.setApiMcycles(requestLog.getApiMcycles());
        this.setHost(requestLog.getHost());
        this.setCost(requestLog.getCost());
        this.setTaskQueueName(requestLog.getTaskQueueName());
        this.setTaskName(requestLog.getTaskName());
        this.setWasLoadingRequest(requestLog.isWasLoadingRequest());
        this.setPendingTime(requestLog.getPendingTime());
        this.setReplicaIndex(requestLog.getReplicaIndex());
        this.setFinished(requestLog.isFinished());
        this.setInstanceKey(requestLog.getCloneKey());
        this.setAppEngineRelease(requestLog.getAppEngineRelease());
        List<AppLogLine> appLogLines = this.getAppLogLines();
        for (LogServicePb.LogLine logLine : requestLog.lines()) {
            LogService.LogLevel level = LogService.LogLevel.values()[logLine.getLevel()];
            appLogLines.add(new AppLogLine(logLine.getTime(), level, logLine.getLogMessage()));
        }
    }

    @Deprecated
    public long getApiMcycles() {
        return this.apiMcycles;
    }

    public String getAppId() {
        return this.appId;
    }

    public List<AppLogLine> getAppLogLines() {
        return this.appLogLines;
    }

    public String getCombined() {
        return this.combined;
    }

    public double getCost() {
        return this.cost;
    }

    public long getEndTimeUsec() {
        return this.endTimeUsec;
    }

    public String getHost() {
        return this.host;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public String getInstanceKey() {
        return this.instanceKey;
    }

    public String getIp() {
        return this.ip;
    }

    public long getLatencyUsec() {
        return this.latency;
    }

    public long getMcycles() {
        return this.mcycles;
    }

    public String getMethod() {
        return this.method;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getOffset() {
        return this.offset;
    }

    public long getPendingTimeUsec() {
        return this.pendingTime;
    }

    public String getReferrer() {
        return this.referrer;
    }

    public int getReplicaIndex() {
        return this.replicaIndex;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getResource() {
        return this.resource;
    }

    public long getResponseSize() {
        return this.responseSize;
    }

    public long getStartTimeUsec() {
        return this.startTimeUsec;
    }

    public int getStatus() {
        return this.status;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskQueueName() {
        return this.taskQueueName;
    }

    public String getUrlMapEntry() {
        return this.urlMapEntry;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isLoadingRequest() {
        return this.wasLoadingRequest;
    }

    public String getAppEngineRelease() {
        return this.appEngineRelease;
    }

    public void setApiMcycles(long apiMcycles) {
        this.apiMcycles = apiMcycles;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppLogLines(List<AppLogLine> appLogLines) {
        this.appLogLines = appLogLines;
    }

    public void setCombined(String combined) {
        this.combined = combined;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public void setEndTimeUsec(long endTimeUsec) {
        this.endTimeUsec = endTimeUsec;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public void setInstanceKey(String instanceKey) {
        this.instanceKey = instanceKey;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setLatency(long latency) {
        this.latency = latency;
    }

    public void setMcycles(long mcycles) {
        this.mcycles = mcycles;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public void setPendingTime(long pendingTime) {
        this.pendingTime = pendingTime;
    }

    public void setReferrer(String referrer) {
        this.referrer = referrer;
    }

    public void setReplicaIndex(int replicaIndex) {
        this.replicaIndex = replicaIndex;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setResponseSize(long responseSize) {
        this.responseSize = responseSize;
    }

    public void setStartTimeUsec(long startTimeUsec) {
        this.startTimeUsec = startTimeUsec;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setTaskQueueName(String taskQueueName) {
        this.taskQueueName = taskQueueName;
    }

    public void setUrlMapEntry(String urlMapEntry) {
        this.urlMapEntry = urlMapEntry;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public void setWasLoadingRequest(boolean wasLoadingRequest) {
        this.wasLoadingRequest = wasLoadingRequest;
    }

    public void setAppEngineRelease(String appEngineRelease) {
        this.appEngineRelease = appEngineRelease;
    }

    public String toString() {
        return "RequestLogs{appId='" + this.appId + '\'' + ", moduleId='" + this.moduleId + '\'' + ", versionId='" + this.versionId + '\'' + ", requestId='" + this.requestId + '\'' + ", ip='" + this.ip + '\'' + ", nickname='" + this.nickname + '\'' + ", startTimeUsec=" + this.startTimeUsec + ", endTimeUsec=" + this.endTimeUsec + ", latency=" + this.latency + ", mcycles=" + this.mcycles + ", method='" + this.method + '\'' + ", resource='" + this.resource + '\'' + ", httpVersion='" + this.httpVersion + '\'' + ", status=" + this.status + ", responseSize=" + this.responseSize + ", referrer='" + this.referrer + '\'' + ", userAgent='" + this.userAgent + '\'' + ", urlMapEntry='" + this.urlMapEntry + '\'' + ", combined='" + this.combined + '\'' + ", apiMcycles=" + this.apiMcycles + ", host='" + this.host + '\'' + ", cost=" + this.cost + ", taskQueueName='" + this.taskQueueName + '\'' + ", taskName='" + this.taskName + '\'' + ", wasLoadingRequest=" + this.wasLoadingRequest + ", pendingTime=" + this.pendingTime + ", replicaIndex=" + this.replicaIndex + ", finished=" + this.finished + ", instanceKey='" + this.instanceKey + '\'' + ", appLogLines=" + this.appLogLines + ", appEngineRelease='" + this.appEngineRelease + '\'' + '}';
    }

    public int hashCode() {
        return Objects.hash(this.appId, this.moduleId, this.versionId, this.requestId, this.offset, this.ip, this.nickname, this.startTimeUsec, this.endTimeUsec, this.latency, this.mcycles, this.method, this.resource, this.httpVersion, this.status, this.responseSize, this.referrer, this.userAgent, this.urlMapEntry, this.combined, this.apiMcycles, this.host, this.cost, this.taskQueueName, this.taskName, this.wasLoadingRequest, this.pendingTime, this.replicaIndex, this.finished, this.instanceKey, this.appLogLines, this.appEngineRelease);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RequestLogs other = (RequestLogs)obj;
        return Objects.equals(this.appId, other.appId) && Objects.equals(this.moduleId, other.moduleId) && Objects.equals(this.versionId, other.versionId) && Objects.equals(this.requestId, other.requestId) && Objects.equals(this.offset, other.offset) && Objects.equals(this.ip, other.ip) && Objects.equals(this.nickname, other.nickname) && this.startTimeUsec == other.startTimeUsec && this.endTimeUsec == other.endTimeUsec && this.latency == other.latency && this.mcycles == other.mcycles && Objects.equals(this.method, other.method) && Objects.equals(this.resource, other.resource) && Objects.equals(this.httpVersion, other.httpVersion) && this.status == other.status && this.responseSize == other.responseSize && Objects.equals(this.referrer, other.referrer) && Objects.equals(this.userAgent, other.userAgent) && Objects.equals(this.urlMapEntry, other.urlMapEntry) && Objects.equals(this.combined, other.combined) && this.apiMcycles == other.apiMcycles && Objects.equals(this.host, other.host) && Objects.equals(this.cost, other.cost) && Objects.equals(this.taskQueueName, other.taskQueueName) && Objects.equals(this.taskName, other.taskName) && this.wasLoadingRequest == other.wasLoadingRequest && this.pendingTime == other.pendingTime && this.replicaIndex == other.replicaIndex && this.finished == other.finished && Objects.equals(this.instanceKey, other.instanceKey) && Objects.equals(this.appLogLines, other.appLogLines) && Objects.equals(this.appEngineRelease, other.appEngineRelease);
    }
}

