/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PropertyContainer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class Entity
extends PropertyContainer
implements Cloneable {
    static final long serialVersionUID = -836647825120453511L;
    public static final String KEY_RESERVED_PROPERTY = "__key__";
    public static final String SCATTER_RESERVED_PROPERTY = "__scatter__";
    public static final String VERSION_RESERVED_PROPERTY = "__version__";
    private final Key key;
    final Map<String, Object> propertyMap;

    public Entity(String kind) {
        this(kind, (Key)null);
    }

    public Entity(String kind, Key parent) {
        this(new Key(kind, parent));
    }

    public Entity(String kind, String keyName) {
        this(KeyFactory.createKey(kind, keyName));
    }

    public Entity(String kind, long id) {
        this(KeyFactory.createKey(kind, id));
    }

    public Entity(String kind, String keyName, Key parent) {
        this(KeyFactory.createKey(parent, kind, keyName));
    }

    public Entity(String kind, long id, Key parent) {
        this(KeyFactory.createKey(parent, kind, id));
    }

    public Entity(Key key) {
        this.key = key;
        this.propertyMap = new HashMap<String, Object>();
    }

    public boolean equals(Object object) {
        if (object instanceof Entity) {
            Entity otherEntity = (Entity)object;
            return this.key.equals(otherEntity.key);
        }
        return false;
    }

    public Key getKey() {
        return this.key;
    }

    public String getKind() {
        return this.key.getKind();
    }

    public Key getParent() {
        return this.key.getParent();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("<Entity [");
        builder.append(this.key).append("]:\n");
        this.appendPropertiesTo(builder);
        builder.append(">\n");
        return builder.toString();
    }

    public String getAppId() {
        return this.key.getAppId();
    }

    AppIdNamespace getAppIdNamespace() {
        return this.key.getAppIdNamespace();
    }

    public String getNamespace() {
        return this.key.getNamespace();
    }

    @Override
    public Entity clone() {
        Entity entity = new Entity(this.key);
        entity.setPropertiesFrom(this);
        return entity;
    }

    public void setPropertiesFrom(Entity src) {
        super.setPropertiesFrom(src);
    }

    @Override
    Map<String, Object> getPropertyMap() {
        return this.propertyMap;
    }

    static final class UnindexedValue
    implements Serializable {
        private final Object value;

        UnindexedValue(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object that) {
            if (that instanceof UnindexedValue) {
                UnindexedValue uv = (UnindexedValue)that;
                return this.value == null ? uv.value == null : this.value.equals(uv.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public String toString() {
            return this.value + " (unindexed)";
        }
    }
}

