/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.local;

import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.EstimationProbe;
import io.github.bucket4j.Nothing;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.VerboseResult;
import io.github.bucket4j.local.LocalBucket;
import io.github.bucket4j.local.LockFreeBucket_FinalFields_CacheLinePadding;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

public class LockFreeBucket
extends LockFreeBucket_FinalFields_CacheLinePadding
implements LocalBucket {
    private final AtomicReference<StateWithConfiguration> stateRef;

    public LockFreeBucket(BucketConfiguration configuration, TimeMeter timeMeter) {
        this(new AtomicReference<StateWithConfiguration>(LockFreeBucket.createStateWithConfiguration(configuration, timeMeter)), timeMeter, BucketListener.NOPE);
    }

    private LockFreeBucket(AtomicReference<StateWithConfiguration> stateRef, TimeMeter timeMeter, BucketListener listener) {
        super(listener, timeMeter);
        this.stateRef = stateRef;
    }

    @Override
    public Bucket toListenable(BucketListener listener) {
        return new LockFreeBucket(this.stateRef, this.timeMeter, listener);
    }

    @Override
    public boolean isAsyncModeSupported() {
        return true;
    }

    @Override
    protected long consumeAsMuchAsPossibleImpl(long limit) {
        StateWithConfiguration previousState = this.stateRef.get();
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens();
            long toConsume = Math.min(limit, availableToConsume);
            if (toConsume == 0L) {
                return 0L;
            }
            newState.consume(toConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return toConsume;
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected boolean tryConsumeImpl(long tokensToConsume) {
        StateWithConfiguration previousState = this.stateRef.get();
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens();
            if (tokensToConsume > availableToConsume) {
                return false;
            }
            newState.consume(tokensToConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return true;
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected ConsumptionProbe tryConsumeAndReturnRemainingTokensImpl(long tokensToConsume) {
        StateWithConfiguration previousState = this.stateRef.get();
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens();
            if (tokensToConsume > availableToConsume) {
                long nanosToWaitForRefill = newState.delayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos);
                return ConsumptionProbe.rejected(availableToConsume, nanosToWaitForRefill);
            }
            newState.consume(tokensToConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return ConsumptionProbe.consumed(availableToConsume - tokensToConsume);
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected EstimationProbe estimateAbilityToConsumeImpl(long tokensToEstimate) {
        StateWithConfiguration previousState = this.stateRef.get();
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        newState.refillAllBandwidth(currentTimeNanos);
        long availableToConsume = newState.getAvailableTokens();
        if (tokensToEstimate > availableToConsume) {
            long nanosToWaitForRefill = newState.delayNanosAfterWillBePossibleToConsume(tokensToEstimate, currentTimeNanos);
            return EstimationProbe.canNotBeConsumed(availableToConsume, nanosToWaitForRefill);
        }
        return EstimationProbe.canBeConsumed(availableToConsume);
    }

    @Override
    protected long reserveAndCalculateTimeToSleepImpl(long tokensToConsume, long waitIfBusyNanosLimit) {
        StateWithConfiguration previousState = this.stateRef.get();
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long nanosToCloseDeficit = newState.delayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos);
            if (nanosToCloseDeficit == 0L) {
                newState.consume(tokensToConsume);
                if (this.stateRef.compareAndSet(previousState, newState)) {
                    return 0L;
                }
                previousState = this.stateRef.get();
                newState.copyStateFrom(previousState);
                continue;
            }
            if (nanosToCloseDeficit == Long.MAX_VALUE || nanosToCloseDeficit > waitIfBusyNanosLimit) {
                return Long.MAX_VALUE;
            }
            newState.consume(tokensToConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return nanosToCloseDeficit;
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected void addTokensImpl(long tokensToAdd) {
        StateWithConfiguration previousState = this.stateRef.get();
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            newState.state.addTokens(newState.configuration.getBandwidths(), tokensToAdd);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return;
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected void replaceConfigurationImpl(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        StateWithConfiguration previousState = this.stateRef.get();
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            newState.configuration = newConfiguration;
            newState.state = newState.state.replaceConfiguration(previousState.configuration, newConfiguration, tokensInheritanceStrategy, currentTimeNanos);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return;
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected long consumeIgnoringRateLimitsImpl(long tokensToConsume) {
        StateWithConfiguration previousState = this.stateRef.get();
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long nanosToCloseDeficit = newState.delayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos);
            if (nanosToCloseDeficit == INFINITY_DURATION) {
                return nanosToCloseDeficit;
            }
            newState.consume(tokensToConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return nanosToCloseDeficit;
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected VerboseResult<Long> consumeAsMuchAsPossibleVerboseImpl(long limit) {
        StateWithConfiguration previousState = this.stateRef.get();
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens();
            long toConsume = Math.min(limit, availableToConsume);
            if (toConsume == 0L) {
                return new VerboseResult<Long>(currentTimeNanos, 0L, newState.configuration, newState.state);
            }
            newState.consume(toConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return new VerboseResult<Long>(currentTimeNanos, toConsume, newState.configuration, newState.state.copy());
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected VerboseResult<Boolean> tryConsumeVerboseImpl(long tokensToConsume) {
        StateWithConfiguration previousState = this.stateRef.get();
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens();
            if (tokensToConsume > availableToConsume) {
                return new VerboseResult<Boolean>(currentTimeNanos, false, newState.configuration, newState.state);
            }
            newState.consume(tokensToConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return new VerboseResult<Boolean>(currentTimeNanos, true, newState.configuration, newState.state.copy());
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected VerboseResult<ConsumptionProbe> tryConsumeAndReturnRemainingTokensVerboseImpl(long tokensToConsume) {
        StateWithConfiguration previousState = this.stateRef.get();
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens();
            if (tokensToConsume > availableToConsume) {
                long nanosToWaitForRefill = newState.delayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos);
                ConsumptionProbe consumptionProbe = ConsumptionProbe.rejected(availableToConsume, nanosToWaitForRefill);
                return new VerboseResult<ConsumptionProbe>(currentTimeNanos, consumptionProbe, newState.configuration, newState.state);
            }
            newState.consume(tokensToConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                ConsumptionProbe consumptionProbe = ConsumptionProbe.consumed(availableToConsume - tokensToConsume);
                return new VerboseResult<ConsumptionProbe>(currentTimeNanos, consumptionProbe, newState.configuration, newState.state.copy());
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected VerboseResult<EstimationProbe> estimateAbilityToConsumeVerboseImpl(long tokensToEstimate) {
        StateWithConfiguration previousState = this.stateRef.get();
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        newState.refillAllBandwidth(currentTimeNanos);
        long availableToConsume = newState.getAvailableTokens();
        if (tokensToEstimate > availableToConsume) {
            long nanosToWaitForRefill = newState.delayNanosAfterWillBePossibleToConsume(tokensToEstimate, currentTimeNanos);
            EstimationProbe estimationProbe = EstimationProbe.canNotBeConsumed(availableToConsume, nanosToWaitForRefill);
            return new VerboseResult<EstimationProbe>(currentTimeNanos, estimationProbe, newState.configuration, newState.state);
        }
        EstimationProbe estimationProbe = EstimationProbe.canBeConsumed(availableToConsume);
        return new VerboseResult<EstimationProbe>(currentTimeNanos, estimationProbe, newState.configuration, newState.state);
    }

    @Override
    protected VerboseResult<Long> getAvailableTokensVerboseImpl() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        StateWithConfiguration snapshot = this.stateRef.get().copy();
        snapshot.refillAllBandwidth(currentTimeNanos);
        return new VerboseResult<Long>(currentTimeNanos, snapshot.getAvailableTokens(), snapshot.configuration, snapshot.state);
    }

    @Override
    protected VerboseResult<Nothing> addTokensVerboseImpl(long tokensToAdd) {
        StateWithConfiguration previousState = this.stateRef.get();
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            newState.state.addTokens(newState.configuration.getBandwidths(), tokensToAdd);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return new VerboseResult<Nothing>(currentTimeNanos, Nothing.INSTANCE, newState.configuration, newState.state.copy());
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected VerboseResult<Nothing> replaceConfigurationVerboseImpl(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        StateWithConfiguration previousState = this.stateRef.get();
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            newState.configuration = newConfiguration;
            newState.state = newState.state.replaceConfiguration(previousState.configuration, newConfiguration, tokensInheritanceStrategy, currentTimeNanos);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return new VerboseResult<Object>(currentTimeNanos, null, newState.configuration, newState.state.copy());
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected VerboseResult<Long> consumeIgnoringRateLimitsVerboseImpl(long tokensToConsume) {
        StateWithConfiguration previousState = this.stateRef.get();
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long nanosToCloseDeficit = newState.delayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos);
            if (nanosToCloseDeficit == INFINITY_DURATION) {
                return new VerboseResult<Long>(currentTimeNanos, nanosToCloseDeficit, newState.configuration, newState.state);
            }
            newState.consume(tokensToConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return new VerboseResult<Long>(currentTimeNanos, nanosToCloseDeficit, newState.configuration, newState.state.copy());
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    public long getAvailableTokens() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        StateWithConfiguration snapshot = this.stateRef.get().copy();
        snapshot.refillAllBandwidth(currentTimeNanos);
        return snapshot.getAvailableTokens();
    }

    @Override
    protected CompletableFuture<Boolean> tryConsumeAsyncImpl(long tokensToConsume) {
        boolean result = this.tryConsumeImpl(tokensToConsume);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    protected CompletableFuture<Void> addTokensAsyncImpl(long tokensToAdd) {
        this.addTokensImpl(tokensToAdd);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    protected CompletableFuture<Nothing> replaceConfigurationAsyncImpl(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        this.replaceConfigurationImpl(newConfiguration, tokensInheritanceStrategy);
        return CompletableFuture.completedFuture(Nothing.INSTANCE);
    }

    @Override
    protected CompletableFuture<Long> consumeIgnoringRateLimitsAsyncImpl(long tokensToConsume) {
        return CompletableFuture.completedFuture(this.consumeIgnoringRateLimitsImpl(tokensToConsume));
    }

    @Override
    protected CompletableFuture<ConsumptionProbe> tryConsumeAndReturnRemainingTokensAsyncImpl(long tokensToConsume) {
        ConsumptionProbe result = this.tryConsumeAndReturnRemainingTokensImpl(tokensToConsume);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    protected CompletableFuture<EstimationProbe> estimateAbilityToConsumeAsyncImpl(long tokensToEstimate) {
        EstimationProbe result = this.estimateAbilityToConsumeImpl(tokensToEstimate);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    protected CompletableFuture<Long> tryConsumeAsMuchAsPossibleAsyncImpl(long limit) {
        long result = this.consumeAsMuchAsPossibleImpl(limit);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    protected CompletableFuture<Long> reserveAndCalculateTimeToSleepAsyncImpl(long tokensToConsume, long maxWaitTimeNanos) {
        long result = this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, maxWaitTimeNanos);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    protected CompletableFuture<VerboseResult<Long>> tryConsumeAsMuchAsPossibleVerboseAsyncImpl(long limit) {
        VerboseResult<Long> result = this.consumeAsMuchAsPossibleVerboseImpl(limit);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    protected CompletableFuture<VerboseResult<Boolean>> tryConsumeVerboseAsyncImpl(long tokensToConsume) {
        VerboseResult<Boolean> result = this.tryConsumeVerboseImpl(tokensToConsume);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    protected CompletableFuture<VerboseResult<ConsumptionProbe>> tryConsumeAndReturnRemainingTokensVerboseAsyncImpl(long tokensToConsume) {
        VerboseResult<ConsumptionProbe> result = this.tryConsumeAndReturnRemainingTokensVerboseImpl(tokensToConsume);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    protected CompletableFuture<VerboseResult<EstimationProbe>> estimateAbilityToConsumeVerboseAsyncImpl(long tokensToEstimate) {
        VerboseResult<EstimationProbe> result = this.estimateAbilityToConsumeVerboseImpl(tokensToEstimate);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    protected CompletableFuture<VerboseResult<Nothing>> addTokensVerboseAsyncImpl(long tokensToAdd) {
        VerboseResult<Nothing> result = this.addTokensVerboseImpl(tokensToAdd);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    protected CompletableFuture<VerboseResult<Nothing>> replaceConfigurationVerboseAsyncImpl(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        VerboseResult<Nothing> result = this.replaceConfigurationVerboseImpl(newConfiguration, tokensInheritanceStrategy);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    protected CompletableFuture<VerboseResult<Long>> consumeIgnoringRateLimitsVerboseAsyncImpl(long tokensToConsume) {
        VerboseResult<Long> result = this.consumeIgnoringRateLimitsVerboseImpl(tokensToConsume);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public BucketState createSnapshot() {
        return this.stateRef.get().state.copy();
    }

    @Override
    public BucketConfiguration getConfiguration() {
        return this.stateRef.get().configuration;
    }

    TimeMeter getTimeMeter() {
        return this.timeMeter;
    }

    private static StateWithConfiguration createStateWithConfiguration(BucketConfiguration configuration, TimeMeter timeMeter) {
        BucketState initialState = BucketState.createInitialState(configuration, timeMeter.currentTimeNanos());
        return new StateWithConfiguration(configuration, initialState);
    }

    public String toString() {
        return "LockFreeBucket{state=" + this.stateRef.get() + ", configuration=" + this.getConfiguration() + '}';
    }

    private static class StateWithConfiguration {
        BucketConfiguration configuration;
        BucketState state;

        StateWithConfiguration(BucketConfiguration configuration, BucketState state) {
            this.configuration = configuration;
            this.state = state;
        }

        StateWithConfiguration copy() {
            return new StateWithConfiguration(this.configuration, this.state.copy());
        }

        void copyStateFrom(StateWithConfiguration other) {
            this.configuration = other.configuration;
            this.state.copyStateFrom(other.state);
        }

        void refillAllBandwidth(long currentTimeNanos) {
            this.state.refillAllBandwidth(this.configuration.getBandwidths(), currentTimeNanos);
        }

        long getAvailableTokens() {
            return this.state.getAvailableTokens(this.configuration.getBandwidths());
        }

        void consume(long tokensToConsume) {
            this.state.consume(this.configuration.getBandwidths(), tokensToConsume);
        }

        long delayNanosAfterWillBePossibleToConsume(long tokensToConsume, long currentTimeNanos) {
            return this.state.calculateDelayNanosAfterWillBePossibleToConsume(this.configuration.getBandwidths(), tokensToConsume, currentTimeNanos);
        }
    }
}

