/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.AsyncBucket;
import io.github.bucket4j.AsyncScheduledBucket;
import io.github.bucket4j.AsyncVerboseBucket;
import io.github.bucket4j.BlockingBucket;
import io.github.bucket4j.BlockingStrategy;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.EstimationProbe;
import io.github.bucket4j.Nothing;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.UninterruptibleBlockingStrategy;
import io.github.bucket4j.VerboseBucket;
import io.github.bucket4j.VerboseResult;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class AbstractBucket
implements Bucket,
BlockingBucket {
    protected static long INFINITY_DURATION = Long.MAX_VALUE;
    private static long UNLIMITED_AMOUNT = Long.MAX_VALUE;
    private final BucketListener listener;
    private final AsyncScheduledBucketImpl asyncView = new AsyncScheduledBucketImpl(){

        @Override
        public AsyncVerboseBucket asVerbose() {
            return AbstractBucket.this.asyncVerboseView;
        }

        @Override
        public CompletableFuture<Boolean> tryConsume(long tokensToConsume) {
            AbstractBucket.checkTokensToConsume(tokensToConsume);
            return AbstractBucket.this.tryConsumeAsyncImpl(tokensToConsume).thenApply(consumed -> {
                if (consumed.booleanValue()) {
                    AbstractBucket.this.listener.onConsumed(tokensToConsume);
                } else {
                    AbstractBucket.this.listener.onRejected(tokensToConsume);
                }
                return consumed;
            });
        }

        @Override
        public CompletableFuture<Long> consumeIgnoringRateLimits(long tokensToConsume) {
            AbstractBucket.checkTokensToConsume(tokensToConsume);
            return AbstractBucket.this.consumeIgnoringRateLimitsAsyncImpl(tokensToConsume).thenApply(penaltyNanos -> {
                if (penaltyNanos == INFINITY_DURATION) {
                    throw BucketExceptions.reservationOverflow();
                }
                AbstractBucket.this.listener.onConsumed(tokensToConsume);
                return penaltyNanos;
            });
        }

        @Override
        public CompletableFuture<ConsumptionProbe> tryConsumeAndReturnRemaining(long tokensToConsume) {
            AbstractBucket.checkTokensToConsume(tokensToConsume);
            return AbstractBucket.this.tryConsumeAndReturnRemainingTokensAsyncImpl(tokensToConsume).thenApply(probe -> {
                if (probe.isConsumed()) {
                    AbstractBucket.this.listener.onConsumed(tokensToConsume);
                } else {
                    AbstractBucket.this.listener.onRejected(tokensToConsume);
                }
                return probe;
            });
        }

        @Override
        public CompletableFuture<EstimationProbe> estimateAbilityToConsume(long numTokens) {
            AbstractBucket.checkTokensToConsume(numTokens);
            return AbstractBucket.this.estimateAbilityToConsumeAsyncImpl(numTokens);
        }

        @Override
        public CompletableFuture<Long> tryConsumeAsMuchAsPossible() {
            return AbstractBucket.this.tryConsumeAsMuchAsPossibleAsyncImpl(UNLIMITED_AMOUNT).thenApply(consumedTokens -> {
                if (consumedTokens > 0L) {
                    AbstractBucket.this.listener.onConsumed((long)consumedTokens);
                }
                return consumedTokens;
            });
        }

        @Override
        public CompletableFuture<Long> tryConsumeAsMuchAsPossible(long limit) {
            AbstractBucket.checkTokensToConsume(limit);
            return AbstractBucket.this.tryConsumeAsMuchAsPossibleAsyncImpl(limit).thenApply(consumedTokens -> {
                if (consumedTokens > 0L) {
                    AbstractBucket.this.listener.onConsumed((long)consumedTokens);
                }
                return consumedTokens;
            });
        }

        @Override
        public CompletableFuture<Boolean> tryConsume(long tokensToConsume, long maxWaitTimeNanos, ScheduledExecutorService scheduler) {
            AbstractBucket.checkMaxWaitTime(maxWaitTimeNanos);
            AbstractBucket.checkTokensToConsume(tokensToConsume);
            AbstractBucket.checkScheduler(scheduler);
            CompletableFuture<Boolean> resultFuture = new CompletableFuture<Boolean>();
            CompletableFuture<Long> reservationFuture = AbstractBucket.this.reserveAndCalculateTimeToSleepAsyncImpl(tokensToConsume, maxWaitTimeNanos);
            reservationFuture.whenComplete((nanosToSleep, exception) -> {
                if (exception != null) {
                    resultFuture.completeExceptionally((Throwable)exception);
                    return;
                }
                if (nanosToSleep == INFINITY_DURATION) {
                    resultFuture.complete(false);
                    AbstractBucket.this.listener.onRejected(tokensToConsume);
                    return;
                }
                if (nanosToSleep == 0L) {
                    resultFuture.complete(true);
                    AbstractBucket.this.listener.onConsumed(tokensToConsume);
                    return;
                }
                try {
                    AbstractBucket.this.listener.onConsumed(tokensToConsume);
                    AbstractBucket.this.listener.onDelayed((long)nanosToSleep);
                    Runnable delayedCompletion = () -> resultFuture.complete(true);
                    scheduler.schedule(delayedCompletion, (long)nanosToSleep, TimeUnit.NANOSECONDS);
                }
                catch (Throwable t) {
                    resultFuture.completeExceptionally(t);
                }
            });
            return resultFuture;
        }

        @Override
        public CompletableFuture<Void> consume(long tokensToConsume, ScheduledExecutorService scheduler) {
            AbstractBucket.checkTokensToConsume(tokensToConsume);
            AbstractBucket.checkScheduler(scheduler);
            CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
            CompletableFuture<Long> reservationFuture = AbstractBucket.this.reserveAndCalculateTimeToSleepAsyncImpl(tokensToConsume, INFINITY_DURATION);
            reservationFuture.whenComplete((nanosToSleep, exception) -> {
                if (exception != null) {
                    resultFuture.completeExceptionally((Throwable)exception);
                    return;
                }
                if (nanosToSleep == INFINITY_DURATION) {
                    resultFuture.completeExceptionally(BucketExceptions.reservationOverflow());
                    return;
                }
                if (nanosToSleep == 0L) {
                    resultFuture.complete(null);
                    AbstractBucket.this.listener.onConsumed(tokensToConsume);
                    return;
                }
                try {
                    AbstractBucket.this.listener.onConsumed(tokensToConsume);
                    AbstractBucket.this.listener.onDelayed((long)nanosToSleep);
                    Runnable delayedCompletion = () -> resultFuture.complete(null);
                    scheduler.schedule(delayedCompletion, (long)nanosToSleep, TimeUnit.NANOSECONDS);
                }
                catch (Throwable t) {
                    resultFuture.completeExceptionally(t);
                }
            });
            return resultFuture;
        }

        @Override
        public CompletableFuture<Void> replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
            AbstractBucket.checkConfiguration(newConfiguration);
            AbstractBucket.this.checkMigrationMode(tokensInheritanceStrategy);
            return AbstractBucket.this.replaceConfigurationAsyncImpl(newConfiguration, tokensInheritanceStrategy).thenApply(conflictingConfiguration -> null);
        }

        @Override
        public CompletableFuture<Void> addTokens(long tokensToAdd) {
            AbstractBucket.checkTokensToAdd(tokensToAdd);
            return AbstractBucket.this.addTokensAsyncImpl(tokensToAdd);
        }
    };
    private final AsyncVerboseBucket asyncVerboseView = new AsyncVerboseBucket(){

        @Override
        public CompletableFuture<VerboseResult<Boolean>> tryConsume(long tokensToConsume) {
            AbstractBucket.checkTokensToConsume(tokensToConsume);
            return AbstractBucket.this.tryConsumeVerboseAsyncImpl(tokensToConsume).thenApply(consumed -> {
                if (((Boolean)consumed.getValue()).booleanValue()) {
                    AbstractBucket.this.listener.onConsumed(tokensToConsume);
                } else {
                    AbstractBucket.this.listener.onRejected(tokensToConsume);
                }
                return consumed;
            });
        }

        @Override
        public CompletableFuture<VerboseResult<Long>> consumeIgnoringRateLimits(long tokensToConsume) {
            AbstractBucket.checkTokensToConsume(tokensToConsume);
            return AbstractBucket.this.consumeIgnoringRateLimitsVerboseAsyncImpl(tokensToConsume).thenApply(penaltyNanos -> {
                if ((Long)penaltyNanos.getValue() == INFINITY_DURATION) {
                    throw BucketExceptions.reservationOverflow();
                }
                AbstractBucket.this.listener.onConsumed(tokensToConsume);
                return penaltyNanos;
            });
        }

        @Override
        public CompletableFuture<VerboseResult<ConsumptionProbe>> tryConsumeAndReturnRemaining(long tokensToConsume) {
            AbstractBucket.checkTokensToConsume(tokensToConsume);
            return AbstractBucket.this.tryConsumeAndReturnRemainingTokensVerboseAsyncImpl(tokensToConsume).thenApply(probe -> {
                if (((ConsumptionProbe)probe.getValue()).isConsumed()) {
                    AbstractBucket.this.listener.onConsumed(tokensToConsume);
                } else {
                    AbstractBucket.this.listener.onRejected(tokensToConsume);
                }
                return probe;
            });
        }

        @Override
        public CompletableFuture<VerboseResult<EstimationProbe>> estimateAbilityToConsume(long numTokens) {
            AbstractBucket.checkTokensToConsume(numTokens);
            return AbstractBucket.this.estimateAbilityToConsumeVerboseAsyncImpl(numTokens);
        }

        @Override
        public CompletableFuture<VerboseResult<Long>> tryConsumeAsMuchAsPossible() {
            return AbstractBucket.this.tryConsumeAsMuchAsPossibleVerboseAsyncImpl(UNLIMITED_AMOUNT).thenApply(consumedTokens -> {
                long actuallyConsumedTokens = (Long)consumedTokens.getValue();
                if (actuallyConsumedTokens > 0L) {
                    AbstractBucket.this.listener.onConsumed(actuallyConsumedTokens);
                }
                return consumedTokens;
            });
        }

        @Override
        public CompletableFuture<VerboseResult<Long>> tryConsumeAsMuchAsPossible(long limit) {
            AbstractBucket.checkTokensToConsume(limit);
            return AbstractBucket.this.tryConsumeAsMuchAsPossibleVerboseAsyncImpl(limit).thenApply(consumedTokens -> {
                long actuallyConsumedTokens = (Long)consumedTokens.getValue();
                if (actuallyConsumedTokens > 0L) {
                    AbstractBucket.this.listener.onConsumed(actuallyConsumedTokens);
                }
                return consumedTokens;
            });
        }

        @Override
        public CompletableFuture<VerboseResult<Nothing>> addTokens(long tokensToAdd) {
            AbstractBucket.checkTokensToAdd(tokensToAdd);
            return AbstractBucket.this.addTokensVerboseAsyncImpl(tokensToAdd);
        }

        @Override
        public CompletableFuture<VerboseResult<Nothing>> replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
            AbstractBucket.checkConfiguration(newConfiguration);
            AbstractBucket.this.checkMigrationMode(tokensInheritanceStrategy);
            CompletableFuture<VerboseResult<Nothing>> resultFuture = AbstractBucket.this.replaceConfigurationVerboseAsyncImpl(newConfiguration, tokensInheritanceStrategy);
            return resultFuture.thenApply(result -> result.map(conflictingConfiguration -> Nothing.INSTANCE));
        }
    };
    private final VerboseBucket verboseView = new VerboseBucket(){

        @Override
        public VerboseResult<Boolean> tryConsume(long tokensToConsume) {
            AbstractBucket.checkTokensToConsume(tokensToConsume);
            VerboseResult<Boolean> result = AbstractBucket.this.tryConsumeVerboseImpl(tokensToConsume);
            if (result.getValue().booleanValue()) {
                AbstractBucket.this.listener.onConsumed(tokensToConsume);
            } else {
                AbstractBucket.this.listener.onRejected(tokensToConsume);
            }
            return result;
        }

        @Override
        public VerboseResult<Long> consumeIgnoringRateLimits(long tokens) {
            AbstractBucket.checkTokensToConsume(tokens);
            VerboseResult<Long> result = AbstractBucket.this.consumeIgnoringRateLimitsVerboseImpl(tokens);
            long penaltyNanos = result.getValue();
            if (penaltyNanos == INFINITY_DURATION) {
                throw BucketExceptions.reservationOverflow();
            }
            AbstractBucket.this.listener.onConsumed(tokens);
            return result;
        }

        @Override
        public VerboseResult<ConsumptionProbe> tryConsumeAndReturnRemaining(long tokensToConsume) {
            AbstractBucket.checkTokensToConsume(tokensToConsume);
            VerboseResult<ConsumptionProbe> result = AbstractBucket.this.tryConsumeAndReturnRemainingTokensVerboseImpl(tokensToConsume);
            ConsumptionProbe probe = result.getValue();
            if (probe.isConsumed()) {
                AbstractBucket.this.listener.onConsumed(tokensToConsume);
            } else {
                AbstractBucket.this.listener.onRejected(tokensToConsume);
            }
            return result;
        }

        @Override
        public VerboseResult<EstimationProbe> estimateAbilityToConsume(long numTokens) {
            AbstractBucket.checkTokensToConsume(numTokens);
            return AbstractBucket.this.estimateAbilityToConsumeVerboseImpl(numTokens);
        }

        @Override
        public VerboseResult<Long> tryConsumeAsMuchAsPossible() {
            VerboseResult<Long> result = AbstractBucket.this.consumeAsMuchAsPossibleVerboseImpl(UNLIMITED_AMOUNT);
            long consumed = result.getValue();
            if (consumed > 0L) {
                AbstractBucket.this.listener.onConsumed(consumed);
            }
            return result;
        }

        @Override
        public VerboseResult<Long> tryConsumeAsMuchAsPossible(long limit) {
            AbstractBucket.checkTokensToConsume(limit);
            VerboseResult<Long> result = AbstractBucket.this.consumeAsMuchAsPossibleVerboseImpl(limit);
            long consumed = result.getValue();
            if (consumed > 0L) {
                AbstractBucket.this.listener.onConsumed(consumed);
            }
            return result;
        }

        @Override
        public VerboseResult<Long> getAvailableTokens() {
            return AbstractBucket.this.getAvailableTokensVerboseImpl();
        }

        @Override
        public VerboseResult<Nothing> addTokens(long tokensToAdd) {
            AbstractBucket.checkTokensToAdd(tokensToAdd);
            return AbstractBucket.this.addTokensVerboseImpl(tokensToAdd);
        }

        @Override
        public VerboseResult<Nothing> replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
            AbstractBucket.checkConfiguration(newConfiguration);
            AbstractBucket.this.checkMigrationMode(tokensInheritanceStrategy);
            return AbstractBucket.this.replaceConfigurationVerboseImpl(newConfiguration, tokensInheritanceStrategy);
        }
    };

    protected abstract long consumeAsMuchAsPossibleImpl(long var1);

    protected abstract boolean tryConsumeImpl(long var1);

    protected abstract ConsumptionProbe tryConsumeAndReturnRemainingTokensImpl(long var1);

    protected abstract EstimationProbe estimateAbilityToConsumeImpl(long var1);

    protected abstract long reserveAndCalculateTimeToSleepImpl(long var1, long var3);

    protected abstract void addTokensImpl(long var1);

    protected abstract void replaceConfigurationImpl(BucketConfiguration var1, TokensInheritanceStrategy var2);

    protected abstract long consumeIgnoringRateLimitsImpl(long var1);

    protected abstract VerboseResult<Long> consumeAsMuchAsPossibleVerboseImpl(long var1);

    protected abstract VerboseResult<Boolean> tryConsumeVerboseImpl(long var1);

    protected abstract VerboseResult<ConsumptionProbe> tryConsumeAndReturnRemainingTokensVerboseImpl(long var1);

    protected abstract VerboseResult<EstimationProbe> estimateAbilityToConsumeVerboseImpl(long var1);

    protected abstract VerboseResult<Long> getAvailableTokensVerboseImpl();

    protected abstract VerboseResult<Nothing> addTokensVerboseImpl(long var1);

    protected abstract VerboseResult<Nothing> replaceConfigurationVerboseImpl(BucketConfiguration var1, TokensInheritanceStrategy var2);

    protected abstract VerboseResult<Long> consumeIgnoringRateLimitsVerboseImpl(long var1);

    protected abstract CompletableFuture<Long> tryConsumeAsMuchAsPossibleAsyncImpl(long var1);

    protected abstract CompletableFuture<Boolean> tryConsumeAsyncImpl(long var1);

    protected abstract CompletableFuture<ConsumptionProbe> tryConsumeAndReturnRemainingTokensAsyncImpl(long var1);

    protected abstract CompletableFuture<EstimationProbe> estimateAbilityToConsumeAsyncImpl(long var1);

    protected abstract CompletableFuture<Long> reserveAndCalculateTimeToSleepAsyncImpl(long var1, long var3);

    protected abstract CompletableFuture<Void> addTokensAsyncImpl(long var1);

    protected abstract CompletableFuture<Nothing> replaceConfigurationAsyncImpl(BucketConfiguration var1, TokensInheritanceStrategy var2);

    protected abstract CompletableFuture<Long> consumeIgnoringRateLimitsAsyncImpl(long var1);

    protected abstract CompletableFuture<VerboseResult<Long>> tryConsumeAsMuchAsPossibleVerboseAsyncImpl(long var1);

    protected abstract CompletableFuture<VerboseResult<Boolean>> tryConsumeVerboseAsyncImpl(long var1);

    protected abstract CompletableFuture<VerboseResult<ConsumptionProbe>> tryConsumeAndReturnRemainingTokensVerboseAsyncImpl(long var1);

    protected abstract CompletableFuture<VerboseResult<EstimationProbe>> estimateAbilityToConsumeVerboseAsyncImpl(long var1);

    protected abstract CompletableFuture<VerboseResult<Nothing>> addTokensVerboseAsyncImpl(long var1);

    protected abstract CompletableFuture<VerboseResult<Nothing>> replaceConfigurationVerboseAsyncImpl(BucketConfiguration var1, TokensInheritanceStrategy var2);

    protected abstract CompletableFuture<VerboseResult<Long>> consumeIgnoringRateLimitsVerboseAsyncImpl(long var1);

    public AbstractBucket(BucketListener listener) {
        if (listener == null) {
            throw BucketExceptions.nullListener();
        }
        this.listener = listener;
    }

    @Override
    public VerboseBucket asVerbose() {
        return this.verboseView;
    }

    @Override
    public AsyncBucket asAsync() {
        if (!this.isAsyncModeSupported()) {
            throw new UnsupportedOperationException();
        }
        return this.asyncView;
    }

    @Override
    public AsyncScheduledBucket asAsyncScheduler() {
        if (!this.isAsyncModeSupported()) {
            throw new UnsupportedOperationException();
        }
        return this.asyncView;
    }

    @Override
    public BlockingBucket asScheduler() {
        return this;
    }

    @Override
    public boolean tryConsume(long tokensToConsume) {
        AbstractBucket.checkTokensToConsume(tokensToConsume);
        if (this.tryConsumeImpl(tokensToConsume)) {
            this.listener.onConsumed(tokensToConsume);
            return true;
        }
        this.listener.onRejected(tokensToConsume);
        return false;
    }

    @Override
    public boolean tryConsume(long tokensToConsume, long maxWaitTimeNanos, BlockingStrategy blockingStrategy) throws InterruptedException {
        AbstractBucket.checkTokensToConsume(tokensToConsume);
        AbstractBucket.checkMaxWaitTime(maxWaitTimeNanos);
        long nanosToSleep = this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, maxWaitTimeNanos);
        if (nanosToSleep == INFINITY_DURATION) {
            this.listener.onRejected(tokensToConsume);
            return false;
        }
        this.listener.onConsumed(tokensToConsume);
        if (nanosToSleep > 0L) {
            try {
                blockingStrategy.park(nanosToSleep);
            }
            catch (InterruptedException e) {
                this.listener.onInterrupted(e);
                throw e;
            }
            this.listener.onParked(nanosToSleep);
        }
        return true;
    }

    @Override
    public boolean tryConsumeUninterruptibly(long tokensToConsume, long maxWaitTimeNanos, UninterruptibleBlockingStrategy blockingStrategy) {
        AbstractBucket.checkTokensToConsume(tokensToConsume);
        AbstractBucket.checkMaxWaitTime(maxWaitTimeNanos);
        long nanosToSleep = this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, maxWaitTimeNanos);
        if (nanosToSleep == INFINITY_DURATION) {
            this.listener.onRejected(tokensToConsume);
            return false;
        }
        this.listener.onConsumed(tokensToConsume);
        if (nanosToSleep > 0L) {
            blockingStrategy.parkUninterruptibly(nanosToSleep);
            this.listener.onParked(nanosToSleep);
        }
        return true;
    }

    @Override
    public void consume(long tokensToConsume, BlockingStrategy blockingStrategy) throws InterruptedException {
        AbstractBucket.checkTokensToConsume(tokensToConsume);
        long nanosToSleep = this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, INFINITY_DURATION);
        if (nanosToSleep == INFINITY_DURATION) {
            throw BucketExceptions.reservationOverflow();
        }
        this.listener.onConsumed(tokensToConsume);
        if (nanosToSleep > 0L) {
            try {
                blockingStrategy.park(nanosToSleep);
            }
            catch (InterruptedException e) {
                this.listener.onInterrupted(e);
                throw e;
            }
            this.listener.onParked(nanosToSleep);
        }
    }

    @Override
    public void consumeUninterruptibly(long tokensToConsume, UninterruptibleBlockingStrategy blockingStrategy) {
        AbstractBucket.checkTokensToConsume(tokensToConsume);
        long nanosToSleep = this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, INFINITY_DURATION);
        if (nanosToSleep == INFINITY_DURATION) {
            throw BucketExceptions.reservationOverflow();
        }
        this.listener.onConsumed(tokensToConsume);
        if (nanosToSleep > 0L) {
            blockingStrategy.parkUninterruptibly(nanosToSleep);
            this.listener.onParked(nanosToSleep);
        }
    }

    @Override
    public long consumeIgnoringRateLimits(long tokens) {
        AbstractBucket.checkTokensToConsume(tokens);
        long penaltyNanos = this.consumeIgnoringRateLimitsImpl(tokens);
        if (penaltyNanos == INFINITY_DURATION) {
            throw BucketExceptions.reservationOverflow();
        }
        this.listener.onConsumed(tokens);
        return penaltyNanos;
    }

    @Override
    public long tryConsumeAsMuchAsPossible(long limit) {
        AbstractBucket.checkTokensToConsume(limit);
        long consumed = this.consumeAsMuchAsPossibleImpl(limit);
        if (consumed > 0L) {
            this.listener.onConsumed(consumed);
        }
        return consumed;
    }

    @Override
    public long tryConsumeAsMuchAsPossible() {
        long consumed = this.consumeAsMuchAsPossibleImpl(UNLIMITED_AMOUNT);
        if (consumed > 0L) {
            this.listener.onConsumed(consumed);
        }
        return consumed;
    }

    @Override
    public ConsumptionProbe tryConsumeAndReturnRemaining(long tokensToConsume) {
        AbstractBucket.checkTokensToConsume(tokensToConsume);
        ConsumptionProbe probe = this.tryConsumeAndReturnRemainingTokensImpl(tokensToConsume);
        if (probe.isConsumed()) {
            this.listener.onConsumed(tokensToConsume);
        } else {
            this.listener.onRejected(tokensToConsume);
        }
        return probe;
    }

    @Override
    public EstimationProbe estimateAbilityToConsume(long numTokens) {
        AbstractBucket.checkTokensToConsume(numTokens);
        return this.estimateAbilityToConsumeImpl(numTokens);
    }

    @Override
    public void addTokens(long tokensToAdd) {
        AbstractBucket.checkTokensToAdd(tokensToAdd);
        this.addTokensImpl(tokensToAdd);
    }

    @Override
    public void replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        AbstractBucket.checkConfiguration(newConfiguration);
        this.checkMigrationMode(tokensInheritanceStrategy);
        this.replaceConfigurationImpl(newConfiguration, tokensInheritanceStrategy);
    }

    private static void checkTokensToAdd(long tokensToAdd) {
        if (tokensToAdd <= 0L) {
            throw new IllegalArgumentException("tokensToAdd should be >= 0");
        }
    }

    private static void checkTokensToConsume(long tokensToConsume) {
        if (tokensToConsume <= 0L) {
            throw BucketExceptions.nonPositiveTokensToConsume(tokensToConsume);
        }
    }

    private static void checkMaxWaitTime(long maxWaitTimeNanos) {
        if (maxWaitTimeNanos <= 0L) {
            throw BucketExceptions.nonPositiveNanosToWait(maxWaitTimeNanos);
        }
    }

    private static void checkScheduler(ScheduledExecutorService scheduler) {
        if (scheduler == null) {
            throw BucketExceptions.nullScheduler();
        }
    }

    private static void checkConfiguration(BucketConfiguration newConfiguration) {
        if (newConfiguration == null) {
            throw BucketExceptions.nullConfiguration();
        }
    }

    private void checkMigrationMode(TokensInheritanceStrategy tokensInheritanceStrategy) {
        if (tokensInheritanceStrategy == null) {
            throw BucketExceptions.nullTokensInheritanceStrategy();
        }
    }

    private static interface AsyncScheduledBucketImpl
    extends AsyncBucket,
    AsyncScheduledBucket {
    }
}

