/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.drawing;

import java.awt.Color;

public class PositionedRectangle {
    private final float x;
    private final float y;
    private final float width;
    private final float height;
    private final Color color;

    PositionedRectangle(float x, float y, float width, float height, Color color) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.color = color;
    }

    public static PositionedRectangleBuilder builder() {
        return new PositionedRectangleBuilder();
    }

    public PositionedRectangleBuilder toBuilder() {
        return new PositionedRectangleBuilder().x(this.x).y(this.y).width(this.width).height(this.height).color(this.color);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public Color getColor() {
        return this.color;
    }

    public static class PositionedRectangleBuilder {
        private float x;
        private float y;
        private float width;
        private float height;
        private Color color;

        PositionedRectangleBuilder() {
        }

        public PositionedRectangleBuilder x(float x) {
            this.x = x;
            return this;
        }

        public PositionedRectangleBuilder y(float y) {
            this.y = y;
            return this;
        }

        public PositionedRectangleBuilder width(float width) {
            this.width = width;
            return this;
        }

        public PositionedRectangleBuilder height(float height) {
            this.height = height;
            return this;
        }

        public PositionedRectangleBuilder color(Color color) {
            this.color = color;
            return this;
        }

        public PositionedRectangle build() {
            return new PositionedRectangle(this.x, this.y, this.width, this.height, this.color);
        }

        public String toString() {
            return "PositionedRectangle.PositionedRectangleBuilder(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ", color=" + this.color + ")";
        }
    }
}

