/*
 * Decompiled with CFR 0.152.
 */
package com.github.oowekyala.ooxml.messages;

import com.github.oowekyala.ooxml.messages.ContextLines;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;

class TextDoc {
    private final List<Integer> lineOffsets = new ArrayList<Integer>();
    private final List<String> lines = new ArrayList<String>();
    private final int sourceCodeLength;
    private final String sourceCode;

    TextDoc(String sourceCode) {
        this.sourceCodeLength = sourceCode.length();
        this.sourceCode = sourceCode;
        try (Scanner scanner = new Scanner(new StringReader(sourceCode));){
            int currentGlobalOffset = 0;
            while (scanner.hasNextLine()) {
                this.lineOffsets.add(currentGlobalOffset);
                currentGlobalOffset += this.getLineLengthWithLineSeparator(scanner);
            }
        }
        if (this.lines.isEmpty()) {
            this.lines.add("");
        }
    }

    public String getTextString() {
        return this.sourceCode;
    }

    ContextLines getLinesAround(int line, int numLinesAround) {
        int zeroL = line - 1;
        int firstL = Math.max(0, zeroL - numLinesAround + 1);
        int lastL = Math.min(this.lines.size(), zeroL + numLinesAround);
        List<String> strings = this.lines.subList(firstL, lastL);
        return new ContextLines(strings, firstL + 1, zeroL - firstL);
    }

    private int getLineLengthWithLineSeparator(Scanner scanner) {
        String nline = scanner.nextLine();
        this.lines.add(nline);
        int lineLength = nline.length();
        String lineSeparationMatch = scanner.match().group(1);
        if (lineSeparationMatch != null) {
            lineLength += lineSeparationMatch.length();
        }
        return lineLength;
    }

    public int lineNumberFromOffset(int offset) {
        int search = Collections.binarySearch(this.lineOffsets, offset);
        return search >= 0 ? search + 1 : -(search + 1);
    }

    public int columnFromOffset(int lineNumber, int offset) {
        int lineIndex = lineNumber - 1;
        if (lineIndex < 0 || lineIndex >= this.lineOffsets.size()) {
            return 0;
        }
        int columnOffset = offset - this.lineOffsets.get(lineNumber - 1);
        return columnOffset + 1;
    }
}

