/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.util.EqualityUtil;
import com.github.jferard.fastods.util.TableNameUtil;

public class Position {
    static final int ABSOLUTE_COL = 1;
    static final int ABSOLUTE_ROW = 2;
    static final int ABSOLUTE_TABLE = 4;
    private final EqualityUtil equalityUtil;
    private final int column;
    private final int status;
    private final TableNameUtil tableNameUtil;
    private final int row;
    private final String filename;
    private final String tableName;

    public Position(EqualityUtil equalityUtil, TableNameUtil tableNameUtil, String fileName, String tableName, int row, int column, int status) {
        this.equalityUtil = equalityUtil;
        this.tableNameUtil = tableNameUtil;
        this.filename = fileName;
        this.tableName = tableName;
        this.row = row;
        this.column = column;
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Position)) {
            return false;
        }
        Position other = (Position)o;
        return this.equalityUtil.equal(this.filename, other.filename) && this.equalityUtil.equal(this.tableName, other.tableName) && this.row == other.row && this.column == other.column && this.status == other.status;
    }

    public int hashCode() {
        return this.equalityUtil.hashObjects(this.filename, this.tableName, this.row, this.column, this.status);
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendFilename(sb);
        this.appendTableName(sb);
        this.appendRowColAddress(sb);
        return sb.toString();
    }

    private void appendFilename(StringBuilder sb) {
        if (this.filename != null) {
            sb.append('\'');
            for (int i = 0; i < this.filename.length(); ++i) {
                char c = this.filename.charAt(i);
                if (c == '\'') {
                    sb.append('\'');
                }
                sb.append(c);
            }
            sb.append("'#");
        }
    }

    private void appendTableName(StringBuilder sb) {
        if (this.tableName != null) {
            if ((this.status & 4) == 4) {
                sb.append(this.tableNameUtil.escapeTableName('$' + this.tableName));
            } else {
                sb.append(this.tableNameUtil.escapeTableName(this.tableName));
            }
            sb.append('.');
        }
    }

    private void appendRowColAddress(StringBuilder sb) {
        StringBuilder tempSb = this.getColStringBuilder();
        if ((this.status & 1) == 1) {
            sb.append('$');
        }
        sb.append((CharSequence)tempSb);
        if ((this.status & 2) == 2) {
            sb.append('$');
        }
        sb.append(this.row + 1);
    }

    private StringBuilder getColStringBuilder() {
        StringBuilder tempSb = new StringBuilder();
        int col = this.column;
        while (col >= 26) {
            tempSb.insert(0, (char)(65 + col % 26));
            col = col / 26 - 1;
        }
        tempSb.insert(0, (char)(65 + col));
        return tempSb;
    }
}

