/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.Color;
import com.github.jferard.fastods.SimpleColor;
import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.style.Borders;
import com.github.jferard.fastods.style.FontFace;
import com.github.jferard.fastods.style.FontFaceContainerStyle;
import com.github.jferard.fastods.style.Margins;
import com.github.jferard.fastods.style.ObjectStyleFamily;
import com.github.jferard.fastods.style.TableCellStyleBuilder;
import com.github.jferard.fastods.style.TextProperties;
import com.github.jferard.fastods.util.Angle;
import com.github.jferard.fastods.util.Length;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class TableCellStyle
implements FontFaceContainerStyle {
    public static final TableCellStyle DEFAULT_CELL_STYLE = TableCellStyle.builder("Default").textAlign(Align.LEFT).verticalAlign(VerticalAlign.TOP).fontWrap(false).backgroundColor(SimpleColor.NONE).allMargins(Length.NULL_LENGTH).fontName("Liberation Sans").parentCellStyle(null).build();
    private final Color backgroundColor;
    private final boolean hidden;
    private final Borders borders;
    private final Margins margins;
    private final String name;
    private final TableCellStyle parentCellStyle;
    private final Align textAlign;
    private final TextProperties textProperties;
    private final VerticalAlign verticalAlign;
    private final Angle rotating;
    private final boolean wrap;
    private final DataStyle dataStyle;
    private String key;

    public static TableCellStyleBuilder builder(String name) {
        return new TableCellStyleBuilder(name);
    }

    TableCellStyle(String name, boolean hidden, DataStyle dataStyle, Color backgroundColor, TextProperties textProperties, Align textAlign, VerticalAlign verticalAlign, boolean wrap, TableCellStyle parentCellStyle, Borders borders, Margins margins, Angle textRotating) {
        this.hidden = hidden;
        this.borders = borders;
        this.margins = margins;
        this.name = name;
        this.dataStyle = dataStyle;
        this.backgroundColor = backgroundColor;
        this.textProperties = textProperties;
        this.textAlign = textAlign;
        this.verticalAlign = verticalAlign;
        this.wrap = wrap;
        this.parentCellStyle = parentCellStyle;
        this.rotating = textRotating;
    }

    @Override
    public void addToElements(OdsElements odsElements) {
        if (this.dataStyle != null) {
            this.dataStyle.addToElements(odsElements);
        }
        odsElements.addContentStyle(this);
    }

    private void appendCellProperties(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<style:table-cell-properties");
        if (this.backgroundColor != SimpleColor.NONE) {
            util.appendAttribute(appendable, (CharSequence)"fo:background-color", this.backgroundColor.hexValue());
        }
        if (this.verticalAlign != null) {
            util.appendAttribute(appendable, (CharSequence)"style:vertical-align", this.verticalAlign.attrValue);
        }
        if (this.rotating != null) {
            util.appendAttribute(appendable, (CharSequence)"style:rotation-angle", this.rotating.toString());
        }
        this.borders.appendXMLContent(util, appendable);
        if (this.wrap) {
            util.appendAttribute(appendable, (CharSequence)"fo:wrap-option", "wrap");
        }
        appendable.append("/>");
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<style:style");
        util.appendEAttribute(appendable, "style:name", this.name);
        util.appendAttribute(appendable, (CharSequence)"style:family", "table-cell");
        if (this.parentCellStyle != null) {
            util.appendEAttribute(appendable, "style:parent-style-name", this.parentCellStyle.getRealName());
        }
        if (this.dataStyle != null) {
            util.appendEAttribute(appendable, "style:data-style-name", this.dataStyle.getName());
        }
        if (this.hasCellProperties() || this.hasTextProperties() || this.hasParagraphProperties()) {
            appendable.append(">");
            if (this.hasCellProperties()) {
                this.appendCellProperties(util, appendable);
            }
            if (this.hasTextProperties()) {
                this.textProperties.appendXMLContent(util, appendable);
            }
            if (this.hasParagraphProperties()) {
                appendable.append("<style:paragraph-properties");
                if (this.textAlign != null) {
                    util.appendAttribute(appendable, (CharSequence)"fo:text-align", this.textAlign.attrValue);
                }
                this.margins.appendXMLContent(util, appendable);
                appendable.append("/>");
            }
            appendable.append("</style:style>");
        } else {
            appendable.append("/>");
        }
    }

    private boolean hasTextProperties() {
        return this.textProperties != null && this.textProperties.isNotEmpty();
    }

    private boolean hasParagraphProperties() {
        return this.textAlign != null || !this.margins.areVoid();
    }

    public DataStyle getDataStyle() {
        return this.dataStyle;
    }

    @Override
    public ObjectStyleFamily getFamily() {
        return ObjectStyleFamily.TABLE_CELL;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = (Object)((Object)this.getFamily()) + "@" + this.getName();
        }
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getRealName() {
        int index = this.name.indexOf("-_-");
        if (index > 0) {
            return this.name.substring(0, index);
        }
        return this.name;
    }

    private boolean hasCellProperties() {
        return this.backgroundColor != SimpleColor.NONE || this.verticalAlign != null || !this.borders.areVoid() || this.wrap || this.rotating != null;
    }

    public boolean hasParent() {
        return this.parentCellStyle != null;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public TableCellStyle getParentCellStyle() {
        return this.parentCellStyle;
    }

    @Override
    public FontFace getFontFace() {
        return this.textProperties.getFontFace();
    }

    public static enum VerticalAlign {
        BOTTOM("bottom"),
        MIDDLE("middle"),
        TOP("top");

        private final String attrValue;

        private VerticalAlign(String attrValue) {
            this.attrValue = attrValue;
        }
    }

    public static enum Align {
        CENTER("center"),
        JUSTIFY("justify"),
        LEFT("start"),
        RIGHT("end");

        private final String attrValue;

        private Align(String attrValue) {
            this.attrValue = attrValue;
        }
    }
}

