/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement.config;

import com.github.jferard.fastods.odselement.config.ConfigBlock;
import com.github.jferard.fastods.odselement.config.ConfigItem;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntry;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;

public class ConfigItemMapEntrySingleton
implements ConfigItemMapEntry {
    private final ConfigBlock block;
    private final String name;

    public static ConfigItemMapEntrySingleton createSingleton(String name, ConfigBlock configBlock) {
        return new ConfigItemMapEntrySingleton(name, configBlock);
    }

    public static ConfigItemMapEntrySingleton createSingleton(ConfigBlock configBlock) {
        return new ConfigItemMapEntrySingleton(null, configBlock);
    }

    ConfigItemMapEntrySingleton(String name, ConfigBlock block) {
        this.name = name;
        this.block = block;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean add(ConfigBlock block) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConfigBlock put(ConfigBlock block) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(String name) {
        return this.block.getName().equals(name);
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<config:config-item-map-entry");
        if (this.name != null) {
            util.appendEAttribute(appendable, "config:name", this.name);
        }
        appendable.append(">");
        this.block.appendXMLContent(util, appendable);
        appendable.append("</config:config-item-map-entry>");
    }

    @Override
    public Iterator<ConfigBlock> iterator() {
        return Collections.singletonList(this.block).iterator();
    }

    @Override
    public boolean add(String name, String type, String value) {
        throw new UnsupportedOperationException();
    }

    public ConfigBlock getByName(String name) {
        if (this.block.getName().equals(name)) {
            return this.block;
        }
        return null;
    }

    public String set(String name, String value) {
        ConfigBlock block = this.getByName(name);
        if (block instanceof ConfigItem) {
            ConfigItem item = (ConfigItem)block;
            String previousValue = item.getValue();
            item.setValue(value);
            return previousValue;
        }
        return null;
    }

    public String set(String value) {
        if (this.block instanceof ConfigItem) {
            ConfigItem item = (ConfigItem)this.block;
            String previousValue = item.getValue();
            item.setValue(value);
            return previousValue;
        }
        return null;
    }
}

