/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.odselement.config.ConfigBlock;
import com.github.jferard.fastods.odselement.config.ConfigItem;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntry;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntrySet;
import com.github.jferard.fastods.odselement.config.ConfigItemMapIndexed;
import com.github.jferard.fastods.odselement.config.ConfigItemMapNamed;
import com.github.jferard.fastods.odselement.config.ConfigItemSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Settings {
    private final ConfigItemMapEntrySet firstView;
    private final List<ConfigBlock> rootBlocks;
    private final ConfigItemMapNamed tablesMap;
    private final Map<String, ConfigItemMapEntrySet> viewById;

    public static Settings create() {
        ConfigItemSet viewSettings = new ConfigItemSet("ooo:view-settings");
        viewSettings.add(new ConfigItem("VisibleAreaTop", "int", "0"));
        viewSettings.add(new ConfigItem("VisibleAreaLeft", "int", "0"));
        viewSettings.add(new ConfigItem("VisibleAreaWidth", "int", "680"));
        viewSettings.add(new ConfigItem("VisibleAreaHeight", "int", "400"));
        ConfigItemMapEntrySet firstView = ConfigItemMapEntrySet.createSet();
        firstView.add(new ConfigItem("ViewId", "string", "View1"));
        firstView.add(new ConfigItem("ActiveTable", "string", "Tab1"));
        firstView.add(new ConfigItem("HorizontalScrollbarWidth", "int", "270"));
        firstView.add(new ConfigItem("ZoomType", "short", "0"));
        firstView.add(new ConfigItem("ZoomValue", "int", "100"));
        firstView.add(new ConfigItem("PageViewZoomValue", "int", "60"));
        firstView.add(new ConfigItem("ShowPageBreakPreview", "boolean", "false"));
        firstView.add(new ConfigItem("ShowZeroValues", "boolean", "true"));
        firstView.add(new ConfigItem("ShowNotes", "boolean", "true"));
        firstView.add(new ConfigItem("ShowGrid", "boolean", "true"));
        firstView.add(new ConfigItem("GridColor", "long", "12632256"));
        firstView.add(new ConfigItem("ShowPageBreaks", "boolean", "true"));
        firstView.add(new ConfigItem("HasColumnRowHeaders", "boolean", "true"));
        firstView.add(new ConfigItem("HasSheetTabs", "boolean", "true"));
        firstView.add(new ConfigItem("IsOutlineSymbolsSet", "boolean", "true"));
        firstView.add(new ConfigItem("IsSnapToRaster", "boolean", "false"));
        firstView.add(new ConfigItem("RasterIsVisible", "boolean", "false"));
        firstView.add(new ConfigItem("RasterResolutionX", "int", "1000"));
        firstView.add(new ConfigItem("RasterResolutionY", "int", "1000"));
        firstView.add(new ConfigItem("RasterSubdivisionX", "int", "1"));
        firstView.add(new ConfigItem("RasterSubdivisionY", "int", "1"));
        firstView.add(new ConfigItem("IsRasterAxisSynchronized", "boolean", "true"));
        ConfigItemSet configurationSettings = new ConfigItemSet("ooo:configuration-settings");
        configurationSettings.add(new ConfigItem("ShowZeroValues", "boolean", "true"));
        configurationSettings.add(new ConfigItem("ShowNotes", "boolean", "true"));
        configurationSettings.add(new ConfigItem("ShowGrid", "boolean", "true"));
        configurationSettings.add(new ConfigItem("GridColor", "long", "12632256"));
        configurationSettings.add(new ConfigItem("ShowPageBreaks", "boolean", "true"));
        configurationSettings.add(new ConfigItem("LinkUpdateMode", "short", "3"));
        configurationSettings.add(new ConfigItem("HasColumnRowHeaders", "boolean", "true"));
        configurationSettings.add(new ConfigItem("HasSheetTabs", "boolean", "true"));
        configurationSettings.add(new ConfigItem("IsOutlineSymbolsSet", "boolean", "true"));
        configurationSettings.add(new ConfigItem("IsSnapToRaster", "boolean", "false"));
        configurationSettings.add(new ConfigItem("RasterIsVisible", "boolean", "false"));
        configurationSettings.add(new ConfigItem("RasterResolutionX", "int", "1000"));
        configurationSettings.add(new ConfigItem("RasterResolutionY", "int", "1000"));
        configurationSettings.add(new ConfigItem("RasterSubdivisionX", "int", "1"));
        configurationSettings.add(new ConfigItem("RasterSubdivisionY", "int", "1"));
        configurationSettings.add(new ConfigItem("IsRasterAxisSynchronized", "boolean", "true"));
        configurationSettings.add(new ConfigItem("AutoCalculate", "boolean", "true"));
        configurationSettings.add(new ConfigItem("PrinterName", "string", ""));
        configurationSettings.add(new ConfigItem("PrinterSetup", "base64Binary", ""));
        configurationSettings.add(new ConfigItem("ApplyUserData", "boolean", "true"));
        configurationSettings.add(new ConfigItem("CharacterCompressionType", "short", "0"));
        configurationSettings.add(new ConfigItem("IsKernAsianPunctuation", "boolean", "false"));
        configurationSettings.add(new ConfigItem("SaveVersionOnClose", "boolean", "false"));
        configurationSettings.add(new ConfigItem("UpdateFromTemplate", "boolean", "true"));
        configurationSettings.add(new ConfigItem("AllowPrintJobCancel", "boolean", "true"));
        configurationSettings.add(new ConfigItem("LoadReadonly", "boolean", "false"));
        return Settings.create(viewSettings, firstView, configurationSettings);
    }

    static Settings create(ConfigItemSet viewSettings, ConfigItemMapEntrySet firstView, ConfigItemSet configurationSettings) {
        ArrayList<ConfigBlock> rootBlocks = new ArrayList<ConfigBlock>();
        ConfigItemMapIndexed views = new ConfigItemMapIndexed("Views");
        HashMap<String, ConfigItemMapEntrySet> viewById = new HashMap<String, ConfigItemMapEntrySet>();
        ConfigItemMapNamed tablesMap = new ConfigItemMapNamed("Tables");
        return new Settings(rootBlocks, viewSettings, views, viewById, firstView, tablesMap, configurationSettings);
    }

    Settings(List<ConfigBlock> rootBlocks, ConfigItemSet viewSettings, ConfigItemMapIndexed views, Map<String, ConfigItemMapEntrySet> viewById, ConfigItemMapEntrySet firstView, ConfigItemMapNamed tablesMap, ConfigItemSet configurationSettings) {
        this.rootBlocks = rootBlocks;
        this.viewById = viewById;
        this.firstView = firstView;
        this.tablesMap = tablesMap;
        views.add(this.firstView);
        viewSettings.add(views);
        this.rootBlocks.add(viewSettings);
        this.viewById.put(((ConfigItem)firstView.getByName("ViewId")).getValue(), firstView);
        this.firstView.add(this.tablesMap);
        this.rootBlocks.add(configurationSettings);
    }

    public void addTable(Table table) {
        ConfigItemMapEntry configEntry = table.getConfigEntry();
        this.addTableConfig(configEntry);
    }

    public void addTableConfig(ConfigItemMapEntry configEntry) {
        this.tablesMap.put(configEntry);
    }

    public List<ConfigBlock> getRootBlocks() {
        return this.rootBlocks;
    }

    public void setActiveTable(Table table) {
        this.firstView.add(new ConfigItem("ActiveTable", "string", table.getName()));
    }

    public void setTables(List<Table> tables) {
        this.tablesMap.clear();
        for (Table table : tables) {
            this.addTableConfig(table.getConfigEntry());
        }
    }

    public void setViewSetting(String viewId, String item, String value) {
        ConfigItemMapEntrySet view = this.viewById.get(viewId);
        if (view == null) {
            return;
        }
        view.set(item, value);
    }
}

