/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.Color;
import com.github.jferard.fastods.datastyle.DataStyleBuilder;
import com.github.jferard.fastods.datastyle.DecimalStyleBuilder;
import com.github.jferard.fastods.datastyle.FloatStyleBuilder;
import com.github.jferard.fastods.datastyle.NumberStyleBuilder;
import com.github.jferard.fastods.datastyle.ScientificNumberStyle;
import java.util.Locale;

public class ScientificNumberStyleBuilder
implements DataStyleBuilder<ScientificNumberStyle, ScientificNumberStyleBuilder>,
NumberStyleBuilder<ScientificNumberStyle, ScientificNumberStyleBuilder>,
DecimalStyleBuilder<ScientificNumberStyleBuilder> {
    private final FloatStyleBuilder floatStyleBuilder;
    private int minExponentDigits;

    public ScientificNumberStyleBuilder(String name, Locale locale) {
        this.floatStyleBuilder = new FloatStyleBuilder(name, locale);
    }

    @Override
    public ScientificNumberStyle build() {
        return new ScientificNumberStyle(this.floatStyleBuilder.build(), this.minExponentDigits);
    }

    @Override
    public ScientificNumberStyleBuilder decimalPlaces(int decimalPlaces) {
        this.floatStyleBuilder.decimalPlaces(decimalPlaces);
        return this;
    }

    public ScientificNumberStyleBuilder minExponentDigits(int minExponentDigits) {
        this.minExponentDigits = minExponentDigits;
        return this;
    }

    @Override
    public ScientificNumberStyleBuilder groupThousands(boolean grouping) {
        this.floatStyleBuilder.groupThousands(grouping);
        return this;
    }

    @Override
    public ScientificNumberStyleBuilder minIntegerDigits(int minIntegerDigits) {
        this.floatStyleBuilder.minIntegerDigits(minIntegerDigits);
        return this;
    }

    @Override
    public ScientificNumberStyleBuilder negativeValueColor(Color negativeValueColor) {
        this.floatStyleBuilder.negativeValueColor(negativeValueColor);
        return this;
    }

    @Override
    public ScientificNumberStyleBuilder negativeValueRed() {
        this.floatStyleBuilder.negativeValueRed();
        return this;
    }

    @Override
    public ScientificNumberStyleBuilder country(String countryCode) {
        this.floatStyleBuilder.country(countryCode);
        return this;
    }

    @Override
    public ScientificNumberStyleBuilder language(String languageCode) {
        this.floatStyleBuilder.language(languageCode);
        return this;
    }

    @Override
    public ScientificNumberStyleBuilder locale(Locale locale) {
        this.floatStyleBuilder.locale(locale);
        return this;
    }

    @Override
    public ScientificNumberStyleBuilder volatileStyle(boolean volatileStyle) {
        this.floatStyleBuilder.volatileStyle(volatileStyle);
        return this;
    }

    @Override
    public ScientificNumberStyleBuilder visible() {
        this.floatStyleBuilder.visible();
        return this;
    }
}

