/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.TableCell;
import com.github.jferard.fastods.datastyle.BooleanStyle;
import com.github.jferard.fastods.datastyle.CurrencyStyle;
import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.datastyle.DateStyle;
import com.github.jferard.fastods.datastyle.FloatStyle;
import com.github.jferard.fastods.datastyle.PercentageStyle;
import com.github.jferard.fastods.datastyle.TimeStyle;
import java.util.EnumMap;

public class DataStyles {
    private final BooleanStyle booleanDataStyle;
    private final CurrencyStyle currencyDataStyle;
    private final EnumMap<TableCell.Type, DataStyle> dataStyleByType;
    private final DateStyle dateDataStyle;
    private final FloatStyle floatDataStyle;
    private final PercentageStyle percentageDataStyle;
    private final TimeStyle timeDataStyle;

    public DataStyles(BooleanStyle booleanDataStyle, CurrencyStyle currencyDataStyle, DateStyle dateDataStyle, FloatStyle floatDataStyle, PercentageStyle percentageDataStyle, TimeStyle timeDataStyle) {
        if (booleanDataStyle == null || currencyDataStyle == null || dateDataStyle == null || floatDataStyle == null || percentageDataStyle == null || timeDataStyle == null) {
            throw new IllegalArgumentException();
        }
        this.booleanDataStyle = booleanDataStyle;
        this.currencyDataStyle = currencyDataStyle;
        this.dateDataStyle = dateDataStyle;
        this.floatDataStyle = floatDataStyle;
        this.percentageDataStyle = percentageDataStyle;
        this.timeDataStyle = timeDataStyle;
        this.dataStyleByType = new EnumMap(TableCell.Type.class);
        this.dataStyleByType.put(TableCell.Type.BOOLEAN, this.booleanDataStyle);
        this.dataStyleByType.put(TableCell.Type.CURRENCY, this.currencyDataStyle);
        this.dataStyleByType.put(TableCell.Type.DATE, this.dateDataStyle);
        this.dataStyleByType.put(TableCell.Type.FLOAT, this.floatDataStyle);
        this.dataStyleByType.put(TableCell.Type.PERCENTAGE, this.percentageDataStyle);
        this.dataStyleByType.put(TableCell.Type.TIME, this.timeDataStyle);
    }

    public BooleanStyle getBooleanDataStyle() {
        return this.booleanDataStyle;
    }

    public CurrencyStyle getCurrencyDataStyle() {
        return this.currencyDataStyle;
    }

    public DataStyle getDataStyle(TableCell.Type type) {
        return this.dataStyleByType.get((Object)type);
    }

    public DateStyle getDateDataStyle() {
        return this.dateDataStyle;
    }

    public PercentageStyle getPercentageDataStyle() {
        return this.percentageDataStyle;
    }

    public TimeStyle getTimeDataStyle() {
        return this.timeDataStyle;
    }

    public FloatStyle getFloatDataStyle() {
        return this.floatDataStyle;
    }
}

