/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.datastyle.FloatStyle;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class CurrencyStyle
implements DataStyle {
    public static final String SPACE_TEXT = "<number:text> </number:text>";
    private final SymbolPosition currencyPosition;
    private final String currencySymbol;
    private final FloatStyle floatStyle;

    CurrencyStyle(FloatStyle floatStyle, String currencySymbol, SymbolPosition currencyPosition) {
        this.floatStyle = floatStyle;
        this.currencySymbol = currencySymbol;
        this.currencyPosition = currencyPosition;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        StringBuilder number = this.computeCurrency(util);
        this.floatStyle.appendXMLHelper(util, appendable, "currency-style", number);
    }

    private StringBuilder computeCurrency(XMLUtil util) throws IOException {
        StringBuilder number = new StringBuilder();
        if (this.currencyPosition == SymbolPosition.END) {
            this.floatStyle.appendNumberTag(util, number);
            number.append(SPACE_TEXT);
            this.appendCurrencySymbol(util, number);
        } else {
            this.appendCurrencySymbol(util, number);
            this.floatStyle.appendNumberTag(util, number);
        }
        return number;
    }

    private void appendCurrencySymbol(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<number:currency-symbol");
        appendable.append(">").append(util.escapeXMLContent(this.currencySymbol)).append("</number:currency-symbol>");
    }

    @Override
    public String getName() {
        return this.floatStyle.getName();
    }

    @Override
    public boolean isHidden() {
        return this.floatStyle.isHidden();
    }

    @Override
    public void addToElements(OdsElements odsElements) {
        odsElements.addDataStyle(this);
    }

    public static enum SymbolPosition {
        BEGIN,
        END;

    }
}

