/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.OdsFlusher;
import com.github.jferard.fastods.TableRowImpl;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

class RowsFlusher
implements OdsFlusher {
    private final List<TableRowImpl> rows;

    public RowsFlusher(List<TableRowImpl> rows) {
        this.rows = rows;
    }

    @Override
    public void flushInto(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        for (TableRowImpl row : this.rows) {
            if (row == null) {
                throw new IllegalArgumentException();
            }
            row.appendXMLToTable(xmlUtil, writer);
        }
        Collections.fill(this.rows, null);
    }

    @Override
    public boolean isEnd() {
        return false;
    }
}

