/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.ParagraphElement;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.TextStyle;
import com.github.jferard.fastods.util.NamedObject;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;

public final class Link
implements ParagraphElement {
    private final String text;
    private final String href;
    private final TextStyle ts;

    public static Link create(String text, TextStyle ts, NamedObject table) {
        return new Link(text, ts, '#' + table.getName());
    }

    public static Link create(String text, NamedObject table) {
        return new Link(text, null, '#' + table.getName());
    }

    public static Link create(String text, TextStyle ts, String relativeRef) {
        return new Link(text, ts, '#' + relativeRef);
    }

    public static Link create(String text, String relativeRef) {
        return new Link(text, null, '#' + relativeRef);
    }

    public static Link create(String text, TextStyle ts, File file) {
        return new Link(text, ts, file.toURI().toString());
    }

    public static Link create(String text, File file) {
        return new Link(text, null, file.toURI().toString());
    }

    public static Link create(String text, TextStyle ts, URL url) {
        return new Link(text, ts, url.toString());
    }

    public static Link create(String text, URL url) {
        return new Link(text, null, url.toString());
    }

    public static Link create(String text, TextStyle ts, URI uri) {
        return new Link(text, ts, uri.toString());
    }

    public static Link create(String text, URI uri) {
        return new Link(text, null, uri.toString());
    }

    private Link(String text, TextStyle ts, String href) {
        this.text = text;
        this.href = href;
        this.ts = ts;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<text:a");
        if (this.ts != null) {
            util.appendEAttribute(appendable, "text:style-name", this.ts.getName());
        }
        util.appendEAttribute(appendable, "xlink:href", this.href);
        util.appendAttribute(appendable, (CharSequence)"xlink:type", "simple");
        appendable.append(">").append(this.text).append("</text:a>");
    }

    @Override
    public void addEmbeddedStylesFromFooterHeader(StylesContainer stylesContainer) {
        if (this.ts != null) {
            stylesContainer.addStylesFontFaceContainerStyle(this.ts);
        }
    }

    @Override
    public void addEmbeddedStylesFromCell(StylesContainer stylesContainer) {
        if (this.ts != null) {
            stylesContainer.addContentFontFaceContainerStyle(this.ts);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Link)) {
            return false;
        }
        Link other = (Link)o;
        return this.href.equals(other.href) && this.text.equals(other.text);
    }

    public final int hashCode() {
        return 31 * this.href.hashCode() + this.text.hashCode();
    }
}

