/*
 * Decompiled with CFR 0.152.
 */
package smile.vq.hebb;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import smile.math.MathEx;
import smile.vq.hebb.Edge;

public class Neuron
implements Comparable<Neuron>,
Serializable {
    private static final long serialVersionUID = 2L;
    public final double[] w;
    public final List<Edge> edges;
    public transient double distance = Double.MAX_VALUE;
    public double counter;

    public Neuron(double[] w) {
        this(w, 0.0);
    }

    public Neuron(double[] w, double counter) {
        this.w = w;
        this.counter = counter;
        this.edges = new LinkedList<Edge>();
    }

    public void update(double[] x, double eps) {
        for (int i = 0; i < x.length; ++i) {
            int n = i;
            this.w[n] = this.w[n] + eps * (x[i] - this.w[i]);
        }
    }

    public void addEdge(Neuron neighbor) {
        this.addEdge(neighbor, 0);
    }

    public void addEdge(Neuron neighbor, int age) {
        this.edges.add(new Edge(neighbor, age));
    }

    public void removeEdge(Neuron neighbor) {
        Iterator<Edge> iter = this.edges.iterator();
        while (iter.hasNext()) {
            Edge edge = iter.next();
            if (edge.neighbor != neighbor) continue;
            iter.remove();
            return;
        }
    }

    public void setEdgeAge(Neuron neighbor, int age) {
        for (Edge edge : this.edges) {
            if (edge.neighbor != neighbor) continue;
            edge.age = age;
            return;
        }
    }

    public void age() {
        for (Edge edge : this.edges) {
            ++edge.age;
        }
    }

    public void distance(double[] x) {
        this.distance = MathEx.distance((double[])this.w, (double[])x);
    }

    @Override
    public int compareTo(Neuron o) {
        return Double.compare(this.distance, o.distance);
    }
}

