/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import java.util.Arrays;
import java.util.function.BiFunction;
import smile.classification.Classifier;
import smile.classification.DataFrameClassifier;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.math.MathEx;
import smile.regression.DataFrameRegression;
import smile.regression.Regression;
import smile.util.Index;
import smile.validation.ClassificationMetrics;
import smile.validation.RegressionMetrics;
import smile.validation.metric.AUC;
import smile.validation.metric.Accuracy;
import smile.validation.metric.CrossEntropy;
import smile.validation.metric.Error;
import smile.validation.metric.FScore;
import smile.validation.metric.LogLoss;
import smile.validation.metric.MAD;
import smile.validation.metric.MSE;
import smile.validation.metric.MatthewsCorrelation;
import smile.validation.metric.Precision;
import smile.validation.metric.R2;
import smile.validation.metric.RMSE;
import smile.validation.metric.RSS;
import smile.validation.metric.Sensitivity;
import smile.validation.metric.Specificity;

public interface LOOCV {
    public static int[][] of(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid sample size: " + n);
        }
        int[][] train = new int[n][n - 1];
        for (int i = 0; i < n; ++i) {
            int p = 0;
            int j = 0;
            while (j < i) {
                train[i][p++] = j++;
            }
            j = i + 1;
            while (j < n) {
                train[i][p++] = j++;
            }
        }
        return train;
    }

    public static <T, M extends Classifier<T>> ClassificationMetrics classification(T[] x, int[] y, BiFunction<T[], int[], M> trainer) {
        int k = MathEx.unique((int[])y).length;
        int n = x.length;
        int[][] train = LOOCV.of(n);
        int[] prediction = new int[n];
        double[][] posteriori = new double[n][k];
        long fitTime = 0L;
        long scoreTime = 0L;
        boolean soft = false;
        for (int i = 0; i < n; ++i) {
            Object[] trainx = MathEx.slice((Object[])x, (int[])train[i]);
            int[] trainy = MathEx.slice((int[])y, (int[])train[i]);
            long start = System.nanoTime();
            Classifier model = (Classifier)trainer.apply((Object[][])trainx, trainy);
            fitTime += System.nanoTime() - start;
            start = System.nanoTime();
            if (model.soft()) {
                soft = true;
                prediction[i] = model.predict(x[i], posteriori[i]);
            } else {
                prediction[i] = model.predict(x[i]);
            }
            scoreTime += System.nanoTime() - start;
        }
        int error = Error.of(y, prediction);
        double accuracy = Accuracy.of(y, prediction);
        if (soft) {
            if (k == 2) {
                double[] probability = Arrays.stream(posteriori).mapToDouble(p -> p[1]).toArray();
                return new ClassificationMetrics((double)fitTime / ((double)n * 1000000.0), (double)scoreTime / ((double)n * 1000000.0), n, error, accuracy, Sensitivity.of(y, prediction), Specificity.of(y, prediction), Precision.of(y, prediction), FScore.F1.score(y, prediction), MatthewsCorrelation.of(y, prediction), AUC.of(y, probability), LogLoss.of(y, probability), CrossEntropy.of(y, posteriori));
            }
            return new ClassificationMetrics((double)fitTime / ((double)n * 1000000.0), (double)scoreTime / ((double)n * 1000000.0), n, error, accuracy, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, CrossEntropy.of(y, posteriori));
        }
        if (k == 2) {
            return new ClassificationMetrics((double)fitTime / ((double)n * 1000000.0), (double)scoreTime / ((double)n * 1000000.0), n, error, accuracy, Sensitivity.of(y, prediction), Specificity.of(y, prediction), Precision.of(y, prediction), FScore.F1.score(y, prediction), MatthewsCorrelation.of(y, prediction), Double.NaN, Double.NaN, Double.NaN);
        }
        return new ClassificationMetrics((double)fitTime / ((double)n * 1000000.0), (double)scoreTime / ((double)n * 1000000.0), n, error, accuracy, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, CrossEntropy.of(y, posteriori));
    }

    public static ClassificationMetrics classification(Formula formula, DataFrame data, BiFunction<Formula, DataFrame, DataFrameClassifier> trainer) {
        int[] y = formula.y(data).toIntArray();
        int k = MathEx.unique((int[])y).length;
        int n = y.length;
        int[][] train = LOOCV.of(n);
        int[] prediction = new int[n];
        double[][] posteriori = new double[n][k];
        long fitTime = 0L;
        long scoreTime = 0L;
        boolean soft = false;
        for (int i = 0; i < n; ++i) {
            long start = System.nanoTime();
            DataFrameClassifier model = trainer.apply(formula, data.get(Index.of((int[])train[i])));
            fitTime += System.nanoTime() - start;
            start = System.nanoTime();
            if (model.soft()) {
                soft = true;
                prediction[i] = model.predict(data.get(i), posteriori[i]);
            } else {
                prediction[i] = model.predict(data.get(i));
            }
            scoreTime += System.nanoTime() - start;
        }
        int error = Error.of(y, prediction);
        double accuracy = Accuracy.of(y, prediction);
        if (soft) {
            if (k == 2) {
                double[] probability = Arrays.stream(posteriori).mapToDouble(p -> p[1]).toArray();
                return new ClassificationMetrics((double)fitTime / ((double)n * 1000000.0), (double)scoreTime / ((double)n * 1000000.0), n, error, accuracy, Sensitivity.of(y, prediction), Specificity.of(y, prediction), Precision.of(y, prediction), FScore.F1.score(y, prediction), MatthewsCorrelation.of(y, prediction), AUC.of(y, probability), LogLoss.of(y, probability), CrossEntropy.of(y, posteriori));
            }
            return new ClassificationMetrics((double)fitTime / ((double)n * 1000000.0), (double)scoreTime / ((double)n * 1000000.0), n, error, accuracy, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, CrossEntropy.of(y, posteriori));
        }
        if (k == 2) {
            return new ClassificationMetrics((double)fitTime / ((double)n * 1000000.0), (double)scoreTime / ((double)n * 1000000.0), n, error, accuracy, Sensitivity.of(y, prediction), Specificity.of(y, prediction), Precision.of(y, prediction), FScore.F1.score(y, prediction), MatthewsCorrelation.of(y, prediction), Double.NaN, Double.NaN, Double.NaN);
        }
        return new ClassificationMetrics((double)fitTime / ((double)n * 1000000.0), (double)scoreTime / ((double)n * 1000000.0), n, error, accuracy, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, CrossEntropy.of(y, posteriori));
    }

    public static <T, M extends Regression<T>> RegressionMetrics regression(T[] x, double[] y, BiFunction<T[], double[], M> trainer) {
        int n = x.length;
        int[][] train = LOOCV.of(n);
        double[] prediction = new double[n];
        long fitTime = 0L;
        long scoreTime = 0L;
        for (int i = 0; i < n; ++i) {
            Object[] trainx = MathEx.slice((Object[])x, (int[])train[i]);
            double[] trainy = MathEx.slice((double[])y, (int[])train[i]);
            long start = System.nanoTime();
            Regression model = (Regression)trainer.apply((Object[][])trainx, trainy);
            fitTime += System.nanoTime() - start;
            start = System.nanoTime();
            prediction[i] = model.predict(x[i]);
            scoreTime += System.nanoTime() - start;
        }
        return new RegressionMetrics((double)fitTime / ((double)n * 1000000.0), (double)scoreTime / ((double)n * 1000000.0), n, RSS.of(y, prediction), MSE.of(y, prediction), RMSE.of(y, prediction), MAD.of(y, prediction), R2.of(y, prediction));
    }

    public static RegressionMetrics regression(Formula formula, DataFrame data, BiFunction<Formula, DataFrame, DataFrameRegression> trainer) {
        int n = data.size();
        int[][] train = LOOCV.of(n);
        double[] y = formula.y(data).toDoubleArray();
        double[] prediction = new double[n];
        long fitTime = 0L;
        long scoreTime = 0L;
        for (int i = 0; i < n; ++i) {
            long start = System.nanoTime();
            DataFrameRegression model = trainer.apply(formula, data.get(Index.of((int[])train[i])));
            fitTime += System.nanoTime() - start;
            start = System.nanoTime();
            prediction[i] = model.predict(data.get(i));
            scoreTime += System.nanoTime() - start;
        }
        return new RegressionMetrics((double)fitTime / ((double)n * 1000000.0), (double)scoreTime / ((double)n * 1000000.0), n, RSS.of(y, prediction), MSE.of(y, prediction), RMSE.of(y, prediction), MAD.of(y, prediction), R2.of(y, prediction));
    }
}

