/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.selection;

import java.util.stream.IntStream;
import smile.data.DataFrame;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.math.MathEx;
import smile.stat.distribution.FDistribution;
import smile.stat.hypothesis.FTest;

public record FRegression(String feature, double statistic, double pvalue, boolean categorical) implements Comparable<FRegression>
{
    @Override
    public int compareTo(FRegression other) {
        return Double.compare(this.statistic, other.statistic);
    }

    @Override
    public String toString() {
        return String.format("FRegression(%s, %.4f, %.4g)", this.feature, this.statistic, this.pvalue);
    }

    public static FRegression[] fit(DataFrame data, String response) {
        double[] y = data.column(response).toDoubleArray();
        StructType schema = data.schema();
        return (FRegression[])IntStream.range(0, schema.length()).filter(i -> !schema.field(i).name().equals(response)).mapToObj(i -> {
            StructField field = schema.field(i);
            if (field.isNumeric()) {
                double[] x = data.column(i).toDoubleArray();
                double cor = MathEx.cor((double[])x, (double[])y);
                double r2 = cor * cor;
                int df = y.length - 2;
                FDistribution dist = new FDistribution(1, df);
                double F = r2 / (1.0 - r2) * (double)df;
                double pvalue = 1.0 - dist.cdf(F);
                return new FRegression(field.name(), F, pvalue, false);
            }
            int[] x = data.column(i).toIntArray();
            FTest test = FTest.test((int[])x, (double[])y);
            return new FRegression(field.name(), test.f(), test.pvalue(), true);
        }).toArray(FRegression[]::new);
    }
}

