/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.imputation;

import java.util.Objects;
import smile.clustering.CentroidClustering;
import smile.clustering.KMedoids;
import smile.data.AbstractTuple;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.transform.Transform;
import smile.feature.imputation.SimpleImputer;
import smile.math.distance.Distance;

public class KMedoidsImputer
implements Transform {
    private final CentroidClustering<Tuple, Tuple> kmedoids;

    public KMedoidsImputer(CentroidClustering<Tuple, Tuple> kmedoids) {
        this.kmedoids = kmedoids;
    }

    public Tuple apply(final Tuple x) {
        if (!SimpleImputer.hasMissing(x)) {
            return x;
        }
        final Tuple medioid = this.kmedoids.center(this.kmedoids.predict(x));
        return new AbstractTuple(this, x.schema()){
            final /* synthetic */ KMedoidsImputer this$0;
            {
                KMedoidsImputer kMedoidsImputer = this$0;
                Objects.requireNonNull(kMedoidsImputer);
                this.this$0 = kMedoidsImputer;
                super(arg0);
            }

            public Object get(int i) {
                Object xi = x.get(i);
                return SimpleImputer.isMissing(xi) ? medioid.get(i) : xi;
            }
        };
    }

    public static KMedoidsImputer fit(DataFrame data, Distance<Tuple> distance, int k) {
        Tuple[] tuples = new Tuple[data.size()];
        for (int i = 0; i < tuples.length; ++i) {
            tuples[i] = data.get(i);
        }
        CentroidClustering<Tuple, Tuple> kmedoids = KMedoids.fit(tuples, distance, k);
        return new KMedoidsImputer(kmedoids);
    }
}

