/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import java.util.Arrays;
import java.util.stream.DoubleStream;
import smile.math.kernel.MercerKernel;

public class SumKernel<T>
implements MercerKernel<T> {
    private final MercerKernel<T> k1;
    private final MercerKernel<T> k2;

    public SumKernel(MercerKernel<T> k1, MercerKernel<T> k2) {
        this.k1 = k1;
        this.k2 = k2;
    }

    @Override
    public double k(T x, T y) {
        return this.k1.k(x, y) + this.k2.k(x, y);
    }

    @Override
    public double[] kg(T x, T y) {
        double[] kg1 = this.k1.kg(x, y);
        double[] kg2 = this.k2.kg(x, y);
        double[] kg = new double[kg1.length + kg2.length - 1];
        kg[0] = kg1[0] + kg2[0];
        System.arraycopy(kg1, 1, kg, 1, kg1.length - 1);
        System.arraycopy(kg2, 1, kg, kg1.length, kg2.length - 1);
        return kg;
    }

    @Override
    public MercerKernel<T> of(double[] params) {
        int n1 = this.k1.lo().length;
        return new SumKernel<T>(this.k1.of(params), this.k2.of(Arrays.copyOfRange(params, n1, params.length)));
    }

    @Override
    public double[] hyperparameters() {
        return DoubleStream.concat(Arrays.stream(this.k1.hyperparameters()), Arrays.stream(this.k2.hyperparameters())).toArray();
    }

    @Override
    public double[] lo() {
        return DoubleStream.concat(Arrays.stream(this.k1.lo()), Arrays.stream(this.k2.lo())).toArray();
    }

    @Override
    public double[] hi() {
        return DoubleStream.concat(Arrays.stream(this.k1.hi()), Arrays.stream(this.k2.hi())).toArray();
    }
}

