/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class ArgumentsParser {
    private final List<String> additionalArguments;

    ArgumentsParser() {
        this(Collections.emptyList());
    }

    ArgumentsParser(List<String> additionalArguments) {
        this.additionalArguments = additionalArguments;
    }

    List<String> parse(String args) {
        if (args == null || "null".equals(args) || args.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<String> arguments = new LinkedList<String>();
        StringBuilder argumentBuilder = new StringBuilder();
        Character quote = null;
        int l = args.length();
        for (int i = 0; i < l; ++i) {
            char c = args.charAt(i);
            if (Character.isWhitespace(c) && quote == null) {
                ArgumentsParser.addArgument(argumentBuilder, arguments);
                continue;
            }
            if (c == '\"' || c == '\'') {
                Character currentQuote = Character.valueOf(c);
                if (quote == null) {
                    quote = currentQuote;
                } else if (quote.equals(currentQuote)) {
                    quote = null;
                }
            }
            argumentBuilder.append(c);
        }
        ArgumentsParser.addArgument(argumentBuilder, arguments);
        for (String argument : this.additionalArguments) {
            ArgumentsParser.addArgument(argument, arguments);
        }
        return new ArrayList<String>(arguments);
    }

    private static void addArgument(StringBuilder argumentBuilder, List<String> arguments) {
        if (argumentBuilder.length() > 0) {
            String argument = argumentBuilder.toString();
            ArgumentsParser.addArgument(argument, arguments);
            argumentBuilder.setLength(0);
        }
    }

    private static void addArgument(String argument, List<String> arguments) {
        if (!arguments.contains(argument)) {
            arguments.add(argument);
        }
    }
}

