/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.util;

import com.github.cukedoctor.util.Assert;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileUtil {
    public static Logger log = Logger.getLogger(FileUtil.class.getName());
    public static final Pattern ADOC_FILE_EXTENSION = Pattern.compile("([^\\s]+(\\.(?i)(ad|adoc|asciidoc|asc))$)");

    public static String findJsonFile(String path) {
        File f;
        if (path == null) {
            path = "";
        }
        if ((f = new File(path)).exists()) {
            return f.getAbsolutePath();
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return Paths.get(path.trim(), new String[0]).toAbsolutePath().toString();
    }

    public static List<String> findJsonFiles(String startDir) {
        return FileUtil.findFiles(startDir, ".json");
    }

    public static List<String> findFiles(String startDir, String suffix) {
        return FileUtil.findFiles(startDir, suffix, false);
    }

    public static List<String> findFiles(String startDir, String suffix, boolean singleResult) {
        return FileUtil.findFiles(startDir, suffix, singleResult, null);
    }

    public static List<String> findFiles(String startDir, final String suffix, final boolean singleResult, final String relativePath) {
        Path startPath;
        final ArrayList<String> foundPaths = new ArrayList<String>();
        if (startDir == null) {
            startDir = "";
        }
        if (!Files.exists(startPath = Paths.get(startDir, new String[0]), new LinkOption[0])) {
            if (startDir.startsWith("/")) {
                startDir = startDir.substring(1);
                startPath = Paths.get(startDir, new String[0]);
            }
            if (!Files.exists(startPath, new LinkOption[0])) {
                startPath = Paths.get("", new String[0]);
            }
        }
        try {
            Files.walkFileTree(Paths.get(startDir, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = file.getFileName().toString();
                    if (fileName.endsWith(suffix)) {
                        if (Assert.hasText(relativePath)) {
                            boolean isFile = file.toFile().isFile();
                            Path computedPath = Paths.get(relativePath, new String[0]).relativize(isFile ? file.getParent().toAbsolutePath() : file.toAbsolutePath());
                            if (isFile) {
                                foundPaths.add(computedPath.toString() + "/" + file.toFile().getName());
                            } else {
                                foundPaths.add(computedPath.toString());
                            }
                        } else {
                            foundPaths.add(file.toAbsolutePath().toString());
                        }
                        if (singleResult) {
                            return FileVisitResult.TERMINATE;
                        }
                    }
                    if (attrs.isDirectory()) {
                        return super.visitFile(file, attrs);
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
            });
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Problems scanning " + suffix + " files in path:" + startDir, e);
        }
        return foundPaths;
    }

    public static File saveFile(String name, String data) {
        String fullyQualifiedName;
        if (name == null) {
            name = "";
        }
        if (!new File(fullyQualifiedName = name).isAbsolute()) {
            fullyQualifiedName = Paths.get("", new String[0]).toAbsolutePath().toString() + "/" + name;
        }
        try {
            if (fullyQualifiedName.contains("/")) {
                File f = new File(fullyQualifiedName.substring(0, fullyQualifiedName.lastIndexOf("/")));
                f.mkdirs();
            }
            File file = new File(fullyQualifiedName);
            file.createNewFile();
            FileUtils.write((File)file, (CharSequence)data, (String)"UTF-8");
            log.info("Wrote: " + file.getAbsolutePath());
            return file;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not create file " + name, e);
            return null;
        }
    }

    public static File loadFile(String path) {
        File f;
        if (path == null) {
            path = "/";
        }
        if ((f = new File(path)).exists()) {
            return f.getAbsoluteFile();
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return new File(Paths.get("", new String[0]).toAbsolutePath().toString() + path.trim());
    }

    public static boolean removeFile(String path) {
        File fileToRemove = FileUtil.loadFile(path);
        return fileToRemove.delete();
    }

    public static File copyFileFromClassPath(String source, String dest) {
        if (source != null && dest != null) {
            try {
                InputStream in = FileUtil.class.getResourceAsStream(source);
                return FileUtil.saveFile(dest, IOUtils.toString((InputStream)in));
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Could not copy source file: " + source + " to dest file: " + dest, e);
            }
        }
        return null;
    }

    public static File copyFile(String source, String dest) {
        if (source != null && dest != null) {
            File sourcefile = new File(source);
            if (!sourcefile.exists()) {
                log.warning(String.format("File %s not found.", sourcefile.getAbsolutePath()));
                return null;
            }
            try {
                FileInputStream in = new FileInputStream(source);
                return FileUtil.saveFile(dest, IOUtils.toString((InputStream)in));
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Could not copy source file: " + source + " to dest file: " + dest, e);
            }
        }
        return null;
    }
}

