/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.github.cukedoctor.api.model.Comment;
import com.github.cukedoctor.api.model.DocString;
import com.github.cukedoctor.api.model.Match;
import com.github.cukedoctor.api.model.Output;
import com.github.cukedoctor.api.model.Result;
import com.github.cukedoctor.api.model.Row;
import com.github.cukedoctor.api.model.Status;
import com.github.cukedoctor.util.Assert;
import java.util.List;
import java.util.logging.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Step {
    private String name;
    private String keyword;
    private String line;
    private Result result;
    private Row[] rows;
    private Match match;
    private List<Comment> comments;
    @JsonProperty(value="doc_string")
    private DocString docString;
    private List<Output> output;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public Row[] getRows() {
        return this.rows;
    }

    public void setRows(Row[] rows) {
        this.rows = rows;
    }

    public Match getMatch() {
        return this.match;
    }

    public void setMatch(Match match) {
        this.match = match;
    }

    @JsonRawValue
    public List<Output> getOutput() {
        return this.output;
    }

    public void setOutput(List<Output> output) {
        this.output = output;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public DocString getDocString() {
        return this.docString;
    }

    public void setDocString(DocString docString) {
        this.docString = docString;
    }

    public Long getDuration() {
        if (this.result == null) {
            return 1L;
        }
        return this.result.getDuration();
    }

    public Status getStatus() {
        if (this.result == null || this.result.getStatus() == null) {
            Logger.getLogger(this.getClass().getName()).warning("Line " + this.line + " : Step is missing Result: " + this.keyword + " : " + this.name);
            return Status.missing;
        }
        return this.result.getStatus();
    }

    public boolean isFailling() {
        return this.getStatus().equals((Object)Status.failed);
    }

    public boolean isMissing() {
        return this.getStatus().equals((Object)Status.missing);
    }

    public boolean isPassing() {
        return this.getStatus().equals((Object)Status.passed);
    }

    public boolean isPendding() {
        return this.getStatus().equals((Object)Status.pending);
    }

    public boolean isUndefined() {
        return this.getStatus().equals((Object)Status.undefined);
    }

    public boolean isSkipped() {
        return this.getStatus().equals((Object)Status.skipped);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Step step = (Step)o;
        if (!this.name.equals(step.name)) {
            return false;
        }
        return this.match.equals(step.match);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean hasComments() {
        return Assert.hasElements(this.comments);
    }

    public boolean hasDiscreteComment() {
        if (this.hasComments()) {
            for (Comment comment : this.comments) {
                if (!comment.getValue().contains("cukedoctor-discrete")) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    public boolean hasOutput() {
        return this.output != null && !this.output.isEmpty();
    }
}

