/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.github.cukedoctor.api.model.Example;
import com.github.cukedoctor.api.model.Status;
import com.github.cukedoctor.api.model.Step;
import com.github.cukedoctor.api.model.Tag;
import com.github.cukedoctor.api.model.Type;
import com.github.cukedoctor.util.Assert;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Scenario {
    private String name;
    private String description;
    private String keyword;
    private List<Step> steps;
    private List<Tag> tags;
    private Type type;
    private List<Example> examples;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public List<Example> getExamples() {
        return this.examples;
    }

    public void setExamples(List<Example> examples) {
        this.examples = examples;
    }

    public boolean isBackground() {
        return Type.background.equals((Object)this.type);
    }

    public Status getStatus() {
        if (this.hasSteps()) {
            for (Step step : this.steps) {
                if (step.isPassing()) continue;
                return Status.failed;
            }
        }
        return Status.passed;
    }

    public boolean hasSteps() {
        return this.steps != null && !this.steps.isEmpty();
    }

    public boolean hasExamples() {
        return this.examples != null && !this.examples.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scenario element = (Scenario)o;
        if (!this.name.equals(element.name)) {
            return false;
        }
        return this.type == element.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public boolean hasIgnoreDocsTag() {
        if (this.hasTags()) {
            for (Tag tag : this.tags) {
                if (!"@skipDocs".equalsIgnoreCase(tag.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public Step getStepByName(String stepName) {
        if (Assert.hasText(stepName) && this.hasSteps()) {
            for (Step step : this.steps) {
                if (!step.getName().trim().equals(stepName.trim())) continue;
                return step;
            }
        }
        return null;
    }
}

