
/*
 * Copyright (c) 2017 Dmitry Avtonomov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package umich.ms.fileio.filetypes.mzidentml.jaxb.standard;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;


/**
 * Other classes in the model can be specified as sub-classes, inheriting from Identifiable.
 * Identifiable gives classes a unique identifier within the scope and a name that need not be
 * unique.
 *
 * <p>Java class for IdentifiableType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="IdentifiableType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;attribute name="id" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "IdentifiableType")
@XmlSeeAlso({
    MzIdentMLType.class,
    DBSequenceType.class,
    PeptideEvidenceType.class,
    SpectrumIdentificationProtocolType.class,
    ProteinDetectionProtocolType.class,
    TranslationTableType.class,
    MassTableType.class,
    SpectrumIdentificationItemType.class,
    EnzymeType.class,
    ProtocolApplicationType.class,
    SpectrumIdentificationListType.class,
    ProviderType.class,
    PeptideType.class,
    SpectrumIdentificationResultType.class,
    ProteinAmbiguityGroupType.class,
    MeasureType.class,
    ProteinDetectionListType.class,
    BibliographicReferenceType.class,
    AnalysisSoftwareType.class,
    ProteinDetectionHypothesisType.class,
    ExternalDataType.class,
    AbstractContactType.class,
    SampleType.class
})
public abstract class IdentifiableType {

  @XmlAttribute(name = "id", required = true)
  protected String id;
  @XmlAttribute(name = "name")
  protected String name;

  /**
   * Gets the value of the id property.
   *
   * @return possible object is {@link String }
   */
  public String getId() {
    return id;
  }

  /**
   * Sets the value of the id property.
   *
   * @param value allowed object is {@link String }
   */
  public void setId(String value) {
    this.id = value;
  }

  /**
   * Gets the value of the name property.
   *
   * @return possible object is {@link String }
   */
  public String getName() {
    return name;
  }

  /**
   * Sets the value of the name property.
   *
   * @param value allowed object is {@link String }
   */
  public void setName(String value) {
    this.name = value;
  }

}
