
/*
 * Copyright (c) 2017 Dmitry Avtonomov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package umich.ms.fileio.filetypes.mzml.jaxb;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;


/**
 * This object contains factory methods for each Java content interface and Java element interface
 * generated in the umich.ms.fileio.filetypes.mzml.jaxb package.
 * <p>An ObjectFactory allows you to programatically
 * construct new instances of the Java representation for XML content. The Java representation of
 * XML content can consist of schema derived interfaces and classes representing the binding of
 * schema type definitions, element declarations and model groups.  Factory methods for each of
 * these are provided in this class.
 */
@XmlRegistry
public class ObjectFactory {

  private final static QName _MzML_QNAME = new QName("http://psi.hupo.org/ms/mzml", "mzML");

  /**
   * Create a new ObjectFactory that can be used to create new instances of schema derived classes
   * for package: umich.ms.fileio.filetypes.mzml.jaxb
   */
  public ObjectFactory() {
  }

  /**
   * Create an instance of {@link MzMLType }
   */
  public MzMLType createMzMLType() {
    return new MzMLType();
  }

  /**
   * Create an instance of {@link AnalyzerComponentType }
   */
  public AnalyzerComponentType createAnalyzerComponentType() {
    return new AnalyzerComponentType();
  }

  /**
   * Create an instance of {@link DataProcessingListType }
   */
  public DataProcessingListType createDataProcessingListType() {
    return new DataProcessingListType();
  }

  /**
   * Create an instance of {@link SpectrumListType }
   */
  public SpectrumListType createSpectrumListType() {
    return new SpectrumListType();
  }

  /**
   * Create an instance of {@link BinaryDataArrayListType }
   */
  public BinaryDataArrayListType createBinaryDataArrayListType() {
    return new BinaryDataArrayListType();
  }

  /**
   * Create an instance of {@link PrecursorListType }
   */
  public PrecursorListType createPrecursorListType() {
    return new PrecursorListType();
  }

  /**
   * Create an instance of {@link SourceFileRefType }
   */
  public SourceFileRefType createSourceFileRefType() {
    return new SourceFileRefType();
  }

  /**
   * Create an instance of {@link ScanWindowListType }
   */
  public ScanWindowListType createScanWindowListType() {
    return new ScanWindowListType();
  }

  /**
   * Create an instance of {@link CVListType }
   */
  public CVListType createCVListType() {
    return new CVListType();
  }

  /**
   * Create an instance of {@link ReferenceableParamGroupListType }
   */
  public ReferenceableParamGroupListType createReferenceableParamGroupListType() {
    return new ReferenceableParamGroupListType();
  }

  /**
   * Create an instance of {@link SoftwareType }
   */
  public SoftwareType createSoftwareType() {
    return new SoftwareType();
  }

  /**
   * Create an instance of {@link DetectorComponentType }
   */
  public DetectorComponentType createDetectorComponentType() {
    return new DetectorComponentType();
  }

  /**
   * Create an instance of {@link ReferenceableParamGroupType }
   */
  public ReferenceableParamGroupType createReferenceableParamGroupType() {
    return new ReferenceableParamGroupType();
  }

  /**
   * Create an instance of {@link ChromatogramListType }
   */
  public ChromatogramListType createChromatogramListType() {
    return new ChromatogramListType();
  }

  /**
   * Create an instance of {@link DataProcessingType }
   */
  public DataProcessingType createDataProcessingType() {
    return new DataProcessingType();
  }

  /**
   * Create an instance of {@link RunType }
   */
  public RunType createRunType() {
    return new RunType();
  }

  /**
   * Create an instance of {@link SourceFileListType }
   */
  public SourceFileListType createSourceFileListType() {
    return new SourceFileListType();
  }

  /**
   * Create an instance of {@link UserParamType }
   */
  public UserParamType createUserParamType() {
    return new UserParamType();
  }

  /**
   * Create an instance of {@link SourceComponentType }
   */
  public SourceComponentType createSourceComponentType() {
    return new SourceComponentType();
  }

  /**
   * Create an instance of {@link ScanSettingsType }
   */
  public ScanSettingsType createScanSettingsType() {
    return new ScanSettingsType();
  }

  /**
   * Create an instance of {@link SourceFileType }
   */
  public SourceFileType createSourceFileType() {
    return new SourceFileType();
  }

  /**
   * Create an instance of {@link CVParamType }
   */
  public CVParamType createCVParamType() {
    return new CVParamType();
  }

  /**
   * Create an instance of {@link ComponentListType }
   */
  public ComponentListType createComponentListType() {
    return new ComponentListType();
  }

  /**
   * Create an instance of {@link SelectedIonListType }
   */
  public SelectedIonListType createSelectedIonListType() {
    return new SelectedIonListType();
  }

  /**
   * Create an instance of {@link TargetListType }
   */
  public TargetListType createTargetListType() {
    return new TargetListType();
  }

  /**
   * Create an instance of {@link ProductListType }
   */
  public ProductListType createProductListType() {
    return new ProductListType();
  }

  /**
   * Create an instance of {@link ScanListType }
   */
  public ScanListType createScanListType() {
    return new ScanListType();
  }

  /**
   * Create an instance of {@link FileDescriptionType }
   */
  public FileDescriptionType createFileDescriptionType() {
    return new FileDescriptionType();
  }

  /**
   * Create an instance of {@link ComponentType }
   */
  public ComponentType createComponentType() {
    return new ComponentType();
  }

  /**
   * Create an instance of {@link InstrumentConfigurationListType }
   */
  public InstrumentConfigurationListType createInstrumentConfigurationListType() {
    return new InstrumentConfigurationListType();
  }

  /**
   * Create an instance of {@link ParamGroupType }
   */
  public ParamGroupType createParamGroupType() {
    return new ParamGroupType();
  }

  /**
   * Create an instance of {@link SampleListType }
   */
  public SampleListType createSampleListType() {
    return new SampleListType();
  }

  /**
   * Create an instance of {@link ProductType }
   */
  public ProductType createProductType() {
    return new ProductType();
  }

  /**
   * Create an instance of {@link SourceFileRefListType }
   */
  public SourceFileRefListType createSourceFileRefListType() {
    return new SourceFileRefListType();
  }

  /**
   * Create an instance of {@link BinaryDataArrayType }
   */
  public BinaryDataArrayType createBinaryDataArrayType() {
    return new BinaryDataArrayType();
  }

  /**
   * Create an instance of {@link ChromatogramType }
   */
  public ChromatogramType createChromatogramType() {
    return new ChromatogramType();
  }

  /**
   * Create an instance of {@link ScanSettingsListType }
   */
  public ScanSettingsListType createScanSettingsListType() {
    return new ScanSettingsListType();
  }

  /**
   * Create an instance of {@link ScanType }
   */
  public ScanType createScanType() {
    return new ScanType();
  }

  /**
   * Create an instance of {@link PrecursorType }
   */
  public PrecursorType createPrecursorType() {
    return new PrecursorType();
  }

  /**
   * Create an instance of {@link ReferenceableParamGroupRefType }
   */
  public ReferenceableParamGroupRefType createReferenceableParamGroupRefType() {
    return new ReferenceableParamGroupRefType();
  }

  /**
   * Create an instance of {@link SoftwareRefType }
   */
  public SoftwareRefType createSoftwareRefType() {
    return new SoftwareRefType();
  }

  /**
   * Create an instance of {@link CVType }
   */
  public CVType createCVType() {
    return new CVType();
  }

  /**
   * Create an instance of {@link SoftwareListType }
   */
  public SoftwareListType createSoftwareListType() {
    return new SoftwareListType();
  }

  /**
   * Create an instance of {@link ProcessingMethodType }
   */
  public ProcessingMethodType createProcessingMethodType() {
    return new ProcessingMethodType();
  }

  /**
   * Create an instance of {@link SampleType }
   */
  public SampleType createSampleType() {
    return new SampleType();
  }

  /**
   * Create an instance of {@link SpectrumType }
   */
  public SpectrumType createSpectrumType() {
    return new SpectrumType();
  }

  /**
   * Create an instance of {@link InstrumentConfigurationType }
   */
  public InstrumentConfigurationType createInstrumentConfigurationType() {
    return new InstrumentConfigurationType();
  }

  /**
   * Create an instance of {@link JAXBElement }{@code <}{@link MzMLType }{@code >}}
   */
  @XmlElementDecl(namespace = "http://psi.hupo.org/ms/mzml", name = "mzML")
  public JAXBElement<MzMLType> createMzML(MzMLType value) {
    return new JAXBElement<MzMLType>(_MzML_QNAME, MzMLType.class, null, value);
  }

}
