
/*
 * Copyright (c) 2017 Dmitry Avtonomov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package umich.ms.fileio.filetypes.mzidentml.jaxb.standard;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;


/**
 * All identifications made from searching one spectrum. For PMF data, all peptide identifications
 * will be listed underneath as SpectrumIdentificationItems. For MS/MS data, there will be ranked
 * SpectrumIdentificationItems corresponding to possible different peptide IDs.
 *
 * <p>Java class for SpectrumIdentificationResultType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="SpectrumIdentificationResultType">
 *   &lt;complexContent>
 *     &lt;extension base="{http://psidev.info/psi/pi/mzIdentML/1.2}IdentifiableType">
 *       &lt;sequence>
 *         &lt;element name="SpectrumIdentificationItem" type="{http://psidev.info/psi/pi/mzIdentML/1.2}SpectrumIdentificationItemType" maxOccurs="unbounded"/>
 *         &lt;group ref="{http://psidev.info/psi/pi/mzIdentML/1.2}ParamGroup" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="spectrumID" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="spectraData_ref" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SpectrumIdentificationResultType", propOrder = {
    "spectrumIdentificationItem",
    "paramGroup"
})
public class SpectrumIdentificationResultType
    extends IdentifiableType {

  @XmlElement(name = "SpectrumIdentificationItem", required = true)
  protected List<SpectrumIdentificationItemType> spectrumIdentificationItem;
  @XmlElements({
      @XmlElement(name = "cvParam", type = CVParamType.class),
      @XmlElement(name = "userParam", type = UserParamType.class)
  })
  protected List<AbstractParamType> paramGroup;
  @XmlAttribute(name = "spectrumID", required = true)
  protected String spectrumID;
  @XmlAttribute(name = "spectraData_ref", required = true)
  protected String spectraDataRef;

  /**
   * Gets the value of the spectrumIdentificationItem property.
   *
   * <p>
   * This accessor method returns a reference to the live list, not a snapshot. Therefore any
   * modification you make to the returned list will be present inside the JAXB object. This is why
   * there is not a <CODE>set</CODE> method for the spectrumIdentificationItem property.
   *
   * <p>
   * For example, to add a new item, do as follows:
   * <pre>
   *    getSpectrumIdentificationItem().add(newItem);
   * </pre>
   *
   *
   * <p>
   * Objects of the following type(s) are allowed in the list {@link SpectrumIdentificationItemType
   * }
   */
  public List<SpectrumIdentificationItemType> getSpectrumIdentificationItem() {
    if (spectrumIdentificationItem == null) {
      spectrumIdentificationItem = new ArrayList<SpectrumIdentificationItemType>(1);
    }
    return this.spectrumIdentificationItem;
  }

  /**
   * Scores or parameters associated with the SpectrumIdentificationResult (i.e the set of
   * SpectrumIdentificationItems derived from one spectrum) e.g. the number of peptide sequences
   * within the parent tolerance for this spectrum. Gets the value of the paramGroup property.
   *
   * <p>
   * This accessor method returns a reference to the live list, not a snapshot. Therefore any
   * modification you make to the returned list will be present inside the JAXB object. This is why
   * there is not a <CODE>set</CODE> method for the paramGroup property.
   *
   * <p>
   * For example, to add a new item, do as follows:
   * <pre>
   *    getParamGroup().add(newItem);
   * </pre>
   *
   *
   * <p>
   * Objects of the following type(s) are allowed in the list {@link CVParamType } {@link
   * UserParamType }
   */
  public List<AbstractParamType> getParamGroup() {
    if (paramGroup == null) {
      paramGroup = new ArrayList<AbstractParamType>(1);
    }
    return this.paramGroup;
  }

  /**
   * Gets the value of the spectrumID property.
   *
   * @return possible object is {@link String }
   */
  public String getSpectrumID() {
    return spectrumID;
  }

  /**
   * Sets the value of the spectrumID property.
   *
   * @param value allowed object is {@link String }
   */
  public void setSpectrumID(String value) {
    this.spectrumID = value;
  }

  /**
   * Gets the value of the spectraDataRef property.
   *
   * @return possible object is {@link String }
   */
  public String getSpectraDataRef() {
    return spectraDataRef;
  }

  /**
   * Sets the value of the spectraDataRef property.
   *
   * @param value allowed object is {@link String }
   */
  public void setSpectraDataRef(String value) {
    this.spectraDataRef = value;
  }

}
