/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.h2.mvstore.DataUtils;

public class CacheLongKeyLIRS<V> {
    private long maxMemory;
    private int averageMemory;
    private final Segment<V>[] segments;
    private final int segmentCount;
    private final int segmentShift;
    private final int segmentMask;
    private final int stackMoveDistance;

    public CacheLongKeyLIRS(int n) {
        this(n, 1, 16, n / 100);
    }

    public CacheLongKeyLIRS(long l, int n, int n2, int n3) {
        this.setMaxMemory(l);
        this.setAverageMemory(n);
        DataUtils.checkArgument(Integer.bitCount(n2) == 1, "The segment count must be a power of 2, is {0}", n2);
        this.segmentCount = n2;
        this.segmentMask = n2 - 1;
        this.stackMoveDistance = n3;
        this.segments = new Segment[n2];
        this.clear();
        this.segmentShift = Integer.numberOfTrailingZeros(this.segments[0].entries.length);
    }

    public void clear() {
        long l = Math.max(1L, this.maxMemory / (long)this.segmentCount);
        for (int i = 0; i < this.segmentCount; ++i) {
            this.segments[i] = new Segment(l, this.averageMemory, this.stackMoveDistance);
        }
    }

    private Entry<V> find(long l) {
        int n = CacheLongKeyLIRS.getHash(l);
        return this.getSegment(n).find(l, n);
    }

    public boolean containsKey(long l) {
        int n = CacheLongKeyLIRS.getHash(l);
        return this.getSegment(n).containsKey(l, n);
    }

    public V peek(long l) {
        Entry<V> entry = this.find(l);
        return entry == null ? null : (V)entry.value;
    }

    public V put(long l, V v) {
        return this.put(l, v, this.sizeOf(v));
    }

    public V put(long l, V v, int n) {
        int n2 = CacheLongKeyLIRS.getHash(l);
        return this.getSegment(n2).put(l, n2, v, n);
    }

    protected int sizeOf(V v) {
        return this.averageMemory;
    }

    public V remove(long l) {
        int n = CacheLongKeyLIRS.getHash(l);
        return this.getSegment(n).remove(l, n);
    }

    public int getMemory(long l) {
        int n = CacheLongKeyLIRS.getHash(l);
        return this.getSegment(n).getMemory(l, n);
    }

    public V get(long l) {
        int n = CacheLongKeyLIRS.getHash(l);
        return this.getSegment(n).get(l, n);
    }

    private Segment<V> getSegment(int n) {
        int n2 = n >>> this.segmentShift & this.segmentMask;
        return this.segments[n2];
    }

    static int getHash(long l) {
        int n = (int)(l >>> 32 ^ l);
        n = (n >>> 16 ^ n) * 73244475;
        n = (n >>> 16 ^ n) * 73244475;
        n = n >>> 16 ^ n;
        return n;
    }

    public long getUsedMemory() {
        long l = 0L;
        for (Segment<V> segment : this.segments) {
            l += segment.usedMemory;
        }
        return l;
    }

    public void setMaxMemory(long l) {
        DataUtils.checkArgument(l > 0L, "Max memory must be larger than 0, is {0}", l);
        this.maxMemory = l;
        if (this.segments != null) {
            long l2 = 1L + l / (long)this.segments.length;
            for (Segment<V> segment : this.segments) {
                segment.setMaxMemory(l2);
            }
        }
    }

    public void setAverageMemory(int n) {
        DataUtils.checkArgument(n > 0, "Average memory must be larger than 0, is {0}", n);
        this.averageMemory = n;
        if (this.segments != null) {
            for (Segment<V> segment : this.segments) {
                segment.setAverageMemory(n);
            }
        }
    }

    public int getAverageMemory() {
        return this.averageMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public synchronized Set<Map.Entry<Long, V>> entrySet() {
        HashMap hashMap = new HashMap();
        for (long l : this.keySet()) {
            hashMap.put(l, this.find((long)l).value);
        }
        return hashMap.entrySet();
    }

    public synchronized Set<Long> keySet() {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (Segment<V> segment : this.segments) {
            hashSet.addAll(segment.keySet());
        }
        return hashSet;
    }

    public int sizeNonResident() {
        int n = 0;
        for (Segment<V> segment : this.segments) {
            n += segment.queue2Size;
        }
        return n;
    }

    public int sizeMapArray() {
        int n = 0;
        for (Segment<V> segment : this.segments) {
            n += segment.entries.length;
        }
        return n;
    }

    public int sizeHot() {
        int n = 0;
        for (Segment<V> segment : this.segments) {
            n += segment.mapSize - segment.queueSize - segment.queue2Size;
        }
        return n;
    }

    public int size() {
        int n = 0;
        for (Segment<V> segment : this.segments) {
            n += segment.mapSize - segment.queue2Size;
        }
        return n;
    }

    public synchronized List<Long> keys(boolean bl, boolean bl2) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Segment<V> segment : this.segments) {
            arrayList.addAll(segment.keys(bl, bl2));
        }
        return arrayList;
    }

    public List<V> values() {
        ArrayList arrayList = new ArrayList();
        for (long l : this.keySet()) {
            Object v = this.find((long)l).value;
            if (v == null) continue;
            arrayList.add(v);
        }
        return arrayList;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsValue(Object object) {
        return this.getMap().containsValue(object);
    }

    public Map<Long, V> getMap() {
        HashMap hashMap = new HashMap();
        for (long l : this.keySet()) {
            Object v = this.find((long)l).value;
            if (v == null) continue;
            hashMap.put(l, v);
        }
        return hashMap;
    }

    public void putAll(Map<Long, ? extends V> map) {
        for (Map.Entry<Long, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    static class Entry<V> {
        long key;
        V value;
        int memory;
        int topMove;
        Entry<V> stackNext;
        Entry<V> stackPrev;
        Entry<V> queueNext;
        Entry<V> queuePrev;
        Entry<V> mapNext;

        Entry() {
        }

        boolean isHot() {
            return this.queueNext == null;
        }
    }

    private static class Segment<V> {
        int mapSize;
        int queueSize;
        int queue2Size;
        Entry<V>[] entries;
        long usedMemory;
        private final int stackMoveDistance;
        private long maxMemory;
        private int averageMemory;
        private int mask;
        private int stackSize;
        private Entry<V> stack;
        private Entry<V> queue;
        private Entry<V> queue2;
        private int stackMoveCounter;

        Segment(long l, int n, int n2) {
            this.setMaxMemory(l);
            this.setAverageMemory(n);
            this.stackMoveDistance = n2;
            this.clear();
        }

        private void clear() {
            long l;
            long l2 = (long)((double)(this.maxMemory / (long)this.averageMemory) / 0.75);
            for (l = 8L; l < l2; l += l) {
            }
            int n = (int)Math.min(0x80000000L, l);
            this.mask = n - 1;
            this.stack = new Entry();
            this.stack.stackNext = this.stack;
            this.stack.stackPrev = this.stack.stackNext;
            this.queue = new Entry();
            this.queue.queueNext = this.queue;
            this.queue.queuePrev = this.queue.queueNext;
            this.queue2 = new Entry();
            this.queue2.queueNext = this.queue2;
            this.queue2.queuePrev = this.queue2.queueNext;
            this.entries = null;
            Entry[] entryArray = new Entry[n];
            this.entries = entryArray;
            this.mapSize = 0;
            this.usedMemory = 0L;
            this.queue2Size = 0;
            this.queueSize = 0;
            this.stackSize = 0;
        }

        int getMemory(long l, int n) {
            Entry<V> entry = this.find(l, n);
            return entry == null ? 0 : entry.memory;
        }

        V get(long l, int n) {
            Entry<V> entry = this.find(l, n);
            if (entry == null) {
                return null;
            }
            Object v = entry.value;
            if (v == null) {
                return null;
            }
            if (entry.isHot()) {
                if (entry != this.stack.stackNext && (this.stackMoveDistance == 0 || this.stackMoveCounter - entry.topMove > this.stackMoveDistance)) {
                    this.access(l, n);
                }
            } else {
                this.access(l, n);
            }
            return v;
        }

        private synchronized void access(long l, int n) {
            Entry<V> entry = this.find(l, n);
            if (entry == null || entry.value == null) {
                return;
            }
            if (entry.isHot()) {
                if (entry != this.stack.stackNext && (this.stackMoveDistance == 0 || this.stackMoveCounter - entry.topMove > this.stackMoveDistance)) {
                    boolean bl = entry == this.stack.stackPrev;
                    this.removeFromStack(entry);
                    if (bl) {
                        this.pruneStack();
                    }
                    this.addToStack(entry);
                }
            } else {
                this.removeFromQueue(entry);
                if (entry.stackNext != null) {
                    this.removeFromStack(entry);
                    this.convertOldestHotToCold();
                } else {
                    this.addToQueue(this.queue, entry);
                }
                this.addToStack(entry);
            }
        }

        synchronized V put(long l, int n, V v, int n2) {
            V v2;
            if (v == null) {
                throw DataUtils.newIllegalArgumentException("The value may not be null", new Object[0]);
            }
            Entry<V> entry = this.find(l, n);
            if (entry == null) {
                v2 = null;
            } else {
                v2 = entry.value;
                this.remove(l, n);
            }
            entry = new Entry();
            entry.key = l;
            entry.value = v;
            entry.memory = n2;
            int n3 = n & this.mask;
            entry.mapNext = this.entries[n3];
            this.entries[n3] = entry;
            this.usedMemory += (long)n2;
            if (this.usedMemory > this.maxMemory && this.mapSize > 0) {
                this.evict(entry);
            }
            ++this.mapSize;
            this.addToStack(entry);
            return v2;
        }

        synchronized V remove(long l, int n) {
            Object v;
            int n2 = n & this.mask;
            Entry<V> entry = this.entries[n2];
            if (entry == null) {
                return null;
            }
            if (entry.key == l) {
                v = entry.value;
                this.entries[n2] = entry.mapNext;
            } else {
                do {
                    Entry<V> entry2 = entry;
                    entry = entry.mapNext;
                    if (entry != null) continue;
                    return null;
                } while (entry.key != l);
                v = entry.value;
                entry2.mapNext = entry.mapNext;
            }
            --this.mapSize;
            this.usedMemory -= (long)entry.memory;
            if (entry.stackNext != null) {
                this.removeFromStack(entry);
            }
            if (entry.isHot()) {
                entry = this.queue.queueNext;
                if (entry != this.queue) {
                    this.removeFromQueue(entry);
                    if (entry.stackNext == null) {
                        this.addToStackBottom(entry);
                    }
                }
            } else {
                this.removeFromQueue(entry);
            }
            this.pruneStack();
            return v;
        }

        private void evict(Entry<V> entry) {
            while (this.queueSize <= this.mapSize >>> 5 && this.stackSize > 0) {
                this.convertOldestHotToCold();
            }
            if (this.stackSize > 0) {
                this.addToQueue(this.queue, entry);
            }
            while (this.usedMemory > this.maxMemory && this.queueSize > 1) {
                Entry entry2 = this.queue.queuePrev;
                this.usedMemory -= (long)entry2.memory;
                this.removeFromQueue(entry2);
                entry2.value = null;
                entry2.memory = 0;
                this.addToQueue(this.queue2, entry2);
                while (this.queue2Size + this.queue2Size > this.stackSize) {
                    entry2 = this.queue2.queuePrev;
                    int n = CacheLongKeyLIRS.getHash(entry2.key);
                    this.remove(entry2.key, n);
                }
            }
        }

        private void convertOldestHotToCold() {
            Entry entry = this.stack.stackPrev;
            if (entry == this.stack) {
                throw new IllegalStateException();
            }
            this.removeFromStack(entry);
            this.addToQueue(this.queue, entry);
            this.pruneStack();
        }

        private void pruneStack() {
            Entry entry;
            while (!(entry = this.stack.stackPrev).isHot()) {
                this.removeFromStack(entry);
            }
        }

        Entry<V> find(long l, int n) {
            int n2 = n & this.mask;
            Entry<V> entry = this.entries[n2];
            while (entry != null && entry.key != l) {
                entry = entry.mapNext;
            }
            return entry;
        }

        private void addToStack(Entry<V> entry) {
            entry.stackPrev = this.stack;
            entry.stackNext = this.stack.stackNext;
            entry.stackNext.stackPrev = entry;
            this.stack.stackNext = entry;
            ++this.stackSize;
            entry.topMove = this.stackMoveCounter++;
        }

        private void addToStackBottom(Entry<V> entry) {
            entry.stackNext = this.stack;
            entry.stackPrev = this.stack.stackPrev;
            entry.stackPrev.stackNext = entry;
            this.stack.stackPrev = entry;
            ++this.stackSize;
        }

        private void removeFromStack(Entry<V> entry) {
            entry.stackPrev.stackNext = entry.stackNext;
            entry.stackNext.stackPrev = entry.stackPrev;
            entry.stackNext = null;
            entry.stackPrev = null;
            --this.stackSize;
        }

        private void addToQueue(Entry<V> entry, Entry<V> entry2) {
            entry2.queuePrev = entry;
            entry2.queueNext = entry.queueNext;
            entry2.queueNext.queuePrev = entry2;
            entry.queueNext = entry2;
            if (entry2.value != null) {
                ++this.queueSize;
            } else {
                ++this.queue2Size;
            }
        }

        private void removeFromQueue(Entry<V> entry) {
            entry.queuePrev.queueNext = entry.queueNext;
            entry.queueNext.queuePrev = entry.queuePrev;
            entry.queueNext = null;
            entry.queuePrev = null;
            if (entry.value != null) {
                --this.queueSize;
            } else {
                --this.queue2Size;
            }
        }

        synchronized List<Long> keys(boolean bl, boolean bl2) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            if (bl) {
                Entry<V> entry = bl2 ? this.queue2 : this.queue;
                Entry entry2 = entry.queueNext;
                while (entry2 != entry) {
                    arrayList.add(entry2.key);
                    entry2 = entry2.queueNext;
                }
            } else {
                Entry entry = this.stack.stackNext;
                while (entry != this.stack) {
                    arrayList.add(entry.key);
                    entry = entry.stackNext;
                }
            }
            return arrayList;
        }

        boolean containsKey(long l, int n) {
            Entry<V> entry = this.find(l, n);
            return entry != null && entry.value != null;
        }

        synchronized Set<Long> keySet() {
            HashSet<Long> hashSet = new HashSet<Long>();
            Entry entry = this.stack.stackNext;
            while (entry != this.stack) {
                hashSet.add(entry.key);
                entry = entry.stackNext;
            }
            entry = this.queue.queueNext;
            while (entry != this.queue) {
                hashSet.add(entry.key);
                entry = entry.queueNext;
            }
            return hashSet;
        }

        void setMaxMemory(long l) {
            this.maxMemory = l;
        }

        void setAverageMemory(int n) {
            this.averageMemory = n;
        }
    }
}

