package com.franciaflex.faxtomail.ui.swing.content.pdfeditor;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.franciaflex.faxtomail.ui.swing.util.JImagePanel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class PDFEditorUI extends JPanel implements FaxToMailUI<PDFEditorUIModel, PDFEditorUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_NEXT_PAGE_BUTTON_ENABLED = "nextPageButton.enabled";
    public static final String BINDING_PAGE_NUMBER_MODEL_TEXT = "pageNumber.modelText";
    public static final String BINDING_PAGE_TOTAL_TEXT = "pageTotal.text";
    public static final String BINDING_PREV_PAGE_BUTTON_ENABLED = "prevPageButton.enabled";
    public static final String BINDING_ZOOM_LABEL_TEXT = "zoomLabel.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(PDFEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JAXXButtonGroup actionGroup;
    protected JSeparator actionGroupSeparator;
    protected JButton cancelButton;
    protected JPanel container;
    protected JToggleButton crossButton;
    protected JImagePanel documentPanel;
    protected JToggleButton hLineButton;
    protected final PDFEditorUIHandler handler = createHandler();
    protected JToggleButton highlighterButton;
    protected PDFEditorUIModel model;
    protected JButton nextPageButton;
    protected JToggleButton noteButton;
    protected NumberEditor pageNumber;
    protected JLabel pageTotal;
    protected PDFEditorUI pdfEditorUIPanel = this;
    protected JButton prevPageButton;
    protected JButton printButton;
    protected JButton rotateAntiClockwiseButton;
    protected JButton rotateClockwiseButton;
    protected JToolBar toolbar;
    protected JToggleButton vLineButton;
    protected JButton validateButton;
    protected JButton zoomInButton;
    protected JLabel zoomLabel;
    protected JButton zoomOutButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;
    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PDFEditorUI(FaxToMailUI parentUI) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public PDFEditorUI() {
        $initialize();
    }

    public PDFEditorUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PDFEditorUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PDFEditorUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PDFEditorUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__nextPageButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getModel().incPageIndex();
    }

    public void doActionPerformed__on__prevPageButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getModel().decPageIndex();
    }

    public void doActionPerformed__on__printButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.print();
    }

    public void doActionPerformed__on__rotateAntiClockwiseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.rotateAntiClockwise();
    }

    public void doActionPerformed__on__rotateClockwiseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.rotateClockwise();
    }

    public void doActionPerformed__on__zoomInButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.zoomIn();
    }

    public void doActionPerformed__on__zoomOutButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.zoomOut();
    }

    public void doMouseClicked__on__documentPanel(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addEditionComponent(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JAXXButtonGroup getActionGroup() {
        return actionGroup;
    }

    public JSeparator getActionGroupSeparator() {
        return actionGroupSeparator;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JPanel getContainer() {
        return container;
    }

    public JToggleButton getCrossButton() {
        return crossButton;
    }

    public JImagePanel getDocumentPanel() {
        return documentPanel;
    }

    public JToggleButton getHLineButton() {
        return hLineButton;
    }

    public PDFEditorUIHandler getHandler() {
        return handler;
    }

    public JToggleButton getHighlighterButton() {
        return highlighterButton;
    }

    public PDFEditorUIModel getModel() {
        return model;
    }

    public JButton getNextPageButton() {
        return nextPageButton;
    }

    public JToggleButton getNoteButton() {
        return noteButton;
    }

    public NumberEditor getPageNumber() {
        return pageNumber;
    }

    public JLabel getPageTotal() {
        return pageTotal;
    }

    public JButton getPrevPageButton() {
        return prevPageButton;
    }

    public JButton getPrintButton() {
        return printButton;
    }

    public JButton getRotateAntiClockwiseButton() {
        return rotateAntiClockwiseButton;
    }

    public JButton getRotateClockwiseButton() {
        return rotateClockwiseButton;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    public JToggleButton getVLineButton() {
        return vLineButton;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public JButton getZoomInButton() {
        return zoomInButton;
    }

    public JLabel getZoomLabel() {
        return zoomLabel;
    }

    public JButton getZoomOutButton() {
        return zoomOutButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContainer() {
        if (!allComponentsCreated) {
            return;
        }
        container.add(documentPanel);
    }

    protected void addChildrenToCrossButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = actionGroup; crossButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(crossButton); }
    }

    protected void addChildrenToHLineButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = actionGroup; hLineButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(hLineButton); }
    }

    protected void addChildrenToHighlighterButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = actionGroup; highlighterButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(highlighterButton); }
    }

    protected void addChildrenToNoteButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = actionGroup; noteButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(noteButton); }
    }

    protected void addChildrenToPdfEditorUIPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(toolbar, BorderLayout.NORTH);
        add($JScrollPane0, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(noteButton);
        toolbar.add(crossButton);
        toolbar.add(hLineButton);
        toolbar.add(vLineButton);
        toolbar.add(highlighterButton);
        toolbar.add(actionGroupSeparator);
        toolbar.add(prevPageButton);
        toolbar.add(pageNumber);
        toolbar.add(pageTotal);
        toolbar.add(nextPageButton);
        toolbar.add(zoomOutButton);
        toolbar.add(zoomLabel);
        toolbar.add(zoomInButton);
        toolbar.add(rotateClockwiseButton);
        toolbar.add(rotateAntiClockwiseButton);
        toolbar.add($JSeparator0);
        toolbar.add(printButton);
    }

    protected void addChildrenToVLineButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = actionGroup; vLineButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(vLineButton); }
    }

    protected void createActionGroup() {
        $objectMap.put("actionGroup", actionGroup = new JAXXButtonGroup());
    }

    protected void createActionGroupSeparator() {
        $objectMap.put("actionGroupSeparator", actionGroupSeparator = new JSeparator(SwingConstants.VERTICAL));
        
        actionGroupSeparator.setName("actionGroupSeparator");
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("faxtomail.pdfEditor.action.cancel"));
        cancelButton.setToolTipText(t("faxtomail.pdfEditor.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createContainer() {
        $objectMap.put("container", container = new JPanel());
        
        container.setName("container");
        container.setLayout(null);
    }

    protected void createCrossButton() {
        $objectMap.put("crossButton", crossButton = new JToggleButton());
        
        crossButton.setName("crossButton");
        { crossButton.putClientProperty("$value", "CROSS");  Object $buttonGroup = crossButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        crossButton.setToolTipText(t("faxtomail.pdfEditor.button.addCross.tip"));
    }

    protected void createDocumentPanel() {
        $objectMap.put("documentPanel", documentPanel = new JImagePanel());
        
        documentPanel.setName("documentPanel");
        documentPanel.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__documentPanel"));
    }

    protected void createHLineButton() {
        $objectMap.put("hLineButton", hLineButton = new JToggleButton());
        
        hLineButton.setName("hLineButton");
        { hLineButton.putClientProperty("$value", "HLINE");  Object $buttonGroup = hLineButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        hLineButton.setToolTipText(t("faxtomail.pdfEditor.button.addHLine.tip"));
    }

    protected PDFEditorUIHandler createHandler() {
        return new PDFEditorUIHandler();
    }

    protected void createHighlighterButton() {
        $objectMap.put("highlighterButton", highlighterButton = new JToggleButton());
        
        highlighterButton.setName("highlighterButton");
        { highlighterButton.putClientProperty("$value", "HIGHLIGHTER");  Object $buttonGroup = highlighterButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        highlighterButton.setToolTipText(t("faxtomail.pdfEditor.button.addHighlighter.tip"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new PDFEditorUIModel());
    }

    protected void createNextPageButton() {
        $objectMap.put("nextPageButton", nextPageButton = new JButton());
        
        nextPageButton.setName("nextPageButton");
        nextPageButton.setToolTipText(t("faxtomail.pdfEditor.button.nextPage"));
        nextPageButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__nextPageButton"));
    }

    protected void createNoteButton() {
        $objectMap.put("noteButton", noteButton = new JToggleButton());
        
        noteButton.setName("noteButton");
        { noteButton.putClientProperty("$value", "NOTE");  Object $buttonGroup = noteButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        noteButton.setSelected(true);
        noteButton.setToolTipText(t("faxtomail.pdfEditor.button.addNote.tip"));
    }

    protected void createPageNumber() {
        $objectMap.put("pageNumber", pageNumber = new NumberEditor(this));
        
        pageNumber.setName("pageNumber");
        pageNumber.setUseSign(false);
        pageNumber.setAutoPopup(false);
        SwingUtil.setComponentWidth(pageNumber,50);
        pageNumber.setProperty("currentPageIndex");
        pageNumber.setUseFloat(false);
        pageNumber.setShowReset(false);
        pageNumber.setShowPopupButton(false);
    }

    protected void createPageTotal() {
        $objectMap.put("pageTotal", pageTotal = new JLabel());
        
        pageTotal.setName("pageTotal");
    }

    protected void createPrevPageButton() {
        $objectMap.put("prevPageButton", prevPageButton = new JButton());
        
        prevPageButton.setName("prevPageButton");
        prevPageButton.setToolTipText(t("faxtomail.pdfEditor.button.previousPage"));
        prevPageButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__prevPageButton"));
    }

    protected void createPrintButton() {
        $objectMap.put("printButton", printButton = new JButton());
        
        printButton.setName("printButton");
        printButton.setToolTipText(t("faxtomail.pdfEditor.button.print"));
        printButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__printButton"));
    }

    protected void createRotateAntiClockwiseButton() {
        $objectMap.put("rotateAntiClockwiseButton", rotateAntiClockwiseButton = new JButton());
        
        rotateAntiClockwiseButton.setName("rotateAntiClockwiseButton");
        rotateAntiClockwiseButton.setToolTipText(t("faxtomail.pdfEditor.button.rotateAntiClockwise"));
        rotateAntiClockwiseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__rotateAntiClockwiseButton"));
    }

    protected void createRotateClockwiseButton() {
        $objectMap.put("rotateClockwiseButton", rotateClockwiseButton = new JButton());
        
        rotateClockwiseButton.setName("rotateClockwiseButton");
        rotateClockwiseButton.setToolTipText(t("faxtomail.pdfEditor.button.rotateClockwise"));
        rotateClockwiseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__rotateClockwiseButton"));
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
    }

    protected void createVLineButton() {
        $objectMap.put("vLineButton", vLineButton = new JToggleButton());
        
        vLineButton.setName("vLineButton");
        { vLineButton.putClientProperty("$value", "VLINE");  Object $buttonGroup = vLineButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        vLineButton.setToolTipText(t("faxtomail.pdfEditor.button.addVLine.tip"));
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("faxtomail.pdfEditor.action.validate"));
        validateButton.setToolTipText(t("faxtomail.pdfEditor.action.validate.tip"));
        validateButton.putClientProperty("applicationAction", com.franciaflex.faxtomail.ui.swing.content.pdfeditor.actions.GenerateAnnotatedAttachmentAction.class);
    }

    protected void createZoomInButton() {
        $objectMap.put("zoomInButton", zoomInButton = new JButton());
        
        zoomInButton.setName("zoomInButton");
        zoomInButton.setToolTipText(t("faxtomail.pdfEditor.button.zoomIn"));
        zoomInButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__zoomInButton"));
    }

    protected void createZoomLabel() {
        $objectMap.put("zoomLabel", zoomLabel = new JLabel());
        
        zoomLabel.setName("zoomLabel");
    }

    protected void createZoomOutButton() {
        $objectMap.put("zoomOutButton", zoomOutButton = new JButton());
        
        zoomOutButton.setName("zoomOutButton");
        zoomOutButton.setToolTipText(t("faxtomail.pdfEditor.button.zoomOut"));
        zoomOutButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__zoomOutButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToPdfEditorUIPanel();
        addChildrenToToolbar();
        addChildrenToNoteButton();
        addChildrenToCrossButton();
        addChildrenToHLineButton();
        addChildrenToVLineButton();
        addChildrenToHighlighterButton();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($JPanel0);
        // inline complete setup of $JPanel0
        $JPanel0.add(container);
        addChildrenToContainer();
        // inline complete setup of $JPanel1
        $JPanel1.add(cancelButton);
        $JPanel1.add(validateButton);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 21 property setters
        toolbar.setMargin(new java.awt.Insets(5, 0, 0, 5));
        noteButton.setIcon(SwingUtil.createActionIcon("note"));
        crossButton.setIcon(SwingUtil.createActionIcon("cross"));
        hLineButton.setIcon(SwingUtil.createActionIcon("hline"));
        vLineButton.setIcon(SwingUtil.createActionIcon("vline"));
        highlighterButton.setIcon(SwingUtil.createActionIcon("highlighter"));
        actionGroupSeparator.setBorder( BorderFactory.createEmptyBorder(0, 5, 0, 5) );
        prevPageButton.setIcon(SwingUtil.createActionIcon("left"));
        pageNumber.setBean( model );
        nextPageButton.setIcon(SwingUtil.createActionIcon("right"));
        zoomOutButton.setIcon(SwingUtil.createActionIcon("zoom-out"));
        zoomInButton.setIcon(SwingUtil.createActionIcon("zoom-in"));
        rotateClockwiseButton.setIcon(SwingUtil.createActionIcon("rotate-clockwise"));
        rotateAntiClockwiseButton.setIcon(SwingUtil.createActionIcon("rotate-anticlockwise"));
        $JSeparator0.setBorder( BorderFactory.createEmptyBorder(0, 5, 0, 5) );
        printButton.setIcon(SwingUtil.createActionIcon("print"));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        validateButton.setIcon(SwingUtil.createActionIcon("validate"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("pdfEditorUIPanel", pdfEditorUIPanel);
        createModel();
        createToolbar();
        createNoteButton();
        createCrossButton();
        createHLineButton();
        createVLineButton();
        createHighlighterButton();
        createActionGroupSeparator();
        createPrevPageButton();
        createPageNumber();
        createPageTotal();
        createNextPageButton();
        createZoomOutButton();
        createZoomLabel();
        createZoomInButton();
        createRotateClockwiseButton();
        createRotateAntiClockwiseButton();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator(SwingConstants.VERTICAL));
        
        $JSeparator0.setName("$JSeparator0");
        createPrintButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createContainer();
        createDocumentPanel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createValidateButton();
        createActionGroup();
        // inline creation of pdfEditorUIPanel
        setName("pdfEditorUIPanel");
        setLayout(new BorderLayout());
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PREV_PAGE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("currentPageIndex", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    prevPageButton.setEnabled( getModel().getCurrentPageIndex() > 1 );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("currentPageIndex", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PAGE_NUMBER_MODEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currentPageIndex", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    pageNumber.setModelText( String.valueOf(model.getCurrentPageIndex()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currentPageIndex", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PAGE_TOTAL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("pages", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getPages() != null) {
                    pageTotal.setText(t( " / " + String.valueOf(model.getPages().length) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("pages", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEXT_PAGE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("currentPageIndex", this);
                }
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("pages", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null && getModel().getPages() != null) {
                    nextPageButton.setEnabled( getModel().getCurrentPageIndex() < getModel().getPages().length );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("currentPageIndex", this);
                }
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("pages", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ZOOM_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("zoom", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    zoomLabel.setText(t( String.format("%.0f", model.getZoom() * 100) + "%"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("zoom", this);
                }
            }
        });
    }

}